unit UserSessionUnit;

{
  This is a DataModule where you can add components or declare fields that are specific to 
  ONE user. Instead of creating global variables, it is better to use this datamodule. You can then
  access the it using UserSession.
}
interface

uses
  IWUserSessionBase, SysUtils, Classes, DB, MConnect, DBClient, SConnect, SWSystem,
  MidasLib, Controls, DBGrids;

type
  TIWUserSession = class(TIWUserSessionBase)
    CdsConexao: TClientDataSet;
    Principal: TSocketConnection;
    Consulta: TSharedConnection;
    Cadastro: TSharedConnection;
    Relatorios: TSharedConnection;
    CDSToken: TClientDataSet;
    CDSTokenToken: TBooleanField;
    CdsControlaID: TClientDataSet;
    CdsControlaIDCAMPO: TStringField;
    CdsControlaIDVALOR: TFloatField;
    procedure IWUserSessionBaseCreate(Sender: TObject);
    procedure IWUserSessionBaseDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    nID   : Real;
    sNOME : String;
    sOPC  : String;
    procedure OrdenaDataSet(var CDS : TClientDataSet; Field: TField); stdcall;
    procedure AbreConexaoServers; stdcall;
    procedure FechaConexaoServers; stdcall;
    procedure ReabreConexaoServers; stdcall;
    procedure DelCliente(ID : Real); stdcall;
    procedure DelProduto(ID : Real); stdcall;
    function PegaData : TDate; stdcall;
    function PegaDataHora : TDateTime; stdcall;
    function PegaHora : String; stdcall;
    function RetornaID(Campo : String) : Real; stdcall;
    function RunSQL(Command : String) : Boolean; stdcall;
  end;

implementation

{$R *.dfm}

{ TIWUserSession }

procedure TIWUserSession.AbreConexaoServers;
begin
  CDSToken.CreateDataSet;
  CDSToken.Insert;
  CDSTokenToken.AsBoolean := True;
  CDSToken.Post;
  if not FileExists(gsAppPath + 'ConfigClientBSS.XML') then
  begin
    raise EDatabaseError.Create('Arquivo de configurao do cliente no encontrado');
    Exit;
  end;
  CdsConexao.Close;
  CdsConexao.LoadFromFile(gsAppPath + 'ConfigClientBSS.XML');
  try
    Principal.Connected := False;
    Principal.Port      := CdsConexao.Fields.FieldByName('Porta').AsInteger;
    Principal.Host      := Trim(CdsConexao.Fields.FieldByName('Host').AsString);
    Principal.Connected := True;
    Principal.AppServer.SetToken(CDSToken.Data);
  except
    raise EDatabaseError.Create('Classe Principal no conectada');
  end;
  CDSToken.Close;
end;

procedure TIWUserSession.DelCliente(ID: Real);
begin
  Principal.AppServer.DelCliente(ID);
end;

procedure TIWUserSession.DelProduto(ID: Real);
begin
  Principal.AppServer.DelProduto(ID);
end;

procedure TIWUserSession.FechaConexaoServers;
var
  i : Integer;
begin
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSharedConnection then
    begin
      (Components[i] as TSharedConnection).Connected := False;
    end;
  end;
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSocketConnection then
    begin
      (Components[i] as TSocketConnection).Connected := False;
    end;
  end;
end;

procedure TIWUserSession.IWUserSessionBaseCreate(Sender: TObject);
begin
  AbreConexaoServers;
end;

procedure TIWUserSession.IWUserSessionBaseDestroy(Sender: TObject);
begin
  FechaConexaoServers;
end;

procedure TIWUserSession.OrdenaDataSet(var CDS: TClientDataSet;
  Field: TField);
const
  idxDefault = 'DEFAULT_ORDER';
var
  strColumn : string;
  i         : integer;
  bolUsed   : boolean;
  idOptions : TIndexOptions;
begin
  strColumn := idxDefault;

  if Field.FieldKind in [fkCalculated, fkLookup, fkAggregate] then
    Exit;

  if Field.DataType in [ftBlob, ftMemo] then
    Exit;

  bolUsed := (Field.FieldName = CDS.IndexName);

  CDS.IndexDefs.Update;
  for i := 0 to CDS.IndexDefs.Count - 1 do
  begin
    if CDS.IndexDefs.Items[i].Name = Field.FieldName then
    begin
      strColumn := Field.FieldName;
      case (CDS.IndexDefs.Items[i].Options = [ixDescending]) of
        True  : idOptions := [];
        False : idOptions := [ixDescending];
      end;
    end;
  end;

  if (strColumn = idxDefault) or (bolUsed) then
  begin
    if bolUsed then
      CDS.DeleteIndex(Field.FieldName);
    try
      CDS.AddIndex(Field.FieldName,
                   Field.FieldName,
                   idOptions,
                   '',
                   '',
                   0);
      strColumn := Field.FieldName;
    except
      if bolUsed then
        strColumn := idxDefault;
    end;
  end;

  try
    CDS.IndexName := strColumn;
  except
    CDS.IndexName := idxDefault;
  end;
end;

function TIWUserSession.PegaData: TDate;
var
  sAux : String;
begin
  sAux   := Principal.AppServer.PegaData;
  Result := StrToDate(sAux);
end;

function TIWUserSession.PegaDataHora: TDateTime;
var
  sAux : String;
begin
  sAux   := Principal.AppServer.PegaDataHora;
  Result := StrToDate(FormatDateTime('dd/mm/yyyy', (StrToDate(sAux))));
end;

function TIWUserSession.PegaHora: String;
begin
  Result := Principal.AppServer.PegaHora;
end;

procedure TIWUserSession.ReabreConexaoServers;
var
  i : Integer;
begin
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSharedConnection then
    begin
      (Components[i] as TSharedConnection).Connected := False;
    end;
  end;
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSocketConnection then
    begin
      (Components[i] as TSocketConnection).Connected := False;
    end;
  end;

  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSocketConnection then
    begin
      CDSToken.CreateDataSet;
      CDSToken.Insert;
      CDSTokenToken.AsBoolean := True;
      CDSToken.Post;
      (Components[i] as TSocketConnection).Connected := True;
      Principal.AppServer.SetToken(CDSToken.Data);
      CDSToken.Close;  
    end;
  end;
end;

function TIWUserSession.RetornaID(Campo: String): Real;
var
  n : Real;
begin
  n := 0;
  CdsControlaID.CreateDataSet;
  CdsControlaID.Insert;
  CdsControlaIDCAMPO.AsString := UpperCase(Campo);
  CdsControlaIDVALOR.AsFloat  := 0;
  CdsControlaID.Post;
  CdsControlaID.Data := Principal.AppServer.RetornaID(CdsControlaID.Data);

  if CdsControlaIDVALOR.AsFloat = -1 then
  begin
    raise EDatabaseError.Create('Erro na obteno de chave primria para o campo ' + CdsControlaIDCAMPO.AsString);
    n := -1;
  end
  else if CdsControlaIDVALOR.AsFloat > 0 then
  begin
    n := CdsControlaIDVALOR.AsFloat;
  end;
  CdsControlaID.Close;
  Result := n;
end;

function TIWUserSession.RunSQL(Command: String): Boolean;
var
  sAux : String;
begin
  sAux := Principal.AppServer.RunSQL(Command);
  if sAux = '0' then
    Result := True
  else
    Result := False;
end;

end.