unit UCadClientes;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastro, DB, DBClient, ImgList, Menus, ExtCtrls, ComCtrls, ToolWin,
  StdCtrls, Mask, Buttons, Grids, DBGrids, DBCtrls, ExtDlgs, JPEG;

type
  TFrmCadClientes = class(TFrmCadastro)
    CDSID_CLIENTE: TFloatField;
    CDSNOME: TStringField;
    CDSCPF: TStringField;
    CDSSTATUS: TStringField;
    CDSENDERECO: TStringField;
    CDSBAIRRO: TStringField;
    CDSCIDADE: TStringField;
    CDSESTADO: TStringField;
    CDSDATACAD: TSQLTimeStampField;
    CDSFOTO: TBlobField;
    CDSVirtStatus: TStringField;
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    Label4: TLabel;
    DBEdit4: TDBEdit;
    Label5: TLabel;
    DBEdit5: TDBEdit;
    Label6: TLabel;
    DBEdit6: TDBEdit;
    Label7: TLabel;
    DBEdit7: TDBEdit;
    Label8: TLabel;
    DBEdit8: TDBEdit;
    DBImage1: TDBImage;
    DBCheckBox1: TDBCheckBox;
    OpdFoto: TOpenPictureDialog;
    PopupMenu1: TPopupMenu;
    mnAtivar: TMenuItem;
    mnDesativar: TMenuItem;
    Label9: TLabel;
    procedure CDSCalcFields(DataSet: TDataSet);
    procedure DBImage1DblClick(Sender: TObject);
    procedure CDSAfterInsert(DataSet: TDataSet);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure mnAtivarClick(Sender: TObject);
    procedure mnDesativarClick(Sender: TObject);
  private

  public
    { Public declarations }
  end;

var
  FrmCadClientes: TFrmCadClientes;

implementation

uses UDM;

{$R *.dfm}

procedure TFrmCadClientes.CDSAfterInsert(DataSet: TDataSet);
begin
  inherited;
  CDSDATACAD.AsDateTime := DM.PegaData;
  CDSSTATUS.AsString    := '1';
  DBEdit2.SetFocus;
end;

procedure TFrmCadClientes.CDSCalcFields(DataSet: TDataSet);
begin
  inherited;
  if CDS.State = dsInternalCalc then
  begin
    if CDSSTATUS.AsString = '0' then
      CDSVirtStatus.AsString := 'Inativo'
    else if CDSSTATUS.AsString = '1' then
      CDSVirtStatus.AsString := 'Ativo';
  end;
end;

procedure TFrmCadClientes.DBImage1DblClick(Sender: TObject);
begin
  inherited;
  if CDS.State in [dsInsert, dsEdit] then
  begin
    if OpdFoto.Execute then
    begin
      DBImage1.Picture.LoadFromFile(OpdFoto.FileName);
    end;
  end;
end;

procedure TFrmCadClientes.mnAtivarClick(Sender: TObject);
begin
  inherited;
  DM.SetClienteActive(CDSID_CLIENTE.AsFloat);
  CDS.RefreshRecord;
end;

procedure TFrmCadClientes.mnDesativarClick(Sender: TObject);
begin
  inherited;
  DM.SetClienteInactive(CDSID_CLIENTE.AsFloat);
  CDS.RefreshRecord;
end;

procedure TFrmCadClientes.PopupMenu1Popup(Sender: TObject);
begin
  inherited;
  if CDS.Active and (CDS.RecordCount > 0) then
  begin
    if CDSSTATUS.AsString = '1' then
    begin
      mnAtivar.Enabled    := False;
      mnDesativar.Enabled := True;
    end
    else if CDSSTATUS.AsString = '0' then
    begin
      mnAtivar.Enabled    := True;
      mnDesativar.Enabled := False;
    end;
  end
  else
  begin
    mnAtivar.Enabled    := False;
    mnDesativar.Enabled := False;
  end;
end;

end.
