unit UCadPedidos;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, Menus, ExtCtrls, ComCtrls, ToolWin, DBCtrls, StdCtrls,
  Mask, Buttons, Grids, DBGrids, FMTBcd, DB, DBClient, Provider, SqlExpr,
  IdBaseComponent, IdComponent,
  IdRawBase, IdRawClient, IdIcmpClient, MidasLib;

type
  TFrmCadPedidos = class(TForm)
    pgcPrin: TPageControl;
    pgVisaoGeral: TTabSheet;
    Panel4: TPanel;
    dbgPrin: TDBGrid;
    pnFiltro: TPanel;
    pgDados: TTabSheet;
    pnEdit: TPanel;
    pnOk: TPanel;
    btOk: TBitBtn;
    Panel7: TPanel;
    Panel26: TPanel;
    btCancela: TBitBtn;
    pnOpc: TPanel;
    pnMM: TPanel;
    PanelMicro: TPanel;
    ToolBar1: TToolBar;
    btBusca: TToolButton;
    btAltera: TToolButton;
    btInclui: TToolButton;
    btExclui: TToolButton;
    btSair: TToolButton;
    sbRodape: TStatusBar;
    tiAgora: TTimer;
    imlOpcDisable: TImageList;
    imlOpcEnable: TImageList;
    CDS: TClientDataSet;
    DsCDS: TDataSource;
    btAnterior: TSpeedButton;
    btProximo: TSpeedButton;
    btPrimeiro: TSpeedButton;
    btUltimo: TSpeedButton;
    PanelData: TPanel;
    Calendario: TMonthCalendar;
    SbFechar: TSpeedButton;
    SbOK: TSpeedButton;
    bgBusca: TGroupBox;
    pnBuscaBotao: TPanel;
    btAplicaFiltro: TBitBtn;
    anFiltro: TAnimate;
    pnBuscaDF: TPanel;
    ltLocaliza: TLabel;
    btApagaPesquisa: TSpeedButton;
    btQntLinhas: TSpeedButton;
    dfRecCount: TLabel;
    cbCompleto: TCheckBox;
    CDSSub: TClientDataSet;
    DsSub: TDataSource;
    CDSID_PEDIDO: TFloatField;
    CDSID_CLIENTE: TFloatField;
    CDSDATAPED: TSQLTimeStampField;
    CDSNOME: TStringField;
    CDSCPF: TStringField;
    CDSSubID_PEDIDO: TFloatField;
    CDSSubID_PRODUTO: TFloatField;
    CDSSubQUANTIDADE: TFloatField;
    CDSSubPRECOVENDA: TFloatField;
    CDSSubDESCRICAO: TStringField;
    edtLocaliza: TMaskEdit;
    DtpInicio: TDateTimePicker;
    DtpFinal: TDateTimePicker;
    Label1: TLabel;
    Label2: TLabel;
    DBEdit1: TDBEdit;
    Label3: TLabel;
    DBEdit2: TDBEdit;
    Label4: TLabel;
    DBEdit3: TDBEdit;
    Label5: TLabel;
    DBEdit4: TDBEdit;
    sbtBuscaCliente: TSpeedButton;
    Panel1: TPanel;
    pnSec: TPanel;
    Panel5: TPanel;
    BtSubIncluir: TSpeedButton;
    BtSubAlterar: TSpeedButton;
    BtSubExcluir: TSpeedButton;
    dbnSub: TDBNavigator;
    pgcSub: TPageControl;
    TbsSubGeral: TTabSheet;
    pnDetSecGer: TPanel;
    DBGridSub: TDBGrid;
    TbsSubdetalhes: TTabSheet;
    pnDetSecDet: TPanel;
    Panel2: TPanel;
    BtSubGravar: TBitBtn;
    Panel6: TPanel;
    BtSubCancelar: TBitBtn;
    CDSSubVirtTotal: TFloatField;
    CDSSubVirtTotalGeral: TAggregateField;
    GroupBox1: TGroupBox;
    DBText1: TDBText;
    Label6: TLabel;
    DBEdit5: TDBEdit;
    Label7: TLabel;
    DBEdit6: TDBEdit;
    Label8: TLabel;
    DBEdit7: TDBEdit;
    Label9: TLabel;
    DBEdit8: TDBEdit;
    sbtConsProdutos: TSpeedButton;
    CdsPedidos: TClientDataSet;
    CdsPedidosID_CLIENTE: TFloatField;
    CdsPedidosDATAPED: TSQLTimeStampField;
    CdsItens: TClientDataSet;
    CdsItensID_PRODUTO: TFloatField;
    CdsItensQUANTIDADE: TFloatField;
    CdsItensPRECOVENDA: TFloatField;
    PopupMenu1: TPopupMenu;
    DuplicarPedido1: TMenuItem;
    CdsPedidosID_PEDIDO: TFloatField;
    TbsPedidosProc: TTabSheet;
    DtpProcIni: TDateTimePicker;
    DtpProcFim: TDateTimePicker;
    CdsPedidosProc: TClientDataSet;
    DsPedidosProc: TDataSource;
    CdsPedidosProcID_PEDIDO: TFloatField;
    CdsPedidosProcDATAPED: TSQLTimeStampField;
    BtExecProc: TButton;
    DBGrid1: TDBGrid;
    SpeedButton1: TSpeedButton;
    Label10: TLabel;
    DBText2: TDBText;
    CDSSubVirtCount: TAggregateField;
    Label11: TLabel;
    Label12: TLabel;
    procedure btAplicaFiltroClick(Sender: TObject);
    procedure btAlteraClick(Sender: TObject);
    procedure btIncluiClick(Sender: TObject);
    procedure btExcluiClick(Sender: TObject);
    procedure btSairClick(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btCancelaClick(Sender: TObject);
    procedure tiAgoraTimer(Sender: TObject);
    procedure edtLocalizaKeyPress(Sender: TObject; var Key: Char);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btBuscaClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TestaEstado(DataSet: TDataSet);
    procedure CDSBeforePost(DataSet: TDataSet);
    procedure CDSReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure CdigoEmitentePagRecHistrico1Click(Sender: TObject);
    procedure CdigodoRegistro1Click(Sender: TObject);
    procedure btAjudaClick(Sender: TObject);
    procedure btAnteriorClick(Sender: TObject);
    procedure btProximoClick(Sender: TObject);
    procedure btPrimeiroClick(Sender: TObject);
    procedure btUltimoClick(Sender: TObject);
    procedure btApagaPesquisaClick(Sender: TObject);
    procedure CalendarioDblClick(Sender: TObject);
    procedure SbFecharClick(Sender: TObject);
    procedure DsCDSDataChange(Sender: TObject; Field: TField);
    procedure DsCDSStateChange(Sender: TObject);
    procedure dbgPrinTitleClick(Column: TColumn);
    procedure FormCreate(Sender: TObject);
    procedure btQntLinhasClick(Sender: TObject);
    procedure btRefazClick(Sender: TObject);
    procedure EdtCodigoKeyPress(Sender: TObject; var Key: Char);
    procedure EdtCodigoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edtLocalizaKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OrdenaCDSGrid(var CDS : TClientDataSet; Column : TColumn; var dbgPrin : TDBGrid); stdcall;
    procedure CDSAfterPost(DataSet: TDataSet);
    procedure CDSBeforeOpen(DataSet: TDataSet);
    procedure sbtBuscaClienteClick(Sender: TObject);
    procedure pgDadosShow(Sender: TObject);
    procedure DsSubDataChange(Sender: TObject; Field: TField);
    procedure DsSubStateChange(Sender: TObject);
    procedure TestaEstadoSub(var CdsMov : TClientDataSet);
    procedure BtSubIncluirClick(Sender: TObject);
    procedure BtSubAlterarClick(Sender: TObject);
    procedure BtSubExcluirClick(Sender: TObject);
    procedure BtSubGravarClick(Sender: TObject);
    procedure BtSubCancelarClick(Sender: TObject);
    procedure CDSSubAfterOpen(DataSet: TDataSet);
    procedure CDSSubAfterPost(DataSet: TDataSet);
    procedure CDSSubBeforeOpen(DataSet: TDataSet);
    procedure CDSSubBeforePost(DataSet: TDataSet);
    procedure CDSSubBeforeInsert(DataSet: TDataSet);
    procedure DBGridSubTitleClick(Column: TColumn);
    procedure CDSSubCalcFields(DataSet: TDataSet);
    procedure CDSSubAfterInsert(DataSet: TDataSet);
    procedure sbtConsProdutosClick(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure DuplicarPedido1Click(Sender: TObject);
    procedure BtExecProcClick(Sender: TObject);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure SpeedButton1Click(Sender: TObject);
    procedure CDSBeforeInsert(DataSet: TDataSet);
  private
    NomeCampo : String;
    procedure ExcluiItensPedido(ID : Real); stdcall;
  public
    { Public declarations }
  end;

var
  FrmCadPedidos: TFrmCadPedidos;

implementation

uses UDM, UConsClientes, UConsProdutos;

{$R *.dfm}

procedure TFrmCadPedidos.btAplicaFiltroClick(Sender: TObject);
begin
  Screen.Cursor               := crHourGlass;
  btAplicaFiltro.Visible      := False;
  anFiltro.Reset;
  anFiltro.Show;
  anFiltro.Play(anFiltro.StartFrame, anFiltro.StopFrame, 0);

  CDS.Close;
  if edtLocaliza.Visible then
  begin
    if not cbCompleto.Checked then
    begin
      CDS.Params[0].AsString  := edtLocaliza.Text  + '%';
    end
    else
    begin
      CDS.Params[0].AsString  := '%' + edtLocaliza.Text  + '%';
    end;
  end;
  CDS.Params[1].AsDate      := DtpInicio.Date;
  CDS.Params[2].AsDate      := DtpFinal.Date;
  CDS.IndexName             := 'DEFAULT_ORDER';
  CDS.Open;

  if not (edtLocaliza.Text = '') and edtLocaliza.Visible then
    sbRodape.Panels[2].Text   := sbRodape.Panels[2].Text+' Descrio -> '+Trim(edtLocaliza.Text)
  else
    sbRodape.Panels[2].Text   := 'Sem Filtro';

  sbRodape.Panels[1].Text     := 'Visualizando';
  anFiltro.Stop;
  anFiltro.Hide;
  btAplicaFiltro.Visible      := True;
  dbgPrinTitleClick(dbgPrin.Columns[1]);
  CDS.First;
  dfRecCount.Caption          := '---------------';
  btQntLinhasClick(Self);
  Screen.Cursor               := crDefault;
  TestaEstado(CDS);
end;

procedure TFrmCadPedidos.btAlteraClick(Sender: TObject);
begin
  CDS.Edit;
end;

procedure TFrmCadPedidos.btIncluiClick(Sender: TObject);
begin
  if not CDS.Active then
    begin
      CDS.Close;
      CDS.Params[0].AsString := '-1';
      CDS.Params[1].AsDate   := 1;
      CDS.Params[2].AsDate   := 1;      
      CDS.Open;
    end;
  CDS.Insert;
  CDSDATAPED.AsDateTime := DM.PegaData;
  DBEdit4.SetFocus;
end;

procedure TFrmCadPedidos.btExcluiClick(Sender: TObject);
begin
  if CDS.FieldByName(CDS.Fields[0].FieldName).AsFloat = 0 then
  begin
    ShowMessage('Linha no pode ser excluda');
    exit;
  end;
  if CDS.RecordCount > 0 then
  begin
    CDSSub.Close;
    ExcluiItensPedido(CDSID_PEDIDO.AsFloat);
    pgcPrin.ActivePageIndex := 0;
    CDS.Delete;
    CDS.ApplyUpdates(0);
  end;
end;

procedure TFrmCadPedidos.BtExecProcClick(Sender: TObject);
begin
  CdsPedidosProc.Close;
  CdsPedidosProc.IndexName := 'DEFAULT_ORDER';
  CdsPedidosProc.Params[0].AsDate := DtpProcIni.Date;
  CdsPedidosProc.Params[1].AsDate := DtpProcFim.Date;
  CdsPedidosProc.Open;
end;

procedure TFrmCadPedidos.btSairClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmCadPedidos.BtSubAlterarClick(Sender: TObject);
begin
  if (not CDSSub.Active) or (CDSSub.RecordCount <= 0) then Exit;
  CDSSub.Edit;
  pgcSub.ActivePageIndex := 1;
end;

procedure TFrmCadPedidos.BtSubCancelarClick(Sender: TObject);
begin
  CDSSub.Cancel;
  CDSSub.Refresh;
  pgcSub.ActivePage := TbsSubGeral;
end;

procedure TFrmCadPedidos.BtSubExcluirClick(Sender: TObject);
begin
  if CDS.RecordCount > 0 then
  begin
    CDSSub.Delete;
    CDSSub.ApplyUpdates(0);
  end;
end;

procedure TFrmCadPedidos.BtSubGravarClick(Sender: TObject);
begin
  CDSSub.Post;
  CDSSub.Refresh;
  pgcSub.ActivePage := TbsSubGeral;
end;

procedure TFrmCadPedidos.BtSubIncluirClick(Sender: TObject);
begin
  if not CDSSub.Active then CDSSub.Open;
  CDSSub.Insert;
  pgcSub.ActivePageIndex          := 1;
end;

procedure TFrmCadPedidos.btOkClick(Sender: TObject);
begin
  if CDS.State in [dsinsert,dsedit] then CDS.Post;
end;

procedure TFrmCadPedidos.btCancelaClick(Sender: TObject);
var
  bVolta : Boolean;
begin
  if CDS.State = dsInsert then
    bVolta := True
  else
    bVolta := False;
  CDS.Cancel;
  if bVolta then
    pgcPrin.ActivePageIndex := 0;
end;

procedure TFrmCadPedidos.tiAgoraTimer(Sender: TObject);
begin
   sbRodape.Panels[0].Text := TimeToStr(Time);
end;

procedure TFrmCadPedidos.edtLocalizaKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    begin
      btAplicaFiltroClick(self);
    end;
end;

procedure TFrmCadPedidos.ExcluiItensPedido(ID: Real);
var
  sSQL : String;
begin
  sSQL := ' DELETE FROM ITENS WHERE ID_PEDIDO = ' + FloatToStr(ID);
  DM.RunSQL(sSQL);
end;

procedure TFrmCadPedidos.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if btOk.Visible then
  begin
    showMessage('Operao Em Andamento');
    CanClose := False;
  end;
end;

procedure TFrmCadPedidos.btBuscaClick(Sender: TObject);
begin
  if not (pgcPrin.ActivePage = pgVisaoGeral) then begin
    if not pnFiltro.Visible then begin
       btBusca.Down     := not pnFiltro.Visible;
       pnFiltro.Visible := not pnFiltro.Visible;
    end else
       btBusca.Down     := true;
    pgcPrin.ActivePage  := pgVisaoGeral;
  end else begin
    btBusca.Down        := not pnFiltro.Visible;
    pnFiltro.Visible    := not pnFiltro.Visible;
  end;
  if pnFiltro.Visible then
  begin
    if edtLocaliza.Visible then
      edtLocaliza.SetFocus;
  end;
end;

procedure TFrmCadPedidos.FormShow(Sender: TObject);
var
  i : Integer;
begin
  pgcPrin.ActivePageIndex      := 0;
  pgcSub.ActivePageIndex       := 0;

  for i := 0 to pgcPrin.PageCount -1 do
  begin
    pgcPrin.Pages[i].Brush.Color := clBlack;
    pgcPrin.Pages[i].PageControl.Brush.Color := clBlack;
  end;
  pgcPrin.Brush.Color := clBlack;

  for i := 0 to pgcSub.PageCount -1 do
  begin
    pgcSub.Pages[i].Brush.Color := clBlack;
    pgcSub.Pages[i].PageControl.Brush.Color := clBlack;
  end;
  pgcSub.Brush.Color := clBlack;

  sbRodape.Color      := clBlack;

  TestaEstado(CDS);
  try
    if pnFiltro.Visible then
    begin
      if edtLocaliza.Visible then
        edtLocaliza.SetFocus;
    end;
  except
  end;
  Screen.Cursor               := crDefault;
end;

procedure TFrmCadPedidos.TestaEstado(DataSet: TDataSet);
begin
  if DataSet.Tag = 0 then
  begin
    if DataSet.State = dsBrowse then
    begin
      btOk.Visible               := False;
      btCancela.Visible          := False;
      btInclui.Enabled           := True;
      btAltera.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btExclui.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btBusca.Enabled            := True;
      btPrimeiro.Enabled         := (not CDS.Bof);
      btProximo.Enabled          := (not CDS.Eof);
      btAnterior.Enabled         := (not CDS.Bof);
      btUltimo.Enabled           := (not CDS.Eof);
      btQntLinhas.Enabled        := (not CDS.Eof) or (not CDS.Bof);
      pgVisaoGeral.Enabled       := True;
      sbRodape.Panels[1].Text    := 'Visualizando';
      dbgPrin.Enabled            := True;
    end
    else if DsCDS.State in [dsEdit, dsInsert] then
    begin
      btPrimeiro.Enabled         := False;
      btProximo.Enabled          := False;
      btAnterior.Enabled         := False;
      btUltimo.Enabled           := False;
      btQntLinhas.Enabled        := False;
      btOk.Visible               := True;
      btCancela.Visible          := True;
      btInclui.Enabled           := False;
      btAltera.Enabled           := False;
      btExclui.Enabled           := False;
      btBusca.Enabled            := False;
      dbgPrin.Enabled            := False;
      if DsCDS.State = dsEdit then
        sbRodape.Panels[1].Text:= 'Alterando'
      else
        sbRodape.Panels[1].Text:= 'Incluindo';
      if pgcPrin.ActivePageIndex <> 1 then
        pgcPrin.ActivePageIndex  := 1;
    end
    else
    begin
      btOk.Visible               := False;
      btCancela.Visible          := False;
      btInclui.Enabled           := True;
      btAltera.Enabled           := False;
      btExclui.Enabled           := False;
      btBusca.Enabled            := True;
      btPrimeiro.Enabled         := False;
      btProximo.Enabled          := False;
      btAnterior.Enabled         := False;
      btUltimo.Enabled           := False;
      btQntLinhas.Enabled        := False;
      pgVisaoGeral.Enabled       := True;
      sbRodape.Panels[1].Text    := 'Banco Fechado';
      dbgPrin.Enabled            := True;
    end;
  end
  else
  begin
    if DataSet.State = dsBrowse then
    begin
      btOk.Visible               := False;
      btCancela.Visible          := False;
      btInclui.Enabled           := True;
      btAltera.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btExclui.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btBusca.Enabled            := True;
      btPrimeiro.Enabled         := (not CDS.Bof);
      btProximo.Enabled          := (not CDS.Eof);
      btAnterior.Enabled         := (not CDS.Bof);
      btUltimo.Enabled           := (not CDS.Eof);
      btQntLinhas.Enabled        := (not CDS.Eof) or (not CDS.Bof);
      pgVisaoGeral.Enabled       := True;
      sbRodape.Panels[1].Text    := 'Visualizando';
      dbgPrin.Enabled            := True;
    end;
  end;
  TestaEstadoSub(CdsSub);  
end;

procedure TFrmCadPedidos.TestaEstadoSub(var CdsMov: TClientDataSet);
begin
  if CdsMov.State = dsBrowse then
  begin
    BtSubIncluir.Enabled    := True;
    BtSubAlterar.Enabled    := ((not CdsMov.Eof) or (not CdsMov.Bof));
    BtSubExcluir.Enabled    := ((not CdsMov.Eof) or (not CdsMov.Bof));
    BtSubGravar.Enabled   := False;
    BtSubCancelar.Enabled := False;
    dbnSub.Enabled        := True;
    pnOpc.Enabled         := True;
  end
  else if CdsMov.State in [dsEdit, dsInsert] then
  begin
    BtSubIncluir.Enabled    := False;
    BtSubAlterar.Enabled    := False;
    BtSubExcluir.Enabled    := False;
    BtSubGravar.Enabled   := True;
    BtSubCancelar.Enabled := True;
    dbnSub.Enabled        := False;
    pnOpc.Enabled         := False;
  end
  else
  begin
    BtSubIncluir.Enabled    := True;
    BtSubAlterar.Enabled    := False;
    BtSubExcluir.Enabled    := False;
    BtSubGravar.Enabled   := False;
    BtSubCancelar.Enabled := False;
    dbnSub.Enabled        := True;
    pnOpc.Enabled         := True;
  end;
end;

procedure TFrmCadPedidos.CDSBeforePost(DataSet: TDataSet);
begin
  if DsCDS.State = dsInsert then
  begin
    try
      CDS.Fields[0].AsFloat := DM.RetornaID(CDS.Fields[0].FieldName);
    except
      CDS.Fields[0].AsFloat := 0;
    end;
  end;
end;

procedure TFrmCadPedidos.CDSReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  raise EDatabaseError.Create(e.Message);
end;

procedure TFrmCadPedidos.CDSSubAfterInsert(DataSet: TDataSet);
begin
  CDSSubQUANTIDADE.AsFloat := 1;
  CDSSubPRECOVENDA.AsFloat := 0;
end;

procedure TFrmCadPedidos.CDSSubAfterOpen(DataSet: TDataSet);
begin
  CDSSub.AddIndex('DESCRICAO', 'DESCRICAO', []);
  CDSSub.IndexDefs.Update;
  CDSSub.IndexName:= 'DESCRICAO';
end;

procedure TFrmCadPedidos.CDSSubAfterPost(DataSet: TDataSet);
begin
  CDSSub.ApplyUpdates(0);
  CDSSub.RefreshRecord;
end;

procedure TFrmCadPedidos.CDSSubBeforeInsert(DataSet: TDataSet);
begin
  if CDS.State in [dsInsert, dsEdit] then
  begin
    CDS.Post;
  end;
end;

procedure TFrmCadPedidos.CDSSubBeforeOpen(DataSet: TDataSet);
begin
  CDSSub.IndexName := 'DEFAULT_ORDER';
end;

procedure TFrmCadPedidos.CDSSubBeforePost(DataSet: TDataSet);
begin
  CDSSubID_PEDIDO.AsFloat := CDSID_PEDIDO.AsFloat;
end;

procedure TFrmCadPedidos.CDSSubCalcFields(DataSet: TDataSet);
begin
  if CDSSub.State = DsInternalCalc then
  begin
    CDSSubVirtTotal.AsFloat := CDSSubQUANTIDADE.AsFloat *
                               CDSSubPRECOVENDA.AsFloat;
  end;
end;

procedure TFrmCadPedidos.CdigoEmitentePagRecHistrico1Click(Sender: TObject);
begin
  dbgPrinTitleClick(dbgPrin.Columns[0]);
end;

procedure TFrmCadPedidos.CdigodoRegistro1Click(Sender: TObject);
begin
  dbgPrinTitleClick(dbgPrin.Columns[1]);
end;

procedure TFrmCadPedidos.btAjudaClick(Sender: TObject);
begin
  Perform(WM_SYSCOMMAND, SC_CONTEXTHELP, 0)
end;

procedure TFrmCadPedidos.btAnteriorClick(Sender: TObject);
begin
  CDS.Prior;
  TestaEstado(CDS);
end;

procedure TFrmCadPedidos.btProximoClick(Sender: TObject);
begin
  CDS.Next;
  TestaEstado(CDS);
end;

procedure TFrmCadPedidos.btPrimeiroClick(Sender: TObject);
begin
  CDS.First;
  TestaEstado(CDS);
end;

procedure TFrmCadPedidos.btUltimoClick(Sender: TObject);
begin
  CDS.Last;
  TestaEstado(CDS);
end;

procedure TFrmCadPedidos.btApagaPesquisaClick(Sender: TObject);
begin
  edtLocaliza.Text := '';
end;

procedure TFrmCadPedidos.CalendarioDblClick(Sender: TObject);
begin
  CDS.FieldByName(NomeCampo).AsDateTime := Calendario.Date;
  PanelData.Visible := False;
end;

procedure TFrmCadPedidos.SbFecharClick(Sender: TObject);
begin
  PanelData.Visible := False;
end;

procedure TFrmCadPedidos.sbtBuscaClienteClick(Sender: TObject);
begin
  if CDS.State in [dsInsert, dsEdit] then
  begin
    ID := 0;
    try
      Application.CreateForm(TFrmConsClientes, FrmConsClientes);
      FrmConsClientes.ShowModal;
    finally
      FrmConsClientes.Release;
    end;
    if (ID = 0) then
    begin
      ShowMessage('Voc no selecionou nenhum cliente!');
    end
    else if (ID > 0) then
    begin
      CDSID_CLIENTE.AsFloat := ID;
      CDSNOME.AsString      := NomeDesceicao;
    end;
  end;
end;

procedure TFrmCadPedidos.sbtConsProdutosClick(Sender: TObject);
begin
  if CDSSub.State in [dsInsert, dsEdit] then
  begin
    ID := 0;
    try
      Application.CreateForm(TFrmConsProdutos, FrmConsProdutos);
      FrmConsProdutos.ShowModal;
    finally
      FrmConsProdutos.Release;
    end;
    if (ID = 0) then
    begin
      ShowMessage('Voc no selecionou nenhum Produto!');
    end
    else if (ID > 0) then
    begin
      CDSSubID_PRODUTO.AsFloat := ID;
      CDSSubDESCRICAO.AsString := NomeDesceicao;
    end;
  end;
end;

procedure TFrmCadPedidos.SpeedButton1Click(Sender: TObject);
begin
  CDS.GetNextPacket;
end;

procedure TFrmCadPedidos.DBGrid1TitleClick(Column: TColumn);
begin
  DM.OrdenaDataSetGrid(CdsPedidosProc, DBGrid1, Column);
end;

procedure TFrmCadPedidos.DBGridSubTitleClick(Column: TColumn);
begin
  DM.OrdenaDataSetGrid(CDSSub, DBGridSub, Column);
end;

procedure TFrmCadPedidos.DsCDSDataChange(Sender: TObject; Field: TField);
begin
  if (CDS.Tag = 0) and (CDS.Active) then
  begin
    if pgcPrin.ActivePageIndex = 1 then
      pgDadosShow(Self);
    TestaEstado(CDS);
  end;
end;

procedure TFrmCadPedidos.DsCDSStateChange(Sender: TObject);
begin
  if CDS.Tag = 0 then
    TestaEstado(CDS);
end;

procedure TFrmCadPedidos.DsSubDataChange(Sender: TObject; Field: TField);
begin
  TestaEstadoSub(CDSSub);
end;

procedure TFrmCadPedidos.DsSubStateChange(Sender: TObject);
begin
  TestaEstadoSub(CDSSub);
end;

procedure TFrmCadPedidos.DuplicarPedido1Click(Sender: TObject);
var
  nID : Real;
begin
  CdsPedidos.CreateDataSet;
  CdsPedidos.Insert;
  CdsPedidosID_PEDIDO.AsFloat  := DM.RetornaID('ID_PEDIDO');
  CdsPedidosID_CLIENTE.AsFloat := CDSID_CLIENTE.AsFloat;
  CdsPedidosDATAPED.AsDateTime := DM.PegaData;
  CdsPedidos.Post;

  CDSSub.DisableControls;
  CDSSub.Close;
  CDSSub.Params[0].AsFloat := CDSID_PEDIDO.AsFloat;
  CDSSub.Open;
  CDSSub.First;

  CdsItens.CreateDataSet;
  while not CDSSub.Eof do
  begin
    CdsItens.Insert;
    CdsItensID_PRODUTO.AsFloat := CDSSubID_PRODUTO.AsFloat;
    CdsItensQUANTIDADE.AsFloat := CDSSubQUANTIDADE.AsFloat;
    CdsItensPRECOVENDA.AsFloat := CDSSubPRECOVENDA.AsFloat;
    CdsItens.Post;

    CDSSub.Next;
  end;
  CDSSub.EnableControls;

  //Chamada da Funo
  nID := DM.IncluiPedido(CdsPedidos.Data, CdsItens.Data);
 //Funo criada no cliente pra poder depurar

  if nID > 0 then
  begin
    CDS.Close;
    CDS.Open;
    CDS.Locate('ID_PEDIDO', nID, []);
  end
  else
  begin
    ShowMessage('Erro na transao no server');
  end;

  CdsItens.Close;
  CdsPedidos.Close;
end;

procedure TFrmCadPedidos.dbgPrinTitleClick(Column: TColumn);
const
  idxDefault = 'DEFAULT_ORDER';
var
  strColumn : string;
  i : integer;
  bolUsed : boolean;
  idOptions : TIndexOptions;
begin
  if Column.Index = 1 then
  begin
    edtLocaliza.Visible := true;
    ltLocaliza.Caption  := 'Descrio:';
    cbCompleto.Visible  := true;
    try
      if pnFiltro.Visible and (pgcPrin.ActivePage = pgVisaoGeral) then
        edtLocaliza.SetFocus;
    except
    end;
  end;

  strColumn := idxDefault;

  if Column.Field.FieldKind in [fkCalculated, fkLookup, fkAggregate] then Exit;

  if Column.Field.DataType in [ftBlob, ftMemo] then Exit;

  for i := 0 to dbgPrin.Columns.Count -1 do
    dbgPrin.Columns[i].Title.Font.Style := [];

  bolUsed := (Column.Field.FieldName = CDS.IndexName);

  idOptions := [];
  with CDS do
    begin
      IndexDefs.Update;
      for i := 0 to IndexDefs.Count - 1 do
        begin
          if IndexDefs.Items[i].Name = Column.Field.FieldName then
            begin
              strColumn := Column.Field.FieldName;
              case (IndexDefs.Items[i].Options = [ixDescending]) of
                true : idOptions := [];
                false : idOptions := [ixDescending];
              end;
            end;
        end;

    if (strColumn = idxDefault)  or (bolUsed) then
      begin
        if bolUsed then
          DeleteIndex(Column.Field.FieldName);
        try
          AddIndex(Column.Field.FieldName, Column.Field.FieldName, idOptions, '', '', 0);
          strColumn := Column.Field.FieldName;
        except
          if bolUsed then
          strColumn := idxDefault;
        end;
      end;

    try
      IndexName := strColumn;
      Column.Title.Font.Style := [fsbold];
    except
      IndexName := idxDefault;
    end;
  end;
end;

procedure TFrmCadPedidos.FormCreate(Sender: TObject);
begin
  Screen.Cursor  := crHourGlass;
  DtpInicio.Date := Date - 7;
  DtpFinal.Date  := Date + 7;
end;

procedure TFrmCadPedidos.btQntLinhasClick(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  dfRecCount.Caption := FormatFloat('###,###', CDS.RecordCount);
  Screen.Cursor := crDefault;
end;

procedure TFrmCadPedidos.btRefazClick(Sender: TObject);
begin
  btAplicaFiltroClick(nil);
end;

procedure TFrmCadPedidos.EdtCodigoKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    begin
      btAplicaFiltroClick(self);
    end;
end;

procedure TFrmCadPedidos.EdtCodigoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key  = VK_NEXT	then btAplicaFiltroClick(Self);
end;

procedure TFrmCadPedidos.edtLocalizaKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = VK_NEXT then btAplicaFiltroClick(Self);
  if key = VK_UP   then CDS.Prior;
  if key = VK_DOWN then CDS.Next;
end;

procedure TFrmCadPedidos.OrdenaCDSGrid(var CDS: TClientDataSet;
  Column: TColumn; var dbgPrin: TDBGrid);
const
  idxDefault = 'DEFAULT_ORDER';
var
  strColumn : string;
  i : integer;
  bolUsed : boolean;
  idOptions : TIndexOptions;
begin

  strColumn := idxDefault;

  if Column.Field.FieldKind in [fkCalculated, fkLookup, fkAggregate] then Exit;

  if Column.Field.DataType in [ftBlob, ftMemo] then Exit;

  for i := 0 to dbgPrin.Columns.Count -1 do
    dbgPrin.Columns[i].Title.Font.Style := [];

  bolUsed := (Column.Field.FieldName = CDS.IndexName);

  with CDS do
    begin
      IndexDefs.Update;
      for i := 0 to IndexDefs.Count - 1 do
        begin
          if IndexDefs.Items[i].Name = Column.Field.FieldName then
            begin
              strColumn := Column.Field.FieldName;
              case (IndexDefs.Items[i].Options = [ixDescending]) of
                true : idOptions := [];
                false : idOptions := [ixDescending];
              end;
            end;
        end;

    if (strColumn = idxDefault)  or (bolUsed) then
      begin
        if bolUsed then
          DeleteIndex(Column.Field.FieldName);
        try
          AddIndex(Column.Field.FieldName, Column.Field.FieldName, idOptions, '', '', 0);
          strColumn := Column.Field.FieldName;
        except
          if bolUsed then
          strColumn := idxDefault;
        end;
      end;

    try
     IndexName := strColumn;
     Column.Title.Font.Style := [fsbold];
    except
     IndexName := idxDefault;
    end;
  end;
end;

procedure TFrmCadPedidos.pgDadosShow(Sender: TObject);
begin
  if  (not (CDSSub.Active)
  or  (CDSSub.Params[0].AsFloat <> CDSID_PEDIDO.AsFloat))
  and (CDSID_PEDIDO.AsFloat <> 0) then
  begin
    Screen.Cursor := crHourGlass;
    CDSSub.Close;
    CDSSub.Params[0].AsFloat := CDSID_PEDIDO.AsFloat;
    CDSSub.Open;
    Screen.Cursor := crDefault;
  end;
end;

procedure TFrmCadPedidos.PopupMenu1Popup(Sender: TObject);
begin
  if CDS.Active and (CDS.RecordCount > 0) then
  begin
    DuplicarPedido1.Enabled := True;
  end
  else
  begin
    DuplicarPedido1.Enabled := False;
  end;
end;

procedure TFrmCadPedidos.CDSAfterPost(DataSet: TDataSet);
begin
  CDS.ApplyUpdates(0);
  CDS.RefreshRecord;
end;

procedure TFrmCadPedidos.CDSBeforeInsert(DataSet: TDataSet);
begin
  CDSSub.Close;
end;

procedure TFrmCadPedidos.CDSBeforeOpen(DataSet: TDataSet);
begin
  CDS.IndexName := 'DEFAULT_ORDER';
end;

end.
