unit UCadastro;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, Menus, ExtCtrls, ComCtrls, ToolWin, DBCtrls, StdCtrls,
  Mask, Buttons, Grids, DBGrids, FMTBcd, DB, DBClient, Provider, SqlExpr,
  IdBaseComponent, IdComponent,
  IdRawBase, IdRawClient, IdIcmpClient, MidasLib;

type
  TFrmCadastro = class(TForm)
    pgcPrin: TPageControl;
    pgVisaoGeral: TTabSheet;
    Panel4: TPanel;
    dbgPrin: TDBGrid;
    pnFiltro: TPanel;
    pgDados: TTabSheet;
    pnEdit: TPanel;
    pnOk: TPanel;
    btOk: TBitBtn;
    Panel7: TPanel;
    Panel26: TPanel;
    btCancela: TBitBtn;
    pnOpc: TPanel;
    pnMM: TPanel;
    PanelMicro: TPanel;
    ToolBar1: TToolBar;
    btBusca: TToolButton;
    btAltera: TToolButton;
    btInclui: TToolButton;
    btExclui: TToolButton;
    btSair: TToolButton;
    sbRodape: TStatusBar;
    tiAgora: TTimer;
    mmMOpc: TPopupMenu;
    btRefaz: TMenuItem;
    mnOrdena: TMenuItem;
    CdigoEmitentePagRecHistrico1: TMenuItem;
    CdigodoRegistro1: TMenuItem;
    imlOpcDisable: TImageList;
    imlOpcEnable: TImageList;
    CDS: TClientDataSet;
    DsCDS: TDataSource;
    CDSAux: TClientDataSet;
    btAnterior: TSpeedButton;
    btProximo: TSpeedButton;
    btPrimeiro: TSpeedButton;
    btUltimo: TSpeedButton;
    PanelData: TPanel;
    Calendario: TMonthCalendar;
    SbFechar: TSpeedButton;
    SbOK: TSpeedButton;
    bgBusca: TGroupBox;
    pnBuscaBotao: TPanel;
    btAplicaFiltro: TBitBtn;
    anFiltro: TAnimate;
    pnBuscaDF: TPanel;
    ltLocaliza: TLabel;
    btApagaPesquisa: TSpeedButton;
    btQntLinhas: TSpeedButton;
    dfRecCount: TLabel;
    cbCompleto: TCheckBox;
    edtLocaliza: TMaskEdit;
    EdtCodigo: TEdit;
    procedure btAplicaFiltroClick(Sender: TObject);
    procedure btAlteraClick(Sender: TObject);
    procedure btIncluiClick(Sender: TObject);
    procedure btExcluiClick(Sender: TObject);
    procedure btSairClick(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btCancelaClick(Sender: TObject);
    procedure tiAgoraTimer(Sender: TObject);
    procedure edtLocalizaKeyPress(Sender: TObject; var Key: Char);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btBuscaClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TestaEstado(DataSet: TDataSet);
    procedure CDSBeforePost(DataSet: TDataSet);
    procedure CDSReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure CdigoEmitentePagRecHistrico1Click(Sender: TObject);
    procedure CdigodoRegistro1Click(Sender: TObject);
    procedure btAjudaClick(Sender: TObject);
    procedure btAnteriorClick(Sender: TObject);
    procedure btProximoClick(Sender: TObject);
    procedure btPrimeiroClick(Sender: TObject);
    procedure btUltimoClick(Sender: TObject);
    procedure btApagaPesquisaClick(Sender: TObject);
    procedure CalendarioDblClick(Sender: TObject);
    procedure SbFecharClick(Sender: TObject);
    procedure DsCDSDataChange(Sender: TObject; Field: TField);
    procedure DsCDSStateChange(Sender: TObject);
    procedure dbgPrinTitleClick(Column: TColumn);
    procedure FormCreate(Sender: TObject);
    procedure btQntLinhasClick(Sender: TObject);
    procedure btRefazClick(Sender: TObject);
    procedure EdtCodigoKeyPress(Sender: TObject; var Key: Char);
    procedure EdtCodigoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edtLocalizaKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OrdenaCDSGrid(var CDS : TClientDataSet; Column : TColumn; var dbgPrin : TDBGrid); stdcall;
    procedure CDSAfterPost(DataSet: TDataSet);
    procedure CDSBeforeOpen(DataSet: TDataSet);
  private
    { Private declarations }
    NomeCampo : String;
  public
    { Public declarations }
    NReg : integer;
  end;

var
  FrmCadastro: TFrmCadastro;

implementation

uses UDM;

{$R *.dfm}

procedure TFrmCadastro.btAplicaFiltroClick(Sender: TObject);
begin
  if EdtCodigo.Visible and (EdtCodigo.Text = '') then
    exit;

  Screen.Cursor               := crHourGlass;
  btAplicaFiltro.Visible      := False;
  anFiltro.Reset;
  anFiltro.Show;
  anFiltro.Play(anFiltro.StartFrame, anFiltro.StopFrame, 0);

  CDS.Close;
  if EdtCodigo.Visible then
  begin
    CDS.Params[0].AsString    := '';
    if CDS.Params.Count > 1 then
      CDS.Params[1].AsFloat   := StrToFloat(EdtCodigo.Text)
    else
      CDS.Params[0].AsString  := '%';
  end
  else if edtLocaliza.Visible then
  begin
    if not cbCompleto.Checked then
    begin
      CDS.Params[0].AsString  := edtLocaliza.Text  + '%';
      if CDS.Params.Count > 1 then
        CDS.Params[1].AsFloat := -1;
    end
    else
    begin
      CDS.Params[0].AsString  := '%' + edtLocaliza.Text  + '%';
      if CDS.Params.Count > 1 then
        CDS.Params[1].AsFloat := -1;
    end;
  end;


  CDS.IndexName             := 'DEFAULT_ORDER';
  CDS.Open;

  if not (edtLocaliza.Text = '') and edtLocaliza.Visible then
    sbRodape.Panels[2].Text   := sbRodape.Panels[2].Text+' Descrio -> '+Trim(edtLocaliza.Text)
  else
    sbRodape.Panels[2].Text   := 'Sem Filtro';

  if not (EdtCodigo.Text = '') and EdtCodigo.Visible then
    sbRodape.Panels[2].Text   := sbRodape.Panels[2].Text+' Cdigo -> '+Trim(EdtCodigo.Text)
  else
    sbRodape.Panels[2].Text   := 'Sem Filtro';

  sbRodape.Panels[1].Text     := 'Visualizando';
  anFiltro.Stop;
  anFiltro.Hide;
  btAplicaFiltro.Visible      := True;
  if EdtCodigo.Visible then
    dbgPrinTitleClick(dbgPrin.Columns[0])
  else
    dbgPrinTitleClick(dbgPrin.Columns[1]);
  CDS.First;
  dfRecCount.Caption          := '---------------';
  btQntLinhasClick(Self);
  Screen.Cursor               := crDefault;
  TestaEstado(CDS);
end;

procedure TFrmCadastro.btAlteraClick(Sender: TObject);
begin
  CDS.Edit;
end;

procedure TFrmCadastro.btIncluiClick(Sender: TObject);
begin
  if not CDS.Active then
    begin
      CDS.Close;
      CDS.Params[0].AsString := '-1';
      CDS.Params[1].AsString := '-1';
      CDS.Open;
    end;
  CDS.Insert;
end;

procedure TFrmCadastro.btExcluiClick(Sender: TObject);
begin
  if CDS.FieldByName(CDS.Fields[0].FieldName).AsFloat = 0 then
  begin
    ShowMessage('Linha no pode ser excluda');
    exit;
  end;
  if CDS.RecordCount > 0 then
    begin
      CDS.Delete;
      CDS.ApplyUpdates(0);
    end;
end;

procedure TFrmCadastro.btSairClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmCadastro.btOkClick(Sender: TObject);
begin
  if CDS.State in [dsinsert,dsedit] then CDS.Post;
end;

procedure TFrmCadastro.btCancelaClick(Sender: TObject);
var
  bVolta : Boolean;
begin
  if CDS.State = dsInsert then
    bVolta := True
  else
    bVolta := False;
  CDS.Cancel;
  if bVolta then
    pgcPrin.ActivePageIndex := 0;
end;

procedure TFrmCadastro.tiAgoraTimer(Sender: TObject);
begin
   sbRodape.Panels[0].Text := TimeToStr(Time);
end;

procedure TFrmCadastro.edtLocalizaKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    begin
      btAplicaFiltroClick(self);
    end;
end;

procedure TFrmCadastro.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if btOk.Visible then
  begin
    showMessage('Operao Em Andamento');
    CanClose := False;
  end;
end;

procedure TFrmCadastro.btBuscaClick(Sender: TObject);
begin
  if not (pgcPrin.ActivePage = pgVisaoGeral) then begin
    if not pnFiltro.Visible then begin
       btBusca.Down     := not pnFiltro.Visible;
       pnFiltro.Visible := not pnFiltro.Visible;
    end else
       btBusca.Down     := true;
    pgcPrin.ActivePage  := pgVisaoGeral;
  end else begin
    btBusca.Down        := not pnFiltro.Visible;
    pnFiltro.Visible    := not pnFiltro.Visible;
  end;
  if pnFiltro.Visible then
  begin
    if edtLocaliza.Visible then
      edtLocaliza.SetFocus
    else
      EdtCodigo.SetFocus;
  end;
end;

procedure TFrmCadastro.FormShow(Sender: TObject);
var
  i : Integer;
begin
  pgcPrin.ActivePageIndex      := 0;

  for i := 0 to pgcPrin.PageCount -1 do
  begin
    pgcPrin.Pages[i].Brush.Color := clBlack;
    pgcPrin.Pages[i].PageControl.Brush.Color := clBlack;
  end;
  pgcPrin.Brush.Color := clBlack;
  sbRodape.Color      := clBlack;

  TestaEstado(CDS);
  try
    if pnFiltro.Visible then
    begin
      if edtLocaliza.Visible then
        edtLocaliza.SetFocus
      else
        EdtCodigo.SetFocus;
    end;
  except
  end;
  Screen.Cursor               := crDefault;
end;

procedure TFrmCadastro.TestaEstado(DataSet: TDataSet);
begin
  if DataSet.Tag = 0 then
  begin
    if DataSet.State = dsBrowse then
    begin
      btOk.Visible               := False;
      btCancela.Visible          := False;
      btInclui.Enabled           := True;
      btAltera.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btExclui.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btBusca.Enabled            := True;
      btPrimeiro.Enabled         := (not CDS.Bof);
      btProximo.Enabled          := (not CDS.Eof);
      btAnterior.Enabled         := (not CDS.Bof);
      btUltimo.Enabled           := (not CDS.Eof);
      btQntLinhas.Enabled        := (not CDS.Eof) or (not CDS.Bof);
      pgVisaoGeral.Enabled       := True;
      sbRodape.Panels[1].Text    := 'Visualizando';
      dbgPrin.Enabled            := True;
    end
    else if DsCDS.State in [dsEdit, dsInsert] then
    begin
      btPrimeiro.Enabled         := False;
      btProximo.Enabled          := False;
      btAnterior.Enabled         := False;
      btUltimo.Enabled           := False;
      btQntLinhas.Enabled        := False;
      btOk.Visible               := True;
      btCancela.Visible          := True;
      btInclui.Enabled           := False;
      btAltera.Enabled           := False;
      btExclui.Enabled           := False;
      btBusca.Enabled            := False;
      dbgPrin.Enabled            := False;
      if DsCDS.State = dsEdit then
        sbRodape.Panels[1].Text:= 'Alterando'
      else
        sbRodape.Panels[1].Text:= 'Incluindo';
      if pgcPrin.ActivePageIndex <> 1 then
        pgcPrin.ActivePageIndex  := 1;
    end
    else
    begin
      btOk.Visible               := False;
      btCancela.Visible          := False;
      btInclui.Enabled           := True;
      btAltera.Enabled           := False;
      btExclui.Enabled           := False;
      btBusca.Enabled            := True;
      btPrimeiro.Enabled         := False;
      btProximo.Enabled          := False;
      btAnterior.Enabled         := False;
      btUltimo.Enabled           := False;
      btQntLinhas.Enabled        := False;
      pgVisaoGeral.Enabled       := True;
      sbRodape.Panels[1].Text    := 'Banco Fechado';
      dbgPrin.Enabled            := True;
    end;
  end
  else
  begin
    if DataSet.State = dsBrowse then
    begin
      btOk.Visible               := False;
      btCancela.Visible          := False;
      btInclui.Enabled           := True;
      btAltera.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btExclui.Enabled           := ((not CDS.Eof) or (not CDS.Bof));
      btBusca.Enabled            := True;
      btPrimeiro.Enabled         := (not CDS.Bof);
      btProximo.Enabled          := (not CDS.Eof);
      btAnterior.Enabled         := (not CDS.Bof);
      btUltimo.Enabled           := (not CDS.Eof);
      btQntLinhas.Enabled        := (not CDS.Eof) or (not CDS.Bof);
      pgVisaoGeral.Enabled       := True;
      sbRodape.Panels[1].Text    := 'Visualizando';
      dbgPrin.Enabled            := True;
    end;
  end;
end;

procedure TFrmCadastro.CDSBeforePost(DataSet: TDataSet);
begin
  if DsCDS.State = dsInsert then
  begin
    try
      CDS.Fields[0].AsFloat := DM.RetornaID(CDS.Fields[0].FieldName);
    except
      CDS.Fields[0].AsFloat := 0;
    end;
  end;
end;

procedure TFrmCadastro.CDSReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  raise EDatabaseError.Create(e.Message);
end;

procedure TFrmCadastro.CdigoEmitentePagRecHistrico1Click(Sender: TObject);
begin
  dbgPrinTitleClick(dbgPrin.Columns[0]);
end;

procedure TFrmCadastro.CdigodoRegistro1Click(Sender: TObject);
begin
  dbgPrinTitleClick(dbgPrin.Columns[1]);
end;

procedure TFrmCadastro.btAjudaClick(Sender: TObject);
begin
  Perform(WM_SYSCOMMAND, SC_CONTEXTHELP, 0)
end;

procedure TFrmCadastro.btAnteriorClick(Sender: TObject);
begin
  CDS.Prior;
  TestaEstado(CDS);
end;

procedure TFrmCadastro.btProximoClick(Sender: TObject);
begin
  CDS.Next;
  TestaEstado(CDS);
end;

procedure TFrmCadastro.btPrimeiroClick(Sender: TObject);
begin
  CDS.First;
  TestaEstado(CDS);
end;

procedure TFrmCadastro.btUltimoClick(Sender: TObject);
begin
  CDS.Last;
  TestaEstado(CDS);
end;

procedure TFrmCadastro.btApagaPesquisaClick(Sender: TObject);
begin
  EdtCodigo.Text := '';
  edtLocaliza.Text := '';
end;

procedure TFrmCadastro.CalendarioDblClick(Sender: TObject);
begin
  CDS.FieldByName(NomeCampo).AsDateTime := Calendario.Date;
  PanelData.Visible := False;
end;

procedure TFrmCadastro.SbFecharClick(Sender: TObject);
begin
  PanelData.Visible := False;
end;

procedure TFrmCadastro.DsCDSDataChange(Sender: TObject; Field: TField);
begin
  TestaEstado(CDS);
end;

procedure TFrmCadastro.DsCDSStateChange(Sender: TObject);
begin
  TestaEstado(CDS);
end;

procedure TFrmCadastro.dbgPrinTitleClick(Column: TColumn);
begin
  if Column.Index = 0 then
    begin
      edtLocaliza.Visible := false;
      EdtCodigo.Visible   := true;
      ltLocaliza.Caption  := 'Cdigo:';
      cbCompleto.Visible  := false;
      cbCompleto.Checked  := false;
      edtLocaliza.Text    := '';
      try
        if pnFiltro.Visible and (pgcPrin.ActivePage = pgVisaoGeral) then
           EdtCodigo.SetFocus;
      except
      end;
    end
  else if Column.Index = 1 then
    begin
      edtLocaliza.Visible := true;
      EdtCodigo.Visible   := false;
      ltLocaliza.Caption  := 'Descrio:';
      cbCompleto.Visible  := true;
      EdtCodigo.Text      := '';
      try
        if pnFiltro.Visible and (pgcPrin.ActivePage = pgVisaoGeral) then
          edtLocaliza.SetFocus;
      except
      end;
    end;

  DM.OrdenaDataSetGrid(CDS, dbgPrin, Column);
end;

procedure TFrmCadastro.FormCreate(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
end;

procedure TFrmCadastro.btQntLinhasClick(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  dfRecCount.Caption := FormatFloat('###,###', CDS.RecordCount);
  Screen.Cursor := crDefault;
end;

procedure TFrmCadastro.btRefazClick(Sender: TObject);
begin
  btAplicaFiltroClick(nil);
end;

procedure TFrmCadastro.EdtCodigoKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    begin
      btAplicaFiltroClick(self);
    end;
end;

procedure TFrmCadastro.EdtCodigoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key  = VK_NEXT	then btAplicaFiltroClick(Self);
end;

procedure TFrmCadastro.edtLocalizaKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = VK_NEXT then btAplicaFiltroClick(Self);
  if key = VK_UP   then CDS.Prior;
  if key = VK_DOWN then CDS.Next;
end;

procedure TFrmCadastro.OrdenaCDSGrid(var CDS: TClientDataSet;
  Column: TColumn; var dbgPrin: TDBGrid);
const
  idxDefault = 'DEFAULT_ORDER';
var
  strColumn : string;
  i : integer;
  bolUsed : boolean;
  idOptions : TIndexOptions;
begin

  strColumn := idxDefault;

  if Column.Field.FieldKind in [fkCalculated, fkLookup, fkAggregate] then Exit;

  if Column.Field.DataType in [ftBlob, ftMemo] then Exit;

  for i := 0 to dbgPrin.Columns.Count -1 do
    dbgPrin.Columns[i].Title.Font.Style := [];

  bolUsed := (Column.Field.FieldName = CDS.IndexName);

  with CDS do
    begin
      IndexDefs.Update;
      for i := 0 to IndexDefs.Count - 1 do
        begin
          if IndexDefs.Items[i].Name = Column.Field.FieldName then
            begin
              strColumn := Column.Field.FieldName;
              case (IndexDefs.Items[i].Options = [ixDescending]) of
                true : idOptions := [];
                false : idOptions := [ixDescending];
              end;
            end;
        end;

    if (strColumn = idxDefault)  or (bolUsed) then
      begin
        if bolUsed then
          DeleteIndex(Column.Field.FieldName);
        try
          AddIndex(Column.Field.FieldName, Column.Field.FieldName, idOptions, '', '', 0);
          strColumn := Column.Field.FieldName;
        except
          if bolUsed then
          strColumn := idxDefault;
        end;
      end;

    try
     IndexName := strColumn;
     Column.Title.Font.Style := [fsbold];
    except
     IndexName := idxDefault;
    end;
  end;
end;

procedure TFrmCadastro.CDSAfterPost(DataSet: TDataSet);
begin
  CDS.ApplyUpdates(0);
  CDS.RefreshRecord;
end;

procedure TFrmCadastro.CDSBeforeOpen(DataSet: TDataSet);
begin
  CDS.IndexName := 'DEFAULT_ORDER';
end;

end.
