unit UDM;

interface

uses
  SysUtils, Classes, MConnect, DB, DBClient, SConnect, SwSystem, DBGrids,
  Forms, Windows, Dialogs, AppEvnts, DateUtils, Variants, Controls, Graphics,
  WideStrings, SqlExpr, MidasLib;

type
  TDM = class(TDataModule)
    Principal: TSocketConnection;
    Consulta: TSharedConnection;
    CdsControlaID: TClientDataSet;
    CdsControlaIDCAMPO: TStringField;
    CdsControlaIDVALOR: TFloatField;
    AppEvents: TApplicationEvents;
    CdsItens: TClientDataSet;
    CdsItensID_PRODUTO: TFloatField;
    CdsItensQUANTIDADE: TFloatField;
    CdsItensPRECOVENDA: TFloatField;
    CdsPedidos: TClientDataSet;
    CdsPedidosID_PEDIDO: TFloatField;
    CdsPedidosID_CLIENTE: TFloatField;
    CdsPedidosDATAPED: TSQLTimeStampField;
    SQLConn: TSQLConnection;
    Relatorios: TSharedConnection;
    CDSToken: TClientDataSet;
    CDSTokenToken: TBooleanField;
    Cadastro: TSharedConnection;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure AppEventsException(Sender: TObject; E: Exception);
  private
    { Private declarations }
  public
    procedure AbreConexaoServers; stdcall;
    procedure FechaConexaoServers; stdcall;
    procedure ReabreConexaoServers; stdcall;
    procedure SetClienteActive(ID : Real); stdcall;
    procedure SetClienteInactive(ID : Real); stdcall;
    function PegaData : TDate; stdcall;
    function PegaDataHora : TDateTime; stdcall;
    function PegaHora : String; stdcall;
    function RetornaID(Campo : String) : Real; stdcall;
    procedure OrdenaDataSetGrid(var CDS    : TClientDataSet;
                                var DBG    : TDBGrid;
                                    Column : TColumn) stdcall;
    function RunSQL(Command : String) : Boolean; stdcall;
    function IncluiPedido(Pedidos : OleVariant; Itens : OleVariant) : OleVariant; stdcall;
  end;

var
  DM            : TDM;
  ID            : Real;
  NomeDesceicao : String;

implementation

{$R *.dfm}

{ TDM }

procedure TDM.AbreConexaoServers;
var
  CdsConexao : TClientDataSet;
begin
  CdsConexao := TClientDataSet.Create(Self);

  CDSToken.CreateDataSet;
  CDSToken.Insert;
  CDSTokenToken.AsBoolean := True;
  CDSToken.Post;

  if not FileExists(gsAppPath + 'ConfigClientBSS.XML') then
  begin
    raise EDatabaseError.Create('Arquivo de configurao do cliente no encontrado');
    Exit;
  end;

  CdsConexao.Close;
  CdsConexao.LoadFromFile(gsAppPath + 'ConfigClientBSS.XML');

  try
    Principal.Connected := False;
    Principal.Port      := CdsConexao.Fields.FieldByName('Porta').AsInteger;
    Principal.Host      := Trim(CdsConexao.Fields.FieldByName('Host').AsString);
    Principal.Connected := True;
    Principal.AppServer.SetToken(CDSToken.Data);
  except
    raise EDatabaseError.Create('Classe Principal no conectada');
  end;

  CDSToken.Close;
  CdsConexao.Free;
end;

procedure TDM.AppEventsException(Sender: TObject; E: Exception);
var
  mensagem: string;
  Pos1, Pos2: integer;
begin
  if Pos(UpperCase('is not a valid date'), UpperCase(E.Message)) <> 0 then
    showmessage('Data invlida, proceda a correo.')
  else if Pos(UpperCase('must have a value'), UpperCase(E.Message)) <> 0 then
  begin
    Pos1:=Pos('''', E.Message);
    mensagem:=E.Message;
    Delete(mensagem, Pos1, 1);
    Pos2:=Pos('''', mensagem);
    mensagem:=copy(E.Message, Pos1 + 1, Pos2 - Pos1);
    mensagem := ' obrigatrio o preenchimento do campo '+ mensagem + '.';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('INI'), UpperCase(E.Message)) <> 0 then
  begin
    Pos1:=Pos('INI', E.Message) + 3;
    Pos2:=Pos('FIM', E.Message);
    mensagem:=copy(E.Message, Pos1, Pos2 - Pos1);
    showmessage(mensagem);
  end
  else if Pos(UpperCase('key violation'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Houve violao de Chave.  Registro j incluido.';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('Input value'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Campo preenchido com valor no vlido. Procedaa correo.';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('is not a valid time'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Hora invlida, proceda a correo.';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('Erro ApplyUpdates'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'No foi possvel salvar a modificao no banco de dados.';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('is not a valid float'), UpperCase(E.Message)) <> 0 then
  begin
    Pos1     :=Pos('''', E.Message);
    mensagem :=E.Message;
    Delete(mensagem, Pos1, 1);
    Pos2     := Pos('''', mensagem);
    mensagem :=copy(E.Message, Pos1 + 1, Pos2 - Pos1);
    mensagem := 'O valor  '+ mensagem + ' no  vlido.';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('field value required'), UpperCase(E.Message)) <> 0 then
  begin
    Pos1     :=Pos('column ', E.Message) + 7;
    Pos2     :=Pos(',', E.Message);
    mensagem :=copy(E.Message, Pos1, Pos2 - Pos1);
    mensagem := 'Campo ' + mensagem + ' deve ser preenchido.';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('ATTEMPT TO STORE DUPLICATE VALUE'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'No  permitido valor duplicado. ';
    showmessage(mensagem);
  end
  else if Pos(UpperCase('FOREIGN KEY'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Operao no permitida, registro vinculado em outra tabela.';
    ShowMessage(mensagem);
  end
  else if Pos(UpperCase('Provider not exported:'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Verso do servidor de aplicao incompatvel com a Aplicao';
    ShowMessage(E.Message + #13 + mensagem)
  end
  else if Pos(UpperCase('SQL Server Error: Column unknown'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Verso do banco de dados incompatvel com a Aplicao';
    ShowMessage(E.Message + #13 + mensagem);
    Application.MainForm.Close;
  end
  else if Pos('VIOLATION OF PRIMARY OR UNIQUE KEY CONSTRAINT', UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Registro Duplicado'+#13#10+Copy(UpperCase(E.Message),Pos('VIOLATION OF PRIMARY OR UNIQUE KEY CONSTRAINT',UpperCase(E.Message))+47,100);
    ShowMessage(mensagem);
  end
  else if Pos(UpperCase('SQLCONNECTION PROPERTY REQUIRED FOR THIS OPERATION'), UpperCase(E.Message)) <> 0 then
  begin
    ReabreConexaoServers;
  end
  else if Pos(UpperCase('INVALID VARIANT OPERATION'), UpperCase(E.Message)) <> 0 then
  begin
    ReabreConexaoServers;
  end
  else if (Pos(UpperCase('MUST APPLY UPDATES BEFORE REFRESHING DATA'), UpperCase(E.Message)) <> 0) then
  begin
    mensagem := ' necessrio aplicara as alteraes antes de atualizar os dados';
    ShowMessage(mensagem);
  end
  else if ((Pos(UpperCase('FALHA CATASTRFICA'), UpperCase(E.Message)) <> 0)
       or  (Pos(UpperCase('FALHA CATASTROFICA'), UpperCase(E.Message)) <> 0)) then
  begin
    mensagem := 'Falha na conexo com o servidor, restabelecendo conexo agora...';
    ShowMessage(mensagem);
    ReabreConexaoServers;
  end
  else if Pos(UpperCase('FALHA INESPERADA'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Falha inesperada na conexo com o servidor, restabelecendo conexo agora...';
    ShowMessage(mensagem);
    ReabreConexaoServers;
  end
  else if Pos(UpperCase('CATASTROPHIC FAILURE'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Falha inesperada na conexo com o servidor, restabelecendo conexo agora...';
    ShowMessage(mensagem);
    ReabreConexaoServers;
  end
  else if Pos(UpperCase('PARENTCONNECTION IS NOT ASSIGNED'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := 'Falha inesperada na conexo com o servidor, restabelecendo conexo agora...';
    ShowMessage(mensagem);
    ReabreConexaoServers;
  end
  else if Pos(UpperCase('dbExpress Error: [0x0015]: Connection failed'), UpperCase(E.Message)) <> 0 then
  begin
    if Pos(UpperCase('SQL Server Error: Unable to complete network request to host'), UpperCase(E.Message)) <> 0 then
    begin
      Pos1     :=Pos('"', E.Message);
      mensagem :=E.Message;
      Delete(mensagem, Pos1, 1);
      Pos2     := Pos('"', mensagem);
      mensagem := copy(E.Message, Pos1 + 1, Pos2 - Pos1);
      mensagem := 'O servidor ' + mensagem + ' no pode ser acessado.' + #13 +
                  'Este problema pode estar ocorrendo por problemas na conexo' + #13 +
                  'desta estao com a rede, ou por problemas de configurao ou firewals.' + #13 +
                  'Esta Aplicao ser finalizada. Contate o suporte mais prximo.';
      ShowMessage(mensagem);
      Halt; //Desliga o programa chutando td e qq coisa
    end
  end
  else if Pos(UpperCase('missing database'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := ' Banco de Dados no encontrado.' + #13 +
                ' Tente novamente em alguns instantes ou' + #13 +
                ' entre em contato com sua equipe tcnica,' + #13 +
                ' provvel problema de conexo com a rede.' + #13 +
                ' O programa ser fechado.' ;
    ShowMessage(mensagem);
    Halt; //Desliga o programa chutando td e qq coisa
  end
  else if Pos(UpperCase('ERROR READING FROM SOCKET'), UpperCase(E.Message)) <> 0 then
  begin
    mensagem := ' Servidor em manuteno ou provvel' + #13 +
                ' problema de conexo com a rede.' + #13 +
                ' Tente novamente em alguns instantes ou' + #13 +
                ' entre em contato com sua equipe tcnica,' + #13 +
                ' O programa ser fechado.' ;
    ShowMessage(mensagem);
    ReabreConexaoServers;
  end
  else if Pos(UpperCase('WINDOWS SOCKET ERROR:'), UpperCase(E.Message)) <> 0 then
  begin
    if Pos(UpperCase('WINDOWS SOCKET ERROR:'), UpperCase(E.Message)) <> 0 then
    begin
      mensagem := ' Servidor em manuteno ou provvel' + #13 +
                  ' problema de conexo com a rede.' + #13 +
                  ' Tente novamente em alguns instantes ou' + #13 +
                  ' entre em contato com sua equipe tcnica,' + #13 +
                  ' O programa ser fechado.' ;
      //ShowMessage(mensagem);
      ReabreConexaoServers;
    end
    else if Pos(UpperCase('NENHUMA CONEXO PDE SER FEITA PORQUE A MQUINA DE DESTINO AS RECUSOU ATIVAMENTE (10061), ON API ' + '''' + 'CONNECT' + ''''), UpperCase(E.Message)) <> 0 then
    begin
      mensagem := ' Servidor em manuteno ou provvel' + #13 +
                  ' problema de conexo com a rede.' + #13 +
                  ' Tente novamente em alguns instantes ou' + #13 +
                  ' entre em contato com sua equipe tcnica,' + #13 +
                  ' O programa ser fechado.' ;
      ShowMessage(mensagem);
      ReabreConexaoServers;
    end
    else if Pos(UpperCase('DESTINO AS RECUSOU ATIVAMENTE'), UpperCase(E.Message)) <> 0 then
    begin
      mensagem := ' Servidor em manuteno ou provvel' + #13 +
                  ' problema de conexo com a rede.' + #13 +
                  ' Tente novamente em alguns instantes ou' + #13 +
                  ' entre em contato com sua equipe tcnica,' + #13 +
                  ' O programa ser fechado.' ;
      ShowMessage(mensagem);
      ReabreConexaoServers;
    end
    else if Pos(UpperCase('(10061)'), UpperCase(E.Message)) <> 0 then
    begin
      mensagem := ' Servidor em manuteno ou provvel' + #13 +
                  ' problema de conexo com a rede.' + #13 +
                  ' Tente novamente em alguns instantes ou' + #13 +
                  ' entre em contato com sua equipe tcnica,' + #13 +
                  ' O programa ser fechado.' ;
      ShowMessage(mensagem);
      ReabreConexaoServers;
    end;
  end
  else if Pos(UpperCase('COULD NOT PARSE SQL TIMESTAMP STRING'), UpperCase(E.Message)) <> 0 then
  begin
    ShowMessage('Data Invlida' + #13 + 'Proceda a Correo');
  end
  else if Pos(UpperCase('THE RPC SERVER IS UNAVAILABLE'), UpperCase(E.Message)) <> 0 then
  begin
    ShowMessage('Reestabelecendo conexao com o Servidor');
    Screen.Cursor := crDefault;
    ReabreConexaoServers;
  end
  else if Pos(UpperCase('Arquivo de configurao da conexo inexistente'), UpperCase(E.Message)) <> 0 then
  begin
    ShowMessage('Arquivo de configurao da conexo inexistente');
    Halt;
  end
  else if Pos(UpperCase('Erro na coxo com o banco de dados. Possiveis Causas:'), UpperCase(E.Message)) <> 0 then
  begin
    ShowMessage('Erro na coxo com o banco de dados.');
    Halt;
  end
  else
  begin
    mensagem := 'Ocorreu o seguinte erro: ' + #13 +UpperCase(E.Message);
    ShowMessage(mensagem);
  end;
end;

procedure TDM.DataModuleCreate(Sender: TObject);
begin
  AbreConexaoServers;
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
  FechaConexaoServers;
end;

procedure TDM.FechaConexaoServers;
var
  i : Integer;
begin
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSharedConnection then
    begin
      (Components[i] as TSharedConnection).Connected := False;
    end;
  end;
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSocketConnection then
    begin
      (Components[i] as TSocketConnection).Connected := False;
    end;
  end;
end;

function TDM.IncluiPedido(Pedidos : OleVariant; Itens: OleVariant): OleVariant;
{var
  TD       : TTransactionDesc;
  sSQL     : String;
  bFaz     : Boolean;
  Conector : TSQLConnection;}
begin
  Result := DM.Principal.AppServer.IncluiPedidos(Pedidos, Itens);
{
//Funo criada no cliente para depurao
  CdsPedidos.Data := Pedidos;
  CdsItens.Data   := Itens;
  bFaz := True;

//Configurando o conector do banco
  Conector               := TSQLConnection.Create(Self);
  Conector.DriverName    := 'Interbase';
  Conector.GetDriverFunc := 'getSQLDriverINTERBASE';
  Conector.LibraryName   := 'dbxint30.dll';
  Conector.LoginPrompt   := False;
  Conector.VendorLib     := 'GDS32.DLL';
  Conector.Params        := SQLConn.Params;
  Conector.Connected     := True;

//Definindo a transao
  TD.TransactionID  := 1;
  TD.IsolationLevel := xilREPEATABLEREAD;

//Iniciando a transao
  Conector.StartTransaction(TD);

  sSQL := ' INSERT INTO PEDIDOS(ID_PEDIDO, ID_CLIENTE, DATAPED) ' +
          ' VALUES(' + CdsPedidosID_PEDIDO.AsString + ', ' +
          CdsPedidosID_CLIENTE.AsString + ', ' + '''' +
          FormatDateTime('mm/dd/yyyy', CdsPedidosDATAPED.AsDateTime) + '''' + ') ';

  try
    Conector.ExecuteDirect(sSQL);
    Result := CdsPedidosID_PEDIDO.AsFloat;
  except
    Result := -1;
    bFaz := False;
  end;

  if bFaz then
  begin
    CdsItens.First;
    while not CdsItens.Eof do
    begin
      sSQL := ' INSERT INTO ITENS(ID_PEDIDO, ID_PRODUTO, QUANTIDADE, PRECOVENDA) ' +
              ' VALUES(' + CdsPedidosID_PEDIDO.AsString + ', ' + CdsItensID_PRODUTO.AsString + ', ' +
                CdsItensQUANTIDADE.AsString + ', ' + CdsItensPRECOVENDA.AsString + ') ';
      try
        Conector.ExecuteDirect(sSQL);
        Result := CdsPedidosID_PEDIDO.AsFloat;
      except
        Result := -1;
        bFaz := False;
      end;
      if not(bFaz) then
        Break;
      CdsItens.Next;
    end;
  end;

  if bFaz then
    Conector.Commit(TD)
  else
  begin
    Conector.Rollback(TD);
  end;

  Conector.Close;
  Conector.Free;
  CdsPedidos.Close;
  CdsItens.Close;   }
end;

procedure TDM.OrdenaDataSetGrid(var CDS: TClientDataSet; var DBG: TDBGrid;
  Column: TColumn);
const
  idxDefault = 'DEFAULT_ORDER';
var
  strColumn : string;
  i         : integer;
  bolUsed   : boolean;
  idOptions : TIndexOptions;
begin
  strColumn := idxDefault;

  if Column.Field.FieldKind in [fkCalculated, fkLookup, fkAggregate] then
    Exit;

  if Column.Field.DataType in [ftBlob, ftMemo] then
    Exit;

  for i := 0 to DBG.Columns.Count - 1 do
  begin
    DBG.Columns[i].Title.Font.Style := [];
  end;

  DBG.Columns[Column.Index].Title.Font.Style := [fsBold];

  bolUsed := (Column.Field.FieldName = CDS.IndexName);

  CDS.IndexDefs.Update;
  for i := 0 to CDS.IndexDefs.Count - 1 do
  begin
    if CDS.IndexDefs.Items[i].Name = Column.Field.FieldName then
    begin
      strColumn := Column.Field.FieldName;
      case (CDS.IndexDefs.Items[i].Options = [ixDescending]) of
        True  : idOptions := [];
        False : idOptions := [ixDescending];
      end;
    end;
  end;

  if (strColumn = idxDefault) or (bolUsed) then
  begin
    if bolUsed then
      CDS.DeleteIndex(Column.Field.FieldName);
    try
      CDS.AddIndex(Column.Field.FieldName,
                   Column.Field.FieldName,
                   idOptions,
                   '',
                   '',
                   0);
      strColumn := Column.Field.FieldName;
    except
      if bolUsed then
        strColumn := idxDefault;
    end;
  end;

  try
    CDS.IndexName := strColumn;
  except
    CDS.IndexName := idxDefault;
  end;
end;

function TDM.PegaData: TDate;
var
  sAux : String;
begin
  sAux   := Principal.AppServer.PegaData;
  Result := StrToDate(sAux);
end;

function TDM.PegaDataHora: TDateTime;
var
  sAux : String;
begin
  sAux   := Principal.AppServer.PegaDataHora;
  Result := StrToDate(FormatDateTime('dd/mm/yyyy', (StrToDate(sAux))));
end;

function TDM.PegaHora: String;
begin
  Result := Principal.AppServer.PegaHora;
end;

procedure TDM.ReabreConexaoServers;
var
  i : Integer;
begin
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSharedConnection then
    begin
      (Components[i] as TSharedConnection).Connected := False;
    end;
  end;
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSocketConnection then
    begin
      (Components[i] as TSocketConnection).Connected := False;
    end;
  end;

  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSocketConnection then
    begin
      CDSToken.CreateDataSet;
      CDSToken.Insert;
      CDSTokenToken.AsBoolean := True;
      CDSToken.Post;
      (Components[i] as TSocketConnection).Connected := True;
      Principal.AppServer.SetToken(CDSToken.Data);
      CDSToken.Close;  
    end;
  end;
end;

function TDM.RetornaID(Campo: String): Real;
begin
  CdsControlaID.CreateDataSet;
  CdsControlaID.Insert;
  CdsControlaIDCAMPO.AsString := UpperCase(Campo);
  CdsControlaIDVALOR.AsFloat  := 0;
  CdsControlaID.Post;
  CdsControlaID.Data := Principal.AppServer.RetornaID(CdsControlaID.Data);

  if CdsControlaIDVALOR.AsFloat = -1 then
  begin
    raise EDatabaseError.Create('Erro na obteno de chave primria para o campo ' + CdsControlaIDCAMPO.AsString);
    Result := -1;
  end
  else if CdsControlaIDVALOR.AsFloat > 0 then
  begin
    Result := CdsControlaIDVALOR.AsFloat;
  end;
  CdsControlaID.Close;
end;

function TDM.RunSQL(Command: String): Boolean;
var
  sAux : String;
begin
  sAux := Principal.AppServer.RunSQL(Command);
  if sAux = '0' then
    Result := True
  else
    Result := False;
end;

procedure TDM.SetClienteActive(ID: Real);
begin
  Principal.AppServer.SetClienteActive(ID);
end;

procedure TDM.SetClienteInactive(ID: Real);
begin
  Principal.AppServer.SetClienteInactive(ID);
end;

end.
