unit UConsulta;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, CodeGearApplicationServer2007_TLB, DB, Provider, SqlExpr, MidasLib, StdVcl,
  FMTBcd;

type
  TClasseConsulta = class(TRemoteDataModule, IClasseConsulta)
    DspConsClientes: TDataSetProvider;
    DspConsProdutos: TDataSetProvider;
    SqlConsProdutos: TSQLDataSet;
    SqlConsClientes: TSQLDataSet;
    SQLPedidosProc: TSQLDataSet;
    DspPedidosProc: TDataSetProvider;
    SqlConsClientesID_CLIENTE: TFloatField;
    SqlConsClientesNOME: TStringField;
    SqlConsClientesSTATUS: TStringField;
    SqlConsClientesCPF: TStringField;
    SqlConsClientesDATACAD: TSQLTimeStampField;
    SqlConsClientesFOTO: TBlobField;
    procedure RemoteDataModuleDestroy(Sender: TObject);
    procedure SqlConsClientesBeforeOpen(DataSet: TDataSet);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

var
  ClasseConsulta        : TClasseConsulta;
  ClasseConsultaFactory : TComponentFactory;

implementation

uses UPrincipal, UServer;

{$R *.DFM}

procedure TClasseConsulta.RemoteDataModuleDestroy(Sender: TObject);
var
  i : Integer;
begin
  for i := 0 to ComponentCount -1 do
  begin
    if Components[i] is TSQLConnection then
    begin
      (Components[i] as TSQLConnection).Close;
    end
    else if Components[i] is TSQLDataSet then
    begin
      (Components[i] as TSQLDataSet).Close;
    end
    else if Components[i] is TClientDataSet then
    begin
      (Components[i] as TClientDataSet).Close;
    end;
  end;
end;

procedure TClasseConsulta.SqlConsClientesBeforeOpen(DataSet: TDataSet);
begin
  if FrmServer = nil then
  begin
    FrmServer := TFrmServer.Create(self);
    (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
  end
  else if (DataSet as TSQLDataSet).SQLConnection = nil then
  begin
    try
      (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    except
      FrmServer := TFrmServer.Create(self);
      (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    end;
  end;
end;

class procedure TClasseConsulta.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  ClasseConsultaFactory := TComponentFactory.Create(ComServer, TClasseConsulta,
    Class_ClasseConsulta, ciMultiInstance, tmSingle);
end.
