Unit UDM;

interface

uses SysUtils, Classes, InvokeRegistry, Midas, SOAPMidas, SOAPDm, MConnect, DB,
  DBClient, SConnect, SWSystem, MidasLib, Provider;

type
  IDM = interface(IAppServerSOAP)
    ['{8D1A241F-4D2F-45BC-97F0-550CF3E706C4}']
  end;

  TDM = class(TSoapDataModule, IDM, IAppServerSOAP, IAppServer)
    CdsConexao: TClientDataSet;
    Principal: TSocketConnection;
    Consulta: TSharedConnection;
    Cadastro: TSharedConnection;
    Relatorios: TSharedConnection;
    CDSToken: TClientDataSet;
    CDSTokenToken: TBooleanField;
    CdsProdutos: TClientDataSet;
    CdsProdutosID_PRODUTO: TFloatField;
    CdsProdutosDESCRICAO: TStringField;
    CdsProdutosPRECOCOMPRA: TFloatField;
    CdsProdutosQUANTIDADE: TFloatField;
    DspProdutos: TDataSetProvider;
    procedure SoapDataModuleCreate(Sender: TObject);
    procedure SoapDataModuleDestroy(Sender: TObject);
  private
    procedure AbreConexaoServers; stdcall;
    procedure FechaConexaoServer; stdcall;
  public
  
  end;

implementation

{$R *.DFM}

procedure TDMCreateInstance(out obj: TObject);
begin
 obj := TDM.Create(nil);
end;

{ TDM }

procedure TDM.AbreConexaoServers;
begin
  CDSToken.CreateDataSet;
  CDSToken.Insert;
  CDSTokenToken.AsBoolean := True;
  CDSToken.Post;          
  if not FileExists(gsAppPath + 'ConfigClientBSS.XML') then
  begin
    raise EDatabaseError.Create('Arquivo de configurao do cliente no encontrado');
    Exit;
  end;
  CdsConexao.Close;
  CdsConexao.LoadFromFile(gsAppPath + 'ConfigClientBSS.XML');
  try
    Principal.Connected := False;
    Principal.Port      := CdsConexao.Fields.FieldByName('Porta').AsInteger;
    Principal.Host      := Trim(CdsConexao.Fields.FieldByName('Host').AsString);
    Principal.Connected := True;
    Principal.AppServer.SetToken(CDSToken.Data);
  except
    raise EDatabaseError.Create('Classe Principal no conectada');
  end;
  CDSToken.Close;
end;

procedure TDM.FechaConexaoServer;
var
  i : Integer;
begin
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSharedConnection then
    begin
      (Components[i] as TSharedConnection).Connected := False;
    end;
  end;
  for i := 0 to ComponentCount - 1 do
  begin
    if Components[i] is TSocketConnection then
    begin
      (Components[i] as TSocketConnection).Connected := False;
    end;
  end;
end;

procedure TDM.SoapDataModuleCreate(Sender: TObject);
begin
  AbreConexaoServers;
end;

procedure TDM.SoapDataModuleDestroy(Sender: TObject);
begin
  FechaConexaoServer;
end;

initialization
   InvRegistry.RegisterInvokableClass(TDM, TDMCreateInstance);
   InvRegistry.RegisterInterface(TypeInfo(IDM));
end.
