
unit WebForm1;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  FirebirdSql.Data.Firebird, System.Globalization;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure dg_execucoes_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure dg_os_PageIndexChanged(source: System.Object; e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
    procedure dg_execucoes_PageIndexChanged(source: System.Object; e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
    procedure dg_os_ItemCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dg_os: System.Web.UI.WebControls.DataGrid;
    fbconn: FirebirdSql.Data.Firebird.FbConnection;
    fb_da: FirebirdSql.Data.Firebird.FbDataAdapter;
    FbCommand1: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand2: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand3: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand4: FirebirdSql.Data.Firebird.FbCommand;
    ds_os: System.Data.DataSet;
    Table: System.Data.DataTable;
    ID_ORDEM_SERVICO: System.Data.DataColumn;
    DSC_SERVICO: System.Data.DataColumn;
    STATUS: System.Data.DataColumn;
    ID_SITUACAO: System.Data.DataColumn;
    DTA_ABERTURA: System.Data.DataColumn;
    fb_da_execucoes: FirebirdSql.Data.Firebird.FbDataAdapter;
    FbCommand5: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand6: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand7: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand8: FirebirdSql.Data.Firebird.FbCommand;
    dg_execucoes: System.Web.UI.WebControls.DataGrid;
    ds_execucoes: System.Data.DataSet;
    lbTitulo: System.Web.UI.WebControls.Label;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
type
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
begin
  Self.fbconn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Self.fb_da := FirebirdSql.Data.Firebird.FbDataAdapter.Create;
  Self.FbCommand4 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand2 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand1 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand3 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.ds_os := System.Data.DataSet.Create;
  Self.Table := System.Data.DataTable.Create;
  Self.ID_ORDEM_SERVICO := System.Data.DataColumn.Create;
  Self.DSC_SERVICO := System.Data.DataColumn.Create;
  Self.STATUS := System.Data.DataColumn.Create;
  Self.ID_SITUACAO := System.Data.DataColumn.Create;
  Self.DTA_ABERTURA := System.Data.DataColumn.Create;
  Self.fb_da_execucoes := FirebirdSql.Data.Firebird.FbDataAdapter.Create;
  Self.FbCommand8 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand6 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand5 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand7 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.ds_execucoes := System.Data.DataSet.Create;
  (System.ComponentModel.ISupportInitialize(Self.ds_os)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.ds_execucoes)).BeginInit;
  Include(Self.dg_os.ItemCommand, Self.dg_os_ItemCommand);
  Include(Self.dg_os.PageIndexChanged, Self.dg_os_PageIndexChanged);
  Include(Self.dg_execucoes.PageIndexChanged, Self.dg_execucoes_PageIndexChanged);
  Include(Self.dg_execucoes.SelectedIndexChanged, Self.dg_execucoes_SelectedIndexChanged);
  // 
  // fbconn
  // 
  Self.fbconn.ConnectionString := 'User=SYSDBA;Password=masterkey;Database=C' +
  ':\ARTIGO OS\database\OS.GDB;DataSource=127.0.0.1;Port=3050;Dialect=3;Char' +
  'set=NONE;Role=;Connection lifetime=0;Connection timeout=15;Pooling=True;P' +
  'acket Size=8192;Server Type=0';
  // 
  // fb_da
  // 
  Self.fb_da.DeleteCommand := Self.FbCommand4;
  Self.fb_da.InsertCommand := Self.FbCommand2;
  Self.fb_da.SelectCommand := Self.FbCommand1;
  Self.fb_da.UpdateCommand := Self.FbCommand3;
  // 
  // FbCommand1
  // 
  Self.FbCommand1.CommandText := 'SELECT A.id_ordem_servico, A.DSC_SERVICO,'#13 +
  #10'CASE WHEN A.ID_SITUACAO = ''A'' THEN ''ABERTA'' ELSE ''FECHADA'' END S' +
  'TATUS,'#13#10'A.ID_SITUACAO, A.dta_abertura'#13#10'FROM ORDEM_SERVICO A';
  Self.FbCommand1.Connection := Self.fbconn;
  // 
  // ds_os
  // 
  Self.ds_os.DataSetName := 'ds_os';
  Self.ds_os.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.ds_os.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.Table));
  // 
  // Table
  // 
  Self.Table.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.ID_ORDEM_SERVICO, 
          Self.DSC_SERVICO, Self.STATUS, Self.ID_SITUACAO, Self.DTA_ABERTURA));
  Self.Table.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('ID_ORDEM_SERVICO'), True)));
  Self.Table.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.ID_ORDEM_SERVICO);
  Self.Table.TableName := 'Table';
  // 
  // ID_ORDEM_SERVICO
  // 
  Self.ID_ORDEM_SERVICO.AllowDBNull := False;
  Self.ID_ORDEM_SERVICO.ColumnName := 'ID_ORDEM_SERVICO';
  Self.ID_ORDEM_SERVICO.DataType := TypeOf(Integer);
  // 
  // DSC_SERVICO
  // 
  Self.DSC_SERVICO.ColumnName := 'DSC_SERVICO';
  Self.DSC_SERVICO.MaxLength := 4000;
  // 
  // STATUS
  // 
  Self.STATUS.ColumnName := 'STATUS';
  Self.STATUS.MaxLength := 7;
  // 
  // ID_SITUACAO
  // 
  Self.ID_SITUACAO.ColumnName := 'ID_SITUACAO';
  Self.ID_SITUACAO.MaxLength := 1;
  // 
  // DTA_ABERTURA
  // 
  Self.DTA_ABERTURA.ColumnName := 'DTA_ABERTURA';
  Self.DTA_ABERTURA.DataType := TypeOf(System.DateTime);
  // 
  // fb_da_execucoes
  // 
  Self.fb_da_execucoes.DeleteCommand := Self.FbCommand8;
  Self.fb_da_execucoes.InsertCommand := Self.FbCommand6;
  Self.fb_da_execucoes.SelectCommand := Self.FbCommand5;
  Self.fb_da_execucoes.UpdateCommand := Self.FbCommand7;
  // 
  // FbCommand5
  // 
  Self.FbCommand5.CommandText := 'SELECT A.NOM_FUNCIONARIO, B.DSC_SERVICO_EX' +
  'ECUTADO, B.DTA_HOR_EXECUCAO'#13#10'FROM FUNCIONARIO A, FUNCIONARIO_EXECUC' +
  'AO B'#13#10'WHERE B.ID_ORDEM_SERVICO = ?'#13#10'  AND A.ID_FUNCIONARIO = ' +
  'B.ID_FUNCIONARIO';
  Self.FbCommand5.Connection := Self.fbconn;
  Self.FbCommand5.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('I' +
      'D_ORDEM_SERVICO', ''));
  // 
  // ds_execucoes
  // 
  Self.ds_execucoes.DataSetName := 'ds_execucoes';
  Self.ds_execucoes.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.ds_execucoes.Namespace := 'http://www.tempuri.org/ds_execucoes.xsd';
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.ds_os)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.ds_execucoes)).EndInit;
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
    //Populando o Datagrid dg_os
    fbconn.Open;
    fb_da.Fill(ds_os);
    fbconn.Close;
    dg_os.databind;
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.dg_os_ItemCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var cmd_alterar : FbCommand;
begin
  //Para pegarmos o nome do comando que definimos no Criador de Propriedades utilizamos o e.CommandName

  //Implementao do comando Select
  if e.CommandName = 'Select' then
  Begin
    //Popular o datagrid dg_execucoes passando como parametro o ID_ORDEM_SERVICO
    fbconn.Open;
    //Passando a clula selecionada como parametro
    fb_da_execucoes.SelectCommand.Parameters['ID_ORDEM_SERVICO'].Value := e.Item.Cells[0].Text;
    fb_da_execucoes.Fill(ds_execucoes);
    fbconn.Close;
    dg_execucoes.Visible := False;
    //verificando se existe dados a serem mostrados
    if ds_execucoes.Tables[0].Rows.Count > 0 then
    Begin
      dg_execucoes.Visible := True;
      dg_execucoes.databind;
    End;
  End
  else
    If e.CommandName = 'InsereExecucao' then
    Begin
      //chamar a pagina de Insero de Execues passando como parametro querystring
      //o id da ordem de servio
      Response.Redirect('webform2.aspx?id='+e.Item.Cells[0].Text);
    End
    else
      If e.CommandName = 'FinalizarOS' then
      Begin
        //Vamos criar um comando sql para fazer o update na base em tempo de execuo
        //Apenas a nivel de aprendizado... o mesmo poderia ser criado com componentes
        fbconn.Open;
        cmd_alterar := FbCommand.Create('UPDATE ORDEM_SERVICO SET ID_SITUACAO = ''F'' WHERE ID_ORDEM_SERVICO = ' + e.Item.Cells[0].Text,fbconn);
        //Executando o comando
        cmd_alterar.ExecuteNonQuery;
        fbconn.Close;
        fb_da.Fill(ds_os);
        dg_os.databind;
      End;
end;

procedure TWebForm1.dg_execucoes_PageIndexChanged(source: System.Object; e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
begin
  //Atribuindo a pgina selecionada
  dg_execucoes.CurrentPageIndex := e.NewPageIndex;

  //Populando o Datagrid
  fbconn.Open;
  fb_da_execucoes.Fill(ds_execucoes);
  fbconn.Close;
  dg_execucoes.databind;
end;

procedure TWebForm1.dg_os_PageIndexChanged(source: System.Object; e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
begin
  //Atribuindo a pgina selecionada
  dg_os.CurrentPageIndex := e.NewPageIndex;

  //Populando o Datagrid
  fbconn.Open;
  fb_da.Fill(ds_os);
  fbconn.Close;
  dg_os.databind;

  //Escondendo o datagrid de detalhes
  dg_execucoes.Visible := False;
end;

procedure TWebForm1.dg_execucoes_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
begin

end;

end.

