
unit WebForm2;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  FirebirdSql.Data.Firebird, Borland.vcl.SysUtils;

type
  TWebForm2 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnCancelar_Click(sender: System.Object; e: System.EventArgs);
    procedure btnGravar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    lb_Titulo: System.Web.UI.WebControls.Label;
    lb_os: System.Web.UI.WebControls.Label;
    lb_descricao: System.Web.UI.WebControls.Label;
    txt_os: System.Web.UI.WebControls.TextBox;
    TextBox2: System.Web.UI.WebControls.TextBox;
    txt_descricao: System.Web.UI.WebControls.TextBox;
    lb_execucao: System.Web.UI.WebControls.Label;
    lb_funcionario: System.Web.UI.WebControls.Label;
    ddl_funcionario: System.Web.UI.WebControls.DropDownList;
    txt_execucao: System.Web.UI.WebControls.TextBox;
    btnGravar: System.Web.UI.WebControls.Button;
    btnCancelar: System.Web.UI.WebControls.Button;
    fbconn: FirebirdSql.Data.Firebird.FbConnection;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm2.InitializeComponent;
begin
  Self.fbconn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Include(Self.btnGravar.Click, Self.btnGravar_Click);
  Include(Self.btnCancelar.Click, Self.btnCancelar_Click);
  // 
  // fbconn
  // 
  Self.fbconn.ConnectionString := 'User=SYSDBA;Password=masterkey;Database=C' +
  ':\ARTIGO OS\database\OS.GDB;DataSource=127.0.0.1;Port=3050;Dialect=3;Char' +
  'set=NONE;Role=;Connection lifetime=0;Connection timeout=15;Pooling=True;P' +
  'acket Size=8192;Server Type=0';
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm2.Page_Load(sender: System.Object; e: System.EventArgs);
var
  ds_os : dataset;
  da_os : FbDataAdapter;

  ds_funcionarios : dataset;
  da_funcionarios : FbDataAdapter;
begin
  //Verificando se  a primeira vez que a pgina  carregada
  If not IsPostBack then
  Begin
    //Populando o Dropdownlist
    //Criando um data adapter e populando o dataset de acordo com os dados da tabela funcionario
    da_funcionarios := FbDataAdapter.Create('SELECT * FROM FUNCIONARIO ORDER BY NOM_FUNCIONARIO',fbconn);
    ds_funcionarios := dataset.Create;
    da_funcionarios.Fill(ds_funcionarios);

    //Atribuindo os dados dos funcionarios ao dropdownlist
    ddl_funcionario.DataSource := ds_funcionarios;
    ddl_funcionario.DataValueField := 'ID_FUNCIONARIO'; //Campo Chave do dropdownlist
    ddl_funcionario.DataTextField := 'NOM_FUNCIONARIO'; //Campo Texto do dropdownlits
    ddl_funcionario.DataBind;

    //Pegando o valor do id da ordem de servio que foi
    //passado via querystring da pgina anterior
    if Convert.ToString(Request['id']) <> '' then
    Begin
      //Criando um data adapter e populando o dataset de acordo com
      //o id da OS passado via querystring
      da_os := FbDataAdapter.Create('SELECT ID_ORDEM_SERVICO, DSC_SERVICO FROM ORDEM_SERVICO WHERE ' +
                                    'ID_ORDEM_SERVICO = ' + Convert.ToString(Request['id']),fbconn);
      ds_os := dataset.Create;
      da_os.Fill(ds_os);

      //Atribuindo os valores da OS aos textbox
      txt_os.Text := ds_os.Tables[0].Rows[0].Item['ID_ORDEM_SERVICO'].ToString;
      txt_descricao.Text := ds_os.Tables[0].Rows[0].Item['DSC_SERVICO'].ToString;
    End
    else //retornar para a pgina inicial se no for passado nenhum parmetro
      Response.Redirect('webform1.aspx');
  End;
end;

procedure TWebForm2.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm2.btnGravar_Click(sender: System.Object; e: System.EventArgs);
var cod_javascript_msg : String;
    cmd_inserir : FbCommand;
    comando_insercao : string;
begin
  //Verificando se a descrio da execuo foi digitada e mostrando uma mensagem
  //via javascript se caso ela ainda no foi digitada
  //Verificando se o tamanho do texto digitado  > 0 (pelo menos 1 letra que no seja espao em branco)
  if txt_execucao.Text.Trim.Length = 0 then
  Begin
    //mandando uma mensagem em javascript
    //definindo o javascript
    cod_javascript_msg := '<script language="javascript">alert(" necessrio digitar a execuo antes da gravao.");</script>'; //Funo Javascript para emitir uma mensagem
    //Registrando o Javascript na pgina
    RegisterStartupScript('msg', cod_javascript_msg);
    //abortando a operao
    exit;
  End;
  //Definindo o sql de insero
  comando_insercao := ' INSERT INTO FUNCIONARIO_EXECUCAO ' +
                      ' (ID_FUNCIONARIO, ' +
                      ' ID_ORDEM_SERVICO,  ' +
                      ' DSC_SERVICO_EXECUTADO,  ' +
                      ' DTA_HOR_EXECUCAO ) ' +
                      ' VALUES ' +
                      ' (' + ddl_funcionario.SelectedValue + ',' +
                      txt_os.Text + ',' +
                      QuotedStr(txt_execucao.Text) + ',' + //No esquecer de adionar a unit Borland.vcl.SysUtils
                      QuotedStr('NOW') + ')';
  //Gravando os dados de excues na ordem de servio
  fbconn.Open;
  cmd_inserir := FbCommand.Create(comando_insercao,fbconn);
  cmd_inserir.ExecuteNonQuery;
  fbconn.Close;
  //Retornando para a pgina inicial
  Response.Redirect('webform1.aspx');
end;

procedure TWebForm2.btnCancelar_Click(sender: System.Object; e: System.EventArgs);
begin
  //Apenas retornando para a pgina inicial
  Response.Redirect('webform1.aspx');
end;

end.

