CREATE DATABASE 'localhost:caminho_desejado\consulta_medica.fdb'
USER 'SYSDBA' PASSWORD 'masterkey'
PAGE_SIZE 16384
DEFAULT CHARACTER SET WIN1252;

/******************************************************************************/
/****                              Generators                              ****/
/******************************************************************************/

CREATE GENERATOR GEN_CLIENTE_ID;
SET GENERATOR GEN_CLIENTE_ID TO 0;

CREATE GENERATOR GEN_CONSULTA_ID;
SET GENERATOR GEN_CONSULTA_ID TO 0;

CREATE GENERATOR GEN_ESPECIALIDADE_ID;
SET GENERATOR GEN_ESPECIALIDADE_ID TO 6;

CREATE GENERATOR GEN_ESTADO_ID;
SET GENERATOR GEN_ESTADO_ID TO 0;

CREATE GENERATOR GEN_HORARIO_MEDICO_ID;
SET GENERATOR GEN_HORARIO_MEDICO_ID TO 0;

CREATE GENERATOR GEN_MEDICO_ID;
SET GENERATOR GEN_MEDICO_ID TO 2;

CREATE GENERATOR GEN_PACIENTE_ID;
SET GENERATOR GEN_PACIENTE_ID TO 0;

/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/



CREATE TABLE CONSULTA (
    COD_CONSULTA        INTEGER NOT NULL,
    COD_PACIENTE        INTEGER NOT NULL,
    COD_MEDICO          INTEGER NOT NULL,
    DATA_HORA_CADASTRO  TIMESTAMP NOT NULL,
    DATA_HORA_CONSULTA  TIMESTAMP NOT NULL
);

CREATE TABLE ESPECIALIDADE (
    COD_ESPECIALIDADE                INTEGER NOT NULL,
    DESCRICAO                        VARCHAR(50) NOT NULL COLLATE WIN_PTBR,
    TEMPO_MEDIO_ATENDIMENTO_MINUTOS  SMALLINT NOT NULL
);

CREATE TABLE ESTADO (
    COD_ESTADO  INTEGER NOT NULL,
    NOME        VARCHAR(50) NOT NULL COLLATE WIN_PTBR,
    UF          VARCHAR(2) NOT NULL COLLATE WIN_PTBR
);

CREATE TABLE HORARIO_MEDICO (
    COD_HORARIO_MEDICO        INTEGER NOT NULL,
    COD_MEDICO                INTEGER NOT NULL,
    DIA_SEMANA                SMALLINT NOT NULL,
    HORA_INICIO_ATENDIMENTO   TIME NOT NULL,
    HORA_TERMINO_ATENDIMENTO  TIME NOT NULL
);

CREATE TABLE MEDICO (
    COD_MEDICO         INTEGER NOT NULL,
    NOME               VARCHAR(50) NOT NULL COLLATE WIN_PTBR,
    COD_ESPECIALIDADE  INTEGER NOT NULL,
    CRM                VARCHAR(10) NOT NULL COLLATE WIN_PTBR,
    SEXO               VARCHAR(1) CHARACTER SET NONE NOT NULL
);

CREATE TABLE PACIENTE (
    COD_PACIENTE   INTEGER NOT NULL,
    NOME           VARCHAR(50) NOT NULL COLLATE WIN_PTBR,
    CPF            VARCHAR(11) CHARACTER SET NONE NOT NULL,
    DATA_CADASTRO  DATE DEFAULT CURRENT_DATE NOT NULL,
    EMAIL          VARCHAR(60) COLLATE WIN_PTBR,
    ENDERECO       VARCHAR(50) NOT NULL COLLATE WIN_PTBR,
    TELEFONE       VARCHAR(15) NOT NULL,
    COD_ESTADO     INTEGER NOT NULL,
    CIDADE         VARCHAR(50) NOT NULL COLLATE WIN_PTBR,
    SEXO           VARCHAR(1) CHARACTER SET NONE,
    SENHA          VARCHAR(20) CHARACTER SET NONE NOT NULL
);



/******************************************************************************/
/****                             Primary Keys                             ****/
/******************************************************************************/

ALTER TABLE CONSULTA ADD CONSTRAINT PK_CONSULTA PRIMARY KEY (COD_CONSULTA);
ALTER TABLE ESPECIALIDADE ADD CONSTRAINT PK_ESPECIALIDADE PRIMARY KEY (COD_ESPECIALIDADE);
ALTER TABLE ESTADO ADD CONSTRAINT PK_ESTADO PRIMARY KEY (COD_ESTADO);
ALTER TABLE HORARIO_MEDICO ADD CONSTRAINT PK_HORARIO_MEDICO PRIMARY KEY (COD_HORARIO_MEDICO);
ALTER TABLE MEDICO ADD CONSTRAINT PK_MEDICO PRIMARY KEY (COD_MEDICO);
ALTER TABLE PACIENTE ADD CONSTRAINT PK_PACIENTE PRIMARY KEY (COD_PACIENTE);


/******************************************************************************/
/****                             Foreign Keys                             ****/
/******************************************************************************/

ALTER TABLE CONSULTA ADD CONSTRAINT FK_CONSULTA_MEDICO FOREIGN KEY (COD_MEDICO) REFERENCES MEDICO (COD_MEDICO);
ALTER TABLE CONSULTA ADD CONSTRAINT FK_CONSULTA_PACIENTE FOREIGN KEY (COD_PACIENTE) REFERENCES PACIENTE (COD_PACIENTE);
ALTER TABLE HORARIO_MEDICO ADD CONSTRAINT FK_HORARIO_MEDICO_MEDICO FOREIGN KEY (COD_MEDICO) REFERENCES MEDICO (COD_MEDICO) ON DELETE CASCADE;
ALTER TABLE MEDICO ADD CONSTRAINT FK_MEDICO_ESPECIALIDADE FOREIGN KEY (COD_ESPECIALIDADE) REFERENCES ESPECIALIDADE (COD_ESPECIALIDADE);
ALTER TABLE PACIENTE ADD CONSTRAINT FK_PACIENTE_ESTADO FOREIGN KEY (COD_ESTADO) REFERENCES ESTADO (COD_ESTADO);


/******************************************************************************/
/****                               Indices                                ****/
/******************************************************************************/

CREATE UNIQUE INDEX ESPECIALIDADE_DESCRICAO ON ESPECIALIDADE (DESCRICAO);
CREATE UNIQUE INDEX ESTADO_NOME ON ESTADO (NOME);
CREATE UNIQUE INDEX ESTADO_UF ON ESTADO (UF);
CREATE UNIQUE INDEX MEDICO_CRM ON MEDICO (CRM);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/


SET TERM ^ ;


/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/



/* Trigger: CONSULTA_BI */
CREATE TRIGGER CONSULTA_BI FOR CONSULTA
ACTIVE BEFORE INSERT POSITION 0
as
begin
  if ((new.cod_consulta is null) or (new.cod_consulta <= 0) ) then
    new.cod_consulta = gen_id(gen_consulta_id,1);
end
^

/* Trigger: ESPECIALIDADE_BI */
CREATE TRIGGER ESPECIALIDADE_BI FOR ESPECIALIDADE
ACTIVE BEFORE INSERT POSITION 0
as
begin
  if ((new.cod_especialidade is null) or (new.cod_especialidade <= 0) ) then
    new.cod_especialidade = gen_id(gen_especialidade_id,1);
end
^

/* Trigger: ESTADO_BI */
CREATE TRIGGER ESTADO_BI FOR ESTADO
ACTIVE BEFORE INSERT POSITION 0
as
begin
  if ((new.cod_estado is null) or (new.cod_estado <= 0) ) then
    new.cod_estado = gen_id(gen_estado_id,1);
end
^

/* Trigger: HORARIO_MEDICO_BI */
CREATE TRIGGER HORARIO_MEDICO_BI FOR HORARIO_MEDICO
ACTIVE BEFORE INSERT POSITION 0
as
begin
  if ((new.cod_horario_medico is null) or (new.cod_horario_medico <= 0) ) then
    new.cod_horario_medico = gen_id(gen_horario_medico_id,1);
end
^

/* Trigger: MEDICO_BI */
CREATE TRIGGER MEDICO_BI FOR MEDICO
ACTIVE BEFORE INSERT POSITION 0
as
begin
  if ((new.cod_medico is null) or (new.cod_medico <= 0) )  then
    new.cod_medico = gen_id(gen_medico_id,1);
end
^

/* Trigger: PACIENTE_BI */
CREATE TRIGGER PACIENTE_BI FOR PACIENTE
ACTIVE BEFORE INSERT POSITION 0
as
begin
  if ((new.COD_PACIENTE is null) or (new.cod_paciente <= 0) ) then
    new.COD_PACIENTE = gen_id(GEN_PACIENTE_ID,1);
end
^

SET TERM ; ^

