
unit cadconsulta;

interface

uses
  System.Text,
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  FirebirdSql.Data.Firebird, System.Configuration;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnLocalizar_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCancelarAgendamento_Click(sender: System.Object; e: System.EventArgs);
    procedure btnSalvar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    txtDataConsulta: System.Web.UI.WebControls.TextBox;
    dropMedico: System.Web.UI.WebControls.DropDownList;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    txtDataHoraCadastro: System.Web.UI.WebControls.TextBox;
    dropPaciente: System.Web.UI.WebControls.DropDownList;
    txtCPF: System.Web.UI.WebControls.TextBox;
    btnLocalizar: System.Web.UI.WebControls.Button;
    dropHoraConsulta: System.Web.UI.WebControls.DropDownList;
    btnSalvar: System.Web.UI.WebControls.Button;
    btnCancelarAgendamento: System.Web.UI.WebControls.Button;
    RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
    RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
    procedure OnInit(e: EventArgs); override;
  private
    {Exibe no campo dropMedico da pgina, o nome do mdico com quem
    a consulta deve ser agendada. O parmetro cod_medico do procedimento
    pode vir de um parmetro cod_medico que a pgina pode receber (caso
    ela seja aberta para cadastrar uma nova consulta) ou do valor do campo
    cod_medico do registro de uma consulta existente (caso a pgina
    seja aberta para alterar uma consulta).}
    procedure CarregarMedico(cod_medico: Integer);

    {Busca o registro da consulta, usando o valor do parmetro cod_consulta
    recebido pela pgina, e exibe os dados nos campos do formulrio.
    Esta rotina  utilizada quando a pgina  aberta para alterao de
    uma consulta, recebendo o parmetro cod_consulta na url.
    Se a rotina for chamada e este parmetro no existir, ela no
    executa nada.}
    procedure CarregarConsulta;

    {Localiza o paciente com o CPF informado.
    Se nenhum paciente for encontrado, exibe o item
    "Nenhum Paciente" no campo dropPaciente na pgina.
    Esta rotina  chamada, por exemplo, no evento Click
    do boto de localizar paciente.}
    procedure LocalizarPaciente(CPF: String);

    {Procura quais horrios esto disponveis
    para o mdico e data informados. Quando a rotina
    for chamada quando a pgina estiver aberta para
    edio de uma consulta, deve-se passar ao parmetro
    cod_consulta o cdigo da consulta em edio para que
    o horrio da prpria consulta seja exibido no
    campo dropHoraConsulta na pgina, caso contrrio,
    o parmetro pode ser omitido, assumindo valor -1,
    para indicar que est sendo feita a incluso de uma
    nova consulta e no existe um cod_consulta.}
    procedure HorariosDisponiveisConsulta(
      Cod_Medico: Integer; Data: DateTime;
      Cod_Consulta: Integer = -1);

    {Salva a consulta, gerando um comando update (quando a pgina tiver
    recebido um parmetro cod_consulta via url),
    para alterar uma consulta existente,
    ou insert (quando a pgina no receber o parmetro
    cod_consulta), para incluir uma nova consulta.}
    procedure SalvarConsulta;

    {Exclui a consulta cujo cdigo for igual
    ao valor do parmetro cod_consulta, recebido
    pela pgina, via url. O boto para cancelar
    um agendamento de uma consulta s aparece
    quando existir o parmetro cod_consulta.
    Isto  definido no evento Load da pgina.}
    procedure CancelarAgendamento;

    {Cdigo de inicializao da pgina, chamado no evento Load
    da pgina (quando a mesma  carregada) para setar variveis,
    executar SQL's e fazer todo o processamento para que os dados necessrios
    sejam exibidos nos campos da pgina.}
    procedure Inicializar;
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.btnSalvar_Click(sender: System.Object; e: System.EventArgs);
begin
  SalvarConsulta;
end;

procedure TWebForm1.btnCancelarAgendamento_Click(sender: System.Object; e: System.EventArgs);
begin
  CancelarAgendamento;
end;

procedure TWebForm1.btnLocalizar_Click(sender: System.Object; e: System.EventArgs);
begin
  LocalizarPaciente(txtCPF.Text);
end;

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  Inicializar;
end;

procedure TWebForm1.InitializeComponent;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Include(Self.btnLocalizar.Click, Self.btnLocalizar_Click);
  Include(Self.btnSalvar.Click, Self.btnSalvar_Click);
  Include(Self.btnCancelarAgendamento.Click, Self.btnCancelarAgendamento_Click);
  //
  // conn
  //
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  Include(Self.Load, Self.Page_Load);
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;
{$ENDREGION}

{$REGION 'funes criadas'}
procedure TWebForm1.CarregarMedico(cod_medico: Integer);
var
  sql: string;
  cmd: FbCommand;
  dr: FbDataReader;
begin
   sql:=
     System.String.Format(
       'select COD_MEDICO, NOME from MEDICO where COD_MEDICO = {0}',
       [cod_medico]);
   cmd:= FbCommand.Create(sql, conn);
   dr:= cmd.ExecuteReader;
   try
     dropMedico.DataSource:= dr;
     dropMedico.DataTextField := 'NOME';
     dropMedico.DataValueField := 'COD_MEDICO';
     dropMedico.DataBind;
   finally
     dr.close;
   end;
end;

procedure TWebForm1.LocalizarPaciente(CPF: String);
var
  sql: StringBuilder;
  cmd: FbCommand;
  dr: FbDataReader;
begin
   sql:= StringBuilder.Create(
       ' select COD_PACIENTE, NOME from PACIENTE ');
   sql.AppendFormat(
       ' where CPF = ''{0}'' ', [CPF]);
   cmd:= FbCommand.Create(sql.ToString, conn);
   if conn.State = ConnectionState.Closed then
      conn.open;
   dr:= cmd.ExecuteReader;
   try
     dropPaciente.DataSource := dr;
     dropPaciente.DataTextField := 'NOME';
     dropPaciente.DataValueField := 'COD_PACIENTE';
     dropPaciente.DataBind;
     if dropPaciente.Items.Count = 0 then
        dropPaciente.Items.Add(ListItem.Create('Nenhum Paciente', '0'));
   finally
     dr.close;
   end;
end;

procedure TWebForm1.HorariosDisponiveisConsulta(Cod_Medico: Integer; Data: DateTime;
  Cod_Consulta: Integer);
var
  tempo_medio_atendimento_minutos: Integer;
  cmd: FbCommand;
  hora_inicio, hora_termino: DateTime;
  sql: StringBuilder;
  dr: FbDataReader;
  da: FbDataAdapter;
  dtConsultas: DataTable;
  filtro: string;
begin
  {Seleciona o tempo mdio de atendimento, em minutos, da especialidade
  do mdico com cdigo igual ao parmetro cod_medico.}
  sql:= StringBuilder.Create(
      ' select e.tempo_medio_atendimento_minutos from especialidade e ');
  sql.Append(
     ' inner join medico m on m.cod_especialidade = e.cod_especialidade ');
  sql.AppendFormat(' where m.cod_medico = {0}', [cod_medico]);
  cmd:= FbCommand.Create(sql.ToString, conn) ;
  tempo_medio_atendimento_minutos :=
     Convert.ToInt32(cmd.ExecuteScalar);

  //Alterando Length para zero, apaga a string contida no StringBuilder
  sql.Length := 0;

  {Seleciona somente a hora das consultas agendadas para
  o mdico cujo cdigo for igual ao valor do parmetro cod_medico
  e que a data da consulta for igual a data passada por parmetro.
  A hora  retornada no select no formato hh:mm:ss. Para isto,
   necessrio converter o campo data_hora_consulta para time,
  depois converter para varchar(13) (13 posies devido a hora ser
  retornada no formato hh:mm:ss:zzzz) e por fim, utilizar a funo
  substring para retornar apenas as 8 primeiras posies
  do campo, retornando uma string no formato hh:mm:ss, tudo isto
  via sql. Isto  necessrio pois mais adiante no cdigo,  feito
  um filtro no campo hora_consulta, em memria, nos dados retornados,
  e utiliza-se a hora no formato hh:mm:ss para filtrar os dados.}
  sql.AppendFormat(
    ' select substring({0} from  1 for 8) as hora_consulta ',
    ['cast(cast(data_hora_consulta as time) as varchar(13))']);
  sql.AppendFormat(' from consulta where cod_medico = {0}', [cod_medico]);
  {Se for passado o cod_consulta,  porque est sendo editada
  uma consulta existente, logo, o horrio dela deve ser includo
  na lista devoldida pela funo.}
  sql.AppendFormat(
      ' and cast(data_hora_consulta as date) =  ''{0}'' ',
      [Data.ToString('dd.MM.yyyy')]);
  {Se o parmetro cod_consulta for maior que zero,
  indica que a pgina foi aberta para alterar um registro
  de consulta existente. Esta rotina deve selecionar apenas
  os horrios disponveis para exibir no campo dropHoraConsulta
  na pgina, e o horrio da consulta que est sendo
  alterado no seria exibido no campo, pois ele est agendado, porm,
  quando for alterao de um registro, o horrio da prpria consulta
  deve aparecer no campo. Para isto, cria-se um filtro na sql para
  trazer apenas os horrios agendados, com exceo do horrio da
  prpria consulta sendo editada.}
  if Cod_Consulta > 0 then
     sql.AppendFormat(' and cod_consulta <> {0}', [Cod_Consulta]);
  cmd.CommandText:= sql.ToString;
  da:= FbDataAdapter.Create(cmd);
  dtConsultas:= DataTable.Create();
  da.Fill(dtConsultas);

  sql.Length := 0;
  {Seleciona os horrios de atendimento do mdico
  para o dia da semana referente a data informada no
  parmetro Data.}
  sql.Append(' select * from horario_medico ');
  sql.AppendFormat(
    ' where cod_medico = {0}', [cod_medico]);
  {A propriedade DayOfWeek da classe DateTime retorna o dia da seman
  referente a data armazenada no objeto Data. Esta propriedade  do tipo
  DayOfWeek, que  um tipo enumerado. Para retornarmos este valor
  como um nmero inteiro, basta fazer a converso da propriedade
  para Inteiro, usando o mtodo ToInt32 da classe Convert. Porm, para o primeiro
  dia da semana (valor DayOfWeek.Sunday, ou seja, domingo), ser retornado
  valor 0, porm, por preferncia pessoal, no campo dia_semana
  na tabela horario_medico, o domingo  representado por 1 e no por 0.
  Por este motivo, soma-se 1 no valor convertido abaixo.}
  sql.AppendFormat(
    ' and dia_semana = {0}', [Convert.ToInt32(Data.DayOfWeek)+1]);
  cmd.CommandText := sql.ToString;
  dr:= cmd.ExecuteReader;
  try
    dropHoraConsulta.Items.Clear;
    {Percorre os registros de horrio de atendimento do mdico
    para verificar, junto aos registros das consultas agendadas,
    quais os horrios livres para exibir no campo dropHoraConsulta
    na pgina.}
    while dr.read do
    begin
       {hora de incio de atendimento do mdico no registro de horrio
       atual}
       hora_inicio:= Convert.ToDateTime(dr['hora_inicio_atendimento']);

       {hora de trmino de atendimento do mdico no registro de horrio
       atual}
       hora_termino:= Convert.ToDateTime(dr['hora_termino_atendimento']);

       {Enquanto hora_inicio < hora_termino, soma  varivel
       hora_inicio, o total de minutos que o mdico leva (em mdia)
       para fazer uma consulta. A cada iterao (repetio), filtra
       as consultas agendadas selecionadas para verificar se existe
       alguma consulta agendada no horrio contido em hora_inicio (lembrando
       que esta varivel vai incrementando at chegar no valor de hora_termino).}
       while hora_inicio < hora_termino do
       begin
          filtro:=
            System.String.Format(
              ' hora_consulta=''{0}'' ', [hora_inicio.ToString('hh:mm:ss')]);
          dtConsultas.DefaultView.RowFilter := filtro;

          {Se no existe nenhuma consulta agendada para o horrio de hora_inicio,
          adiciona esta hora no dropHoraConsulta.}
          if dtConsultas.DefaultView.Count = 0 then
             dropHoraConsulta.Items.Add(hora_inicio.ToString('hh:mm'));
          hora_inicio:= hora_inicio.AddMinutes(tempo_medio_atendimento_minutos);
       end;
    end;

    {Se nenhum horrio est disponvel
    (pois nenhum item foi adicionado ao dropHoraConsulta),
    ento exibe o item "Nenhum horrio disponvel".}
    if dropHoraConsulta.Items.Count = 0 then
       dropHoraConsulta.Items.Add(ListItem.Create('Nenhum horrio disponvel', '0'));
  finally
    dr.close;
  end;
end;

procedure TWebForm1.SalvarConsulta;
var
  cmd: FbCommand;
  sql: StringBuilder;
begin
  {Se a pgina no recebeu um parmetro cod_consulta via url,
  gera um insert para incluir um novo registro.}
  if request['cod_consulta'] = nil then
  begin
    sql :=
      StringBuilder.Create(
        'insert into consulta (COD_MEDICO, COD_PACIENTE, DATA_HORA_CONSULTA) ');
    sql.AppendFormat(
      ' values ({0}, {1}, ''{2:dd.MM.yyyy} {3}'') ',
      [dropMedico.SelectedValue, dropPaciente.SelectedValue,
      Convert.ToDateTime(txtDataConsulta.Text),
      dropHoraConsulta.SelectedValue]);
  end
  {gera um update para alterar um registro existente.}
  else
  begin
    sql := StringBuilder.Create(' update consulta ');
    sql.AppendFormat(
       ' set DATA_HORA_CONSULTA=''{0:dd.MM.yyyy} {1}'', cod_paciente = {2} ',
       [Convert.ToDateTime(txtDataConsulta.Text),
       dropHoraConsulta.SelectedValue,
       dropPaciente.SelectedValue]);
    sql.AppendFormat(
      ' where cod_consulta = {0} ', [request['cod_consulta']]);
  end;

  cmd := FbCommand.Create(sql.ToString, conn);
  conn.open;
  try
    cmd.ExecuteNonQuery;
    response.Redirect('consulta.aspx');
  finally
    conn.close;
  end;
end;

procedure TWebForm1.CancelarAgendamento;
var
  cmd: FbCommand;
  sql: string;
  cod_consulta: Integer;
begin
  if request['cod_consulta'] = nil then
     cod_consulta:= 0
  else cod_consulta:= Convert.ToInt32(request['cod_consulta']);
  
  sql :=
    System.String.Format(
      'delete from consulta where cod_consulta = {0}',
      [cod_consulta]);
  cmd := FbCommand.Create(sql, conn);
  if conn.state = ConnectionState.Closed then
    conn.open;
  try
    cmd.ExecuteNonQuery;
    Response.Redirect('consulta.aspx');
  finally
    conn.close;
  end;
end;

procedure TWebForm1.Inicializar;
var
  dataConsulta: DateTime;
  cod_medico: Integer;
begin
  if not IsPostBack then
  begin
    dropPaciente.Items.Add(
      ListItem.Create('Nenhum Paciente', '0'));

    {Inclui um cdigo JavaScript no boto para
    solicitar confirmao antes de excluir
    a consulta.}
    btnCancelarAgendamento.Attributes.Add(
      'onclick',
      'return confirm("Tem certeza que deseja excluir o agendamento?");');
    conn.open;
    try
      if Request['cod_consulta'] = nil then
      begin
        dataConsulta := Convert.ToDateTime(Request['data_consulta']);
        txtDataConsulta.Text := Request['data_consulta'];
        cod_medico := Convert.ToInt32(Request['cod_medico']);

        {Exibe apenas o mdico cujo cdigo foi recebido no parmetro
        cod_medico da pgina.}
        CarregarMedico(cod_medico);

        {Exibe os horrios disponveis para o mdico e data informados.}
        HorariosDisponiveisConsulta(cod_medico, dataConsulta);

        {Se a pgina no recebeu um parmetro cod_consulta via url,
        ento deixa o boto invisvel, pois a pgina
        foi aberta para incluir uma nova consulta.}
        btnCancelarAgendamento.Visible := false;
      end
      else CarregarConsulta;
    finally
      conn.close;
    end;
  end;
end;

procedure TWebForm1.CarregarConsulta;
var
  sql: StringBuilder;
  cmd: FbCommand;
  dr: FbDataReader;
  cod_medico: Integer;
  data_consulta: DateTime;
  cod_consulta: Integer;
begin
  if Request['cod_consulta'] <> nil then
  begin
    sql := StringBuilder.Create(
      ' select C.*, P.CPF from CONSULTA C INNER JOIN PACIENTE P ');
    sql.Append(' on P.COD_PACIENTE = C.COD_PACIENTE ');
    sql.AppendFormat(' where COD_CONSULTA = {0}', [Request['cod_consulta']]);
    cmd := FbCommand.Create(sql.ToString, conn);
    dr := cmd.ExecuteReader;
    try
      if dr.Read then
      begin
        //Exibe os dados do registro da consulta, nos campos da pgina.
        cod_medico := Convert.ToInt32(dr['COD_MEDICO']);
        txtDataHoraCadastro.Text := dr['DATA_HORA_CADASTRO'].ToString;
        data_consulta:= Convert.ToDateTime(dr['DATA_HORA_CONSULTA']);
        txtDataConsulta.Text := data_consulta.ToString('dd/MM/yyyy');
        CarregarMedico(cod_medico);
        txtCPF.Text := dr['CPF'].ToString;
        txtCPF.ReadOnly := true;
        btnLocalizar.Visible := false;
        {Localiza o paciente a partir do CPF,
        para exibir seu nome no campo dropPaciente.}
        LocalizarPaciente(txtCPF.Text);
        cod_consulta:= Convert.ToInt32(Request['cod_consulta']);
        HorariosDisponiveisConsulta(cod_medico, data_consulta, cod_consulta);
        dropHoraConsulta.SelectedValue:= data_consulta.ToString('hh:mm');
      end;
    finally
      dr.close;
    end;
  end;
end;
{$ENDREGION}

end.

