
unit cadpaciente;

interface

uses
  System.Text,
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  FirebirdSql.Data.Firebird, System.Configuration;

type
  TFrmPaciente = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnSalvar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    txtNome: System.Web.UI.WebControls.TextBox;
    dropSexo: System.Web.UI.WebControls.DropDownList;
    txtCPF: System.Web.UI.WebControls.TextBox;
    txtEmail: System.Web.UI.WebControls.TextBox;
    txtEndereco: System.Web.UI.WebControls.TextBox;
    txtTelefone: System.Web.UI.WebControls.TextBox;
    txtCidade: System.Web.UI.WebControls.TextBox;
    txtSenha: System.Web.UI.WebControls.TextBox;
    dropEstado: System.Web.UI.WebControls.DropDownList;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    btnSalvar: System.Web.UI.WebControls.Button;
    RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
    RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
    RequiredFieldValidator3: System.Web.UI.WebControls.RequiredFieldValidator;
    RequiredFieldValidator4: System.Web.UI.WebControls.RequiredFieldValidator;
    RequiredFieldValidator5: System.Web.UI.WebControls.RequiredFieldValidator;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmPaciente.InitializeComponent;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Include(Self.btnSalvar.Click, Self.btnSalvar_Click);
  // 
  // conn
  // 
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TFrmPaciente.Page_Load(sender: System.Object; e: System.EventArgs);
var
  cmd: FbCommand;
  sql: string;
  dr: FbDataReader;
begin
  if not IsPostBack then
  begin
    sql:= 'select * from ESTADO order by UF';
    cmd:= FbCommand.Create(sql, conn);
    conn.open;
    try
      dr:= cmd.ExecuteReader;
      dropEstado.DataSource := dr;
      dropEstado.DataTextField:= 'UF';
      dropEstado.DataValueField := 'COD_ESTADO';
      dropEstado.DataBind;
      dr.close;

      if Request['cod_paciente'] <> nil then
      begin
        sql:=
         System.String.Format(
           'select * from paciente where cod_paciente = {0}',
           Request['cod_paciente']);
        cmd.CommandText := sql;
        dr:= cmd.ExecuteReader;
        if dr.read then
        begin
           txtNome.Text := dr['NOME'].ToString;
           dropSexo.SelectedValue := dr['SEXO'].ToString;
           txtCPF.Text := dr['CPF'].ToString;
           txtEmail.Text := dr['EMAIL'].ToString;
           txtEndereco.Text := dr['ENDERECO'].ToString;
           txtTelefone.Text := dr['TELEFONE'].ToString;
           txtCidade.Text := dr['CIDADE'].ToString;
           dropEstado.SelectedValue := dr['COD_ESTADO'].ToString;
           {a senha no  retornada, para que, o usurio
           deixando o campo vazio, o mesmo no ser alterado}
           //txtSenha.Text := dr['SENHA'].ToString;
        end;
      end;
    finally
      conn.close;
    end;
  end;
end;

procedure TFrmPaciente.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TFrmPaciente.btnSalvar_Click(sender: System.Object; e: System.EventArgs);
var
  sql: StringBuilder; //incluido namespace System.Text
  cmd: FbCommand;
begin
  {No utilizei um FbDataAdapter para mostra
  que podemos tambm fazer os comandos sql diretamente,
  mas usando um Adapter  mais fcil
  pois no precisamos trabalhar com sql diretamente
  no cdigo.}
  if Request['cod_paciente'] = nil then
  begin
     sql:=
       StringBuilder.Create(
         ' INSERT INTO PACIENTE (NOME, CPF, ');
     sql.Append(' EMAIL, ENDERECO, TELEFONE, COD_ESTADO, CIDADE, SEXO, SENHA) ');
     sql.AppendFormat(
       ' VALUES (''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}'', {5}, ',
       [txtNome.Text, txtCPF.Text, txtEmail.Text, txtEndereco.Text,
       txtTelefone.Text, dropEstado.SelectedValue]);
     sql.AppendFormat(
       '''{0}'', ''{1}'', ''{2}'') ',
       [txtCidade.Text, dropSexo.SelectedValue, txtSenha.Text]);
  end
  else
  begin
     sql:=
       StringBuilder.Create(
         ' update PACIENTE ');
     sql.AppendFormat(
       ' set NOME=''{0}'', CPF=''{1}'', ', [txtNome.Text, txtCPF.Text]);
     sql.AppendFormat(
       ' EMAIL=''{0}'', ENDERECO=''{1}'', TELEFONE=''{2}'', COD_ESTADO={3}, ',
       [txtEmail.Text, txtEndereco.Text, txtTelefone.Text, dropEstado.SelectedValue]);
     sql.AppendFormat('CIDADE=''{0}'', SEXO=''{1}''',
       [txtCidade.Text, dropSexo.SelectedValue]);
     if txtSenha.Text.Trim <> '' then
        sql.AppendFormat(', SENHA=''{0}'' ', [txtSenha.Text]);
     sql.AppendFormat(' where COD_PACIENTE={0} ', [Request['cod_paciente']]);
  end;

  cmd:= FbCommand.Create(sql.ToString, conn);
  conn.open;
  try
    cmd.ExecuteNonQuery;
    response.Redirect('Default.aspx');
  finally
    conn.close;
  end;
end;

end.

