
unit consulta;

interface


uses
  System.Text,
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  FirebirdSql.Data.Firebird, System.Configuration;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure Calendar1_DayRender(sender: System.Object; e: System.Web.UI.WebControls.DayRenderEventArgs);
    procedure dropMes_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure dropAno_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure Calendar1_SelectionChanged(sender: System.Object; e: System.EventArgs);
    procedure linkBtnDataAtual_Click(sender: System.Object; e: System.EventArgs);
    procedure dropEspecialidade_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure dropMedico_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure btnNovaConsulta_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    Calendar1: System.Web.UI.WebControls.Calendar;
    dropMedico: System.Web.UI.WebControls.DropDownList;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    dropMes: System.Web.UI.WebControls.DropDownList;
    dropAno: System.Web.UI.WebControls.DropDownList;
    gridConsultas: System.Web.UI.WebControls.DataGrid;
    linkBtnDataAtual: System.Web.UI.WebControls.LinkButton;
    btnNovaConsulta: System.Web.UI.WebControls.Button;
    dropEspecialidade: System.Web.UI.WebControls.DropDownList;
    gridHorariosMedico: System.Web.UI.WebControls.DataGrid;
    procedure OnInit(e: EventArgs); override;
  private
    {Verifica se existem consultas agendadas para a data e mdico informados.}
    function ExistemConsultasAgendadas(Cod_Medico: Integer; Data: DateTime): Boolean;

    {Retorna o total de horrios disponveis para a data e mdico informados.
    Retorna -1 quando o mdico no fizer atendimento na data informada (de acordo
    com os registros da tabela de horrios do mdico).}
    function TotalHorariosDisponiveis(Cod_Medico: Integer; Data: DateTime): Integer;

    {Seleciona no calendrio, o primeiro dia do ms e ano informados
    nos respectivos campos da pgina (dropMes e dropAno)}
    procedure SelecionarDataCalendario;

    {Exibe no DataGrid gridConsultas as consultas agendadas
    para o mdico selecionado no campo dropMedico e a data
    selecionada no calendrio}
    procedure CarregarConsultasAgendadas;

    {Exibe no DataGrid grid gridHorariosMedico os horrios
    de atendimento do mdico selecionado no campo dropMedico.}
    procedure CarregarHorariosAtendimentoMedico;

    {Exibe no campo dropMedico os mdicos existentes.}
    procedure CarregarMedicos;

    {Exibe no campo dropEspecialidade as especialidades existentes.}
    procedure CarregarEspecialidades;

    {Filtra os mdicos, exibidos no campo dropMedico, pela
    especialidade selecionada no campo dropEspecialidade.}
    procedure FiltrarMedico;

    {Abre a pgina cadconsulta.aspx para agendar
    uma nova consulta para o mdico selecionado no
    campo dropMedico e data selecionada no calendrio.}
    procedure AgendarNovaConsulta;

    {Seleciona no calendrio a data atual, pois o usurio pode
    alterar a data selecionada no calendrio, alterando
    o ms nele. Assim, esta rotina seleciona novamente a data
    atual no calendrio.}
    procedure SelecionarDataAtualCalendario;

    {Cdigo de inicializao da pgina, chamado no evento Load
    da pgina (quando a mesma  carregada) para setar variveis,
    executar SQL's e fazer todo o processamento para que os dados necessrios
    sejam exibidos nos campos da pgina.}
    procedure Inicializar;
  public
  end;

{A constante DtMedicoSessionVarName representa o nome da varivel de sesso
utilizada para armazenar, na sesso do usurio, os registros dos mdicos
existentes.}
const DtMedicoSessionVarName = 'dtMedico';

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Include(Self.dropEspecialidade.SelectedIndexChanged, Self.dropEspecialidade_SelectedIndexChanged);
  Include(Self.dropMedico.SelectedIndexChanged, Self.dropMedico_SelectedIndexChanged);
  Include(Self.dropMes.SelectedIndexChanged, Self.dropMes_SelectedIndexChanged);
  Include(Self.dropAno.SelectedIndexChanged, Self.dropAno_SelectedIndexChanged);
  Include(Self.linkBtnDataAtual.Click, Self.linkBtnDataAtual_Click);
  Include(Self.Calendar1.DayRender, Self.Calendar1_DayRender);
  Include(Self.Calendar1.SelectionChanged, Self.Calendar1_SelectionChanged);
  Include(Self.btnNovaConsulta.Click, Self.btnNovaConsulta_Click);
  // 
  // conn
  // 
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  Include(Self.Load, Self.Page_Load);
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.btnNovaConsulta_Click(sender: System.Object; e: System.EventArgs);
begin
  AgendarNovaConsulta;
end;

procedure TWebForm1.dropMedico_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin
  CarregarHorariosAtendimentoMedico;
end;

procedure TWebForm1.dropEspecialidade_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
begin
  FiltrarMedico;
end;

procedure TWebForm1.dropMes_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin
  SelecionarDataCalendario;
end;

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  Inicializar;
end;

procedure TWebForm1.linkBtnDataAtual_Click(sender: System.Object; e: System.EventArgs);
begin
  SelecionarDataAtualCalendario;
end;

procedure TWebForm1.Calendar1_SelectionChanged(sender: System.Object; e: System.EventArgs);
begin
  CarregarConsultasAgendadas;
end;

procedure TWebForm1.dropAno_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin
  SelecionarDataCalendario;
end;

procedure TWebForm1.Calendar1_DayRender(
  sender: System.Object; e: System.Web.UI.WebControls.DayRenderEventArgs);
var
  cod_medico: Integer;
  horarios_disponiveis: Integer;
begin
   if dropMedico.SelectedValue <> '' then
   begin
     cod_medico:= Convert.ToInt32(dropMedico.SelectedValue);
     horarios_disponiveis:= TotalHorariosDisponiveis(cod_medico, e.Day.Date);

     {Se existem algum horrio disponvel para o dia no calendrio.}
     if horarios_disponiveis > 0 then
     begin
       {Se existem consultas agendadas para o dia, exibe o mesmo em azul no calendrio,
       utilizando cdigo CSS (Cascade Style Sheet) por meio da propriedade
       style da clula que representa o dia sendo renderizado no calendrio.}
       if ExistemConsultasAgendadas(cod_medico, e.Day.Date) then
          e.Cell.Style.Add('background-color', 'blue');
     end
     else
     begin
       {O valor -1 indica que no h atendimento do mdico
       no dia, assim, mostra o mesmo em vermelho.}
       if horarios_disponiveis = -1 then
          e.Cell.Style.Add('background-color', 'red')
       else //No h mais horrios disponveis no dia, mostra o mesmo em amarelo.
          e.Cell.Style.Add('background-color', 'yellow');
     end;
   end;
end;

{$ENDREGION}

{$REGION 'rotinas criadas'}
function TWebForm1.ExistemConsultasAgendadas(Cod_Medico: Integer;
  Data: DateTime): Boolean;
var
  cmd: FbCommand;
  sql: StringBuilder;
begin
  {A classe StringBuilder  utilizada para facilitar a concatenao
  de strings e otimizar o uso de memria na concatenao. A classe
  est no namespace System.Text que deve ser includo no uses.}
  sql := StringBuilder.Create( 'select count(*) as total from consulta');
  sql.AppendFormat(' where cod_medico = {0}', [cod_medico]);
  sql.AppendFormat(
    ' and cast(data_hora_consulta as date) = ''{0}''', [data.ToString('dd.MM.yyyy')]);

  cmd:= FbCommand.Create(sql.ToString, conn);
  if conn.state = ConnectionState.Closed then
    conn.Open;
  try
    {A funo ExecuteScalar executa o select retornando apenas uma linha
    e um nico campo.  til para executar selects com funes
    de agrupamento como count, max e min, sen}
    result:= Convert.ToInt32(cmd.ExecuteScalar) > 0;
  finally
    conn.Close;
  end;
end;
  
function TWebForm1.TotalHorariosDisponiveis(Cod_Medico: Integer;
  Data: DateTime): Integer;
var
  sql: StringBuilder;
  cmd: FbCommand;
  dr: FbDataReader;
begin
  sql:= StringBuilder.Create();
  sql.Append(' select tempo_medio_atendimento_minutos, ');
  sql.Append(' total_consultas_permitidas_dia, ');
  sql.Append(' consultas_agendadas_do_dia ');
  sql.AppendFormat(
    ' from SP_TOTAL_HORARIOS_CONSULTAS({0}, ''{1}'') ',
    [Cod_Medico, Data.ToString('yyyy/MM/dd')]);
  cmd:= FbCommand.Create(sql.ToString, conn);
  if conn.State = ConnectionState.Closed then
     conn.open;
  dr:= cmd.ExecuteReader;
  try
    if dr.Read then
    begin
       //retorna o total de horrios ainda disponveis
       result:=
         Convert.ToInt32(dr['total_consultas_permitidas_dia']) -
         Convert.ToInt32(dr['consultas_agendadas_do_dia']);
    end
    {retorna -1 para indicar que no h horrio de atendimento
    no dia data semana referente a data informada}
    else result:= -1;
  finally
    dr.close;
  end;
end;
  
procedure TWebForm1.FiltrarMedico;
var
  dtMedico: DataTable;
begin
  {Recupera da sesso do usurio, o DataTable contendo os registros dos mdicos
  para fazer um filtro nos mdicos pela especialidade
  selecionada o campo dropEspecialidade, sem precisar refazer
  a consulta ao banco de dados, o que aumenta o desempenho
  da aplicao.}
  dtMedico:= DataTable(Session[DtMedicoSessionVarName]);
  {Limpa qualquer filtro que possa existir. O filtro no  aplicado
  diretamente no DataTable e sim utilizando a propriedade DefaultView
  que  um objeto da classe DataView. Esta permite realizar filtros
  e ordenaes em memria nos dados armazenados no DataTable.}
  dtMedico.DefaultView.RowFilter:= '';
  {Se o valor selecionado no dropEspecialidade for
  diferente de zero, indica que o usurio escolheu uma especialidade
  qualquer para filtrar os mdicos por ela. Se o valor selecionado
  for zero,  porque o usuario escolheu a opo TODAS,
  para exibir os mdicos de todas as especialidades.}
  if dropEspecialidade.SelectedValue <> '0' then
     dtMedico.DefaultView.RowFilter:=
       System.String.Format('COD_ESPECIALIDADE = {0}',
         [dropEspecialidade.SelectedValue]);
  dropMedico.DataSource := dtMedico.DefaultView;
  dropMedico.DataBind;
  {Se aps executar o filtro, o campo dropMedico no contiver
  nenhum item, indica que no existe nenhum mdico na especialidade
  selecionada, logo, exibe o item 'Nenhum Mdico Encontrado'.}
  if dropMedico.Items.Count = 0 then
     dropMedico.Items.Add(ListItem.Create('Nenhum Mdico Encontrado', '0'));
end;
  
procedure TWebForm1.CarregarHorariosAtendimentoMedico;
var
  cmd: FbCommand;
  sql: StringBuilder;
  dr: FbDataReader;
begin
  sql := StringBuilder.Create('select * from horario_medico ');
  sql.AppendFormat(' where cod_medico = {0}', [dropMedico.SelectedValue]);
  cmd := FbCommand.Create(sql.ToString, conn);
  if conn.state = ConnectionState.closed then
     conn.open;
  dr:= cmd.ExecuteReader;
  try
    gridHorariosMedico.DataSource := dr;
    gridHorariosMedico.DataBind;
  finally
    dr.close;
  end;
end;
  
procedure TWebForm1.AgendarNovaConsulta;
var
  url: string;
begin
  {A funo Format da classe String permite
  gerar uma string formatada a partir de valores
  de variveis de qualquer tipo. Seria uma alternativa
  a utilizao de um objeto da classe StringBuilder, pois
  permite gerar a string sem precisar instanciar nenhum
  objeto, devido a classe String ser uma classe esttica
  que no requer o instanciamento de um objeto, facilitando
  seu uso. A string gerada, neste caso, contm o nome de
  uma pgina (cadconsulta.aspx) e os parmetros que devem
  ser passados para a pgina, via url. A pgina cadconsulta.aspx
  recebe como parmetro a data da consulta selecionada no calendrio
  e o cdigo do mdico selecionado no dropMedico para que
  a nova consulta seja agendada para a data e mdico informados.}
  url :=
    System.String.Format(
      'cadconsulta.aspx?data_consulta={0}&cod_medico={1}',
      [Calendar1.SelectedDate.ToShortDateString, dropMedico.SelectedValue]);
  {abre a pgina cadconsulta.aspx}
  Response.Redirect(url);
end;
  
procedure TWebForm1.Inicializar;
var
  anoInicial: Integer;
  anoFinal: Integer;
  I: Integer;
begin
  if not IsPostBack then
  begin
    conn.Open;
    try
      CarregarEspecialidades;
      CarregarMedicos;
    finally
      conn.close;
    end;
  
    {Inclui os 12 meses do ano no dropMes.}
    for i := 1 to 12 do
      dropMes.Items.Add(i.ToString);
  
    anoInicial := DateTime.Today.Year - 5;
    anoFinal := DateTime.Today.Year + 1;
    {Inclui no dropAno os anos que o usurio pode
    selecionar, sendo que o ano inicial ser 5 anos
    antes do ano atual e o ano final ser
    um ano aps o ano atual.}
    for I := anoInicial to anoFinal do
      dropAno.Items.Add(i.ToString);
        
    dropAno.SelectedValue := DateTime.Today.Year.ToString;
    dropMes.SelectedValue := DateTime.Today.Month.ToString;
    linkBtnDataAtual.Text := DateTime.Today.ToShortDateString;
    Calendar1.SelectedDate := DateTime.Today;
  end;
end;
  
procedure TWebForm1.SelecionarDataAtualCalendario;
begin
  Calendar1.SelectedDate := DateTime.Today;
  Calendar1.VisibleDate := Calendar1.SelectedDate;
end;
  
procedure TWebForm1.SelecionarDataCalendario;
var
  mes, ano, dataStr: string;
begin
  mes:= dropMes.SelectedValue;
  ano:= dropAno.SelectedValue;
  dataStr:= '01/' + mes + '/' + ano;
  Calendar1.VisibleDate:= Convert.ToDateTime(dataStr);
  Calendar1.SelectedDate := Calendar1.VisibleDate;
end;
  
procedure TWebForm1.CarregarConsultasAgendadas;
var
  CodMedico: Integer;
  cmd: FbCommand;
  sql: StringBuilder;
  dataStr: string;
begin
  if dropMedico.SelectedValue <> '' then
  begin
    codMedico:=
      Convert.ToInt32(dropMedico.SelectedValue);
    sql:= StringBuilder.Create('select c.cod_consulta, c.cod_paciente, p.nome as paciente, ');
    sql.Append(' p.telefone, c.data_hora_cadastro,  c.data_hora_consulta ');
    sql.Append(' from consulta c inner join paciente p on p.cod_paciente = ');
    sql.AppendFormat(' c.cod_paciente where c.cod_medico = {0} ', [codMedico]);
  
    {No firebird, para executar o um filtro contendo uma data no formato
    brasileiro, deve-se utilizar ponto no lugar de / para
    permitir utilizar a data nesse formato. O formato padro de data
    nos bancos de dados  yyyy/mm/dd. Pode-se utilizar este formato
    tambm, sem problemas. }
    dataStr:=
      Calendar1.SelectedDate.ToString('dd.MM.yyyy');
    sql.AppendFormat(' and cast(c.data_hora_consulta as date) = ''{0}'' ', [dataStr]);
    sql.Append(' order by c.data_hora_consulta ');
    cmd:= FbCommand.Create(sql.ToString, conn);
  
    if conn.State = ConnectionState.Closed then
       conn.open;
    try
      {Utilizado o mtodo ExecuteReader que retorna um FbDataReader. Este
      contm os dados retornados pelo select. O mesmo  associado
       propriedade DataSource do DataGrid para que sejam
      exibidos os dados retornados no grid}
      gridConsultas.DataSource := cmd.ExecuteReader;
  
      {O mtodo DataBind faz a vinculao dos dados, retornados
      pelo select, ao DataGrind, fazendo estes dados serem exibidos nele.}
      gridConsultas.DataBind;
    finally
      conn.close;
    end;
  end;
end;
  
procedure TWebForm1.CarregarMedicos;
var
  cmd: FbCommand;
  daMedico: FbDataAdapter;
  dtMedico: DataTable;
begin
  cmd :=
    FbCommand.Create(
      'select COD_MEDICO, NOME, COD_ESPECIALIDADE from MEDICO order by NOME', conn);
  {Utiliza um objeto da classe FbDataAdapter que permite executar o select
  contido no objeto cmd (da classe FbCommand) e armazenar os dados retornados
  em um objeto DataTable ou DataSet, que permitem que os dados retornados
  sejam armazenados em memria, podendo-se desconectar do banco que
  os dados continuaro em memria, diferente de objetos como o FbDataReader
  que trabalha conectado ao banco. Se a conexo for fechada, os dados
  so perdidos. A linha abaixo cria um FbDataAdapter vinculando a ele
  o objeto cmd (contendo a instruo select).}
  daMedico:= FbDataAdapter.Create(cmd);
  {Cria um objeto DataTable para armazenar os mdicos em memria}
  dtMedico:= DataTable.Create('MEDICO');
  {O mtodo fill do objeto daMedico(da classe FbDataAdapter) executa
  o select armazenado o objeto cmd vinculado ao daMedico e armazena, no objeto dtMedico,
  os dados retornados.}
  daMedico.Fill(dtMedico);
  {Armazena o DataTable dtMedico em uma varivel de sesso cujo
  nome  definido pela constante DtMedicoSessionVarName.}
  Session[DtMedicoSessionVarName]:= dtMedico;
  {Vincula o dtMedico ao dropMedico para que os mdicos
  sejam exibidos no DropDownList.}
  dropMedico.DataSource := dtMedico;
  dropMedico.DataTextField := 'NOME';
  dropMedico.DataValueField := 'COD_MEDICO';
  dropMedico.DataBind;
end;
  
procedure TWebForm1.CarregarEspecialidades;
var
  cmd: FbCommand;
  dr: FbDataReader;
begin
  cmd := FbCommand.Create(
    ' select COD_ESPECIALIDADE, DESCRICAO ' +
    ' from ESPECIALIDADE order by DESCRICAO', conn);
  dr:= cmd.ExecuteReader;
  try
    dropEspecialidade.DataSource := dr;
    dropEspecialidade.DataTextField := 'DESCRICAO';
    dropEspecialidade.DataValueField := 'COD_ESPECIALIDADE';
    dropEspecialidade.DataBind;
    {Insere um novo item no dropEspecialidade para exibir a opo TODAS,
    permitindo que sejam exibidos os mdicos de todas as especialidades
    caso esta opo seja selecionada pelo usurio. Como para cada especialidade,
    exibida neste campo,  associado o valor da chave primria COD_ESPECIALIDADE,
    para esta opo TODAS, que no representa um registro da tabela
    especialidade,  associado o valor '0'.}
    dropEspecialidade.Items.Insert(0, ListItem.Create('TODAS', '0'));
  finally
    dr.close;
  end;
end;

{$ENDREGION}
end.

