
unit horariomedico;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  FirebirdSql.Data.Firebird, System.Configuration, System.Globalization;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnNovo_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid1_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid1_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid1_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid1_CancelCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    DataGrid1: System.Web.UI.WebControls.DataGrid;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    FbDataAdapter1: FirebirdSql.Data.Firebird.FbDataAdapter;
    FbCommand1: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand2: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand3: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand4: FirebirdSql.Data.Firebird.FbCommand;
    dsHorario_Medico: System.Data.DataSet;
    Table: System.Data.DataTable;
    COD_HORARIO_MEDICO: System.Data.DataColumn;
    COD_MEDICO: System.Data.DataColumn;
    DIA_SEMANA: System.Data.DataColumn;
    HORA_INICIO_ATENDIMENTO: System.Data.DataColumn;
    HORA_TERMINO_ATENDIMENTO: System.Data.DataColumn;
    btnNovo: System.Web.UI.WebControls.Button;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

const
  StrDsHorarioMedico = 'dsHorario_Medico';

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
type
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Self.FbDataAdapter1 := FirebirdSql.Data.Firebird.FbDataAdapter.Create;
  Self.FbCommand4 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand2 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand1 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand3 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.dsHorario_Medico := System.Data.DataSet.Create;
  Self.Table := System.Data.DataTable.Create;
  Self.COD_HORARIO_MEDICO := System.Data.DataColumn.Create;
  Self.COD_MEDICO := System.Data.DataColumn.Create;
  Self.DIA_SEMANA := System.Data.DataColumn.Create;
  Self.HORA_INICIO_ATENDIMENTO := System.Data.DataColumn.Create;
  Self.HORA_TERMINO_ATENDIMENTO := System.Data.DataColumn.Create;
  (System.ComponentModel.ISupportInitialize(Self.dsHorario_Medico)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).BeginInit;
  Include(Self.DataGrid1.CancelCommand, Self.DataGrid1_CancelCommand);
  Include(Self.DataGrid1.EditCommand, Self.DataGrid1_EditCommand);
  Include(Self.DataGrid1.UpdateCommand, Self.DataGrid1_UpdateCommand);
  Include(Self.DataGrid1.DeleteCommand, Self.DataGrid1_DeleteCommand);
  Include(Self.btnNovo.Click, Self.btnNovo_Click);
  // 
  // conn
  // 
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  // 
  // FbDataAdapter1
  // 
  Self.FbDataAdapter1.DeleteCommand := Self.FbCommand4;
  Self.FbDataAdapter1.InsertCommand := Self.FbCommand2;
  Self.FbDataAdapter1.SelectCommand := Self.FbCommand1;
  Self.FbDataAdapter1.UpdateCommand := Self.FbCommand3;
  // 
  // FbCommand4
  // 
  Self.FbCommand4.CommandText := 'DELETE FROM HORARIO_MEDICO WHERE COD_HORAR' +
  'IO_MEDICO = @p1';
  Self.FbCommand4.Connection := Self.conn;
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_HORARIO_MEDICO', System.Data.DataRowVersion.Original, 
        nil));
  // 
  // FbCommand2
  // 
  Self.FbCommand2.CommandText := 'INSERT INTO HORARIO_MEDICO (COD_MEDICO, DI' +
  'A_SEMANA, HORA_INICIO_ATENDIMENTO, HORA_TERMINO_ATENDIMENTO) VALUES (@p2,' +
  '@p3,@p4,@p5)';
  Self.FbCommand2.Connection := Self.conn;
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 0, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_HORARIO_MEDICO', System.Data.DataRowVersion.Current, 
        '0'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p2', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_MEDICO'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p3', FirebirdSql.Data.Firebird.FbDbType.SmallInt, 2, 'DIA_SEMANA'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p4', FirebirdSql.Data.Firebird.FbDbType.Time, 4, 'HORA_INICIO_ATENDIM' +
      'ENTO'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p5', FirebirdSql.Data.Firebird.FbDbType.Time, 4, 'HORA_TERMINO_ATENDI' +
      'MENTO'));
  // 
  // FbCommand1
  // 
  Self.FbCommand1.CommandText := 'select * from horario_medico where cod_med' +
  'ico = @cod_medico';
  Self.FbCommand1.Connection := Self.conn;
  // 
  // FbCommand3
  // 
  Self.FbCommand3.CommandText := 'UPDATE HORARIO_MEDICO SET DIA_SEMANA = @p3' +
  ', HORA_INICIO_ATENDIMENTO = @p4, HORA_TERMINO_ATENDIMENTO = @p5 WHERE COD' +
  '_HORARIO_MEDICO = @p6';
  Self.FbCommand3.Connection := Self.conn;
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p3', FirebirdSql.Data.Firebird.FbDbType.SmallInt, 2, 'DIA_SEMANA'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p4', FirebirdSql.Data.Firebird.FbDbType.Time, 4, 'HORA_INICIO_ATENDIM' +
      'ENTO'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p5', FirebirdSql.Data.Firebird.FbDbType.Time, 4, 'HORA_TERMINO_ATENDI' +
      'MENTO'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p6', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_HORARIO_MEDICO', System.Data.DataRowVersion.Original, 
        nil));
  // 
  // dsHorario_Medico
  // 
  Self.dsHorario_Medico.DataSetName := 'dsHorario_Medico';
  Self.dsHorario_Medico.Locale := System.Globalization.CultureInfo.Create('p' +
    't-BR');
  Self.dsHorario_Medico.Namespace := 'http://www.tempuri.org/dsHorario_Medic' +
  'o.xsd';
  Self.dsHorario_Medico.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.Table));
  // 
  // Table
  // 
  Self.Table.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.COD_HORARIO_MEDICO, 
          Self.COD_MEDICO, Self.DIA_SEMANA, Self.HORA_INICIO_ATENDIMENTO, Self.HORA_TERMINO_ATENDIMENTO));
  Self.Table.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('COD_HORARIO_MEDICO'), True)));
  Self.Table.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.COD_HORARIO_MEDICO);
  Self.Table.TableName := 'Table';
  // 
  // COD_HORARIO_MEDICO
  // 
  Self.COD_HORARIO_MEDICO.AllowDBNull := False;
  Self.COD_HORARIO_MEDICO.AutoIncrement := True;
  Self.COD_HORARIO_MEDICO.ColumnName := 'COD_HORARIO_MEDICO';
  Self.COD_HORARIO_MEDICO.DataType := TypeOf(Integer);
  // 
  // COD_MEDICO
  // 
  Self.COD_MEDICO.AllowDBNull := False;
  Self.COD_MEDICO.ColumnName := 'COD_MEDICO';
  Self.COD_MEDICO.DataType := TypeOf(Integer);
  // 
  // DIA_SEMANA
  // 
  Self.DIA_SEMANA.AllowDBNull := False;
  Self.DIA_SEMANA.ColumnName := 'DIA_SEMANA';
  Self.DIA_SEMANA.DataType := TypeOf(SmallInt);
  // 
  // HORA_INICIO_ATENDIMENTO
  // 
  Self.HORA_INICIO_ATENDIMENTO.AllowDBNull := False;
  Self.HORA_INICIO_ATENDIMENTO.ColumnName := 'HORA_INICIO_ATENDIMENTO';
  Self.HORA_INICIO_ATENDIMENTO.DataType := TypeOf(System.DateTime);
  // 
  // HORA_TERMINO_ATENDIMENTO
  // 
  Self.HORA_TERMINO_ATENDIMENTO.AllowDBNull := False;
  Self.HORA_TERMINO_ATENDIMENTO.ColumnName := 'HORA_TERMINO_ATENDIMENTO';
  Self.HORA_TERMINO_ATENDIMENTO.DataType := TypeOf(System.DateTime);
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.dsHorario_Medico)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).EndInit;
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
var
  Cod: String;
begin
  if not IsPostBack then
  begin
    try
       {Se a pgina recebeu um parmetro cod_medico, pega esse valor
       para ser atribudo ao parmetro @cod_medico da sql}
       if request['cod_medico'] <> nil then
          Cod:= request['cod_medico']
       {se a pgina no recebeu o parmetro cod_medico, volta para
       a pgina medicos.aspx}
       else response.Redirect('medicos.aspx');

       {Adiciona o parmetro @cod_medico, j com um valor vindo
       da varivel cod, na lista de parmetros do SelectCommand
       pois ele no  criado automaticamente par ao select do
       FbDataAdapter.}
       FbDataAdapter1.SelectCommand.Parameters.Add('@cod_medico', Cod);

       {Executa o select da propriedade SelectedCommand do FbDataAdapter
       e guarda os dados retornados no DataSet dsHorario_Medico.}
       FbDataAdapter1.Fill(dsHorario_Medico);
       {Guarda os dados do DataSet em uma varivel de sesso cujo
       nome da varivel  definido pela constante StrDsHorarioMedico.
       Necessidade j explicada nas edies anteriores.}
       Session[StrDsHorarioMedico]:= dsHorario_Medico;
       
       {Vincula os dados do DataSet ao DataGrid para que sejam exibidos na pgina.}
       DataGrid1.DataBind;
    finally
      conn.close;
    end;
  end;
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.DataGrid1_CancelCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  {Pega o DataSet da seo pois ele contm os dados retornados do banco
  armazenados na memria do servidor.}
  dsHorario_Medico:= DataSet(Session[StrDsHorarioMedico]);

  {Alterando EditItemIndex para -1, faz-se com que
  nenhuma linha fique em estado de edio, finalizando a
  edio da linha.}
  DataGrid1.EditItemIndex := -1;

  {Desfaz quaisquer alteraes feitas no DataSet em memria.}
  dsHorario_Medico.RejectChanges;

  {Revincula o DataSet, com os dados, ao DataGrid.}
  DataGrid1.DataSource := dsHorario_Medico;
  DataGrid1.DataBind;
end;

procedure TWebForm1.DataGrid1_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  row: DataRow;
  Obj: Control;
begin
  {Pega o DataSet da seo pois ele contm os dados retornados do banco
  armazenados na memria do servidor.}
  dsHorario_Medico:= DataSet(Session[StrDsHorarioMedico]);

  {Pega, no DataSet, o registro referente ao nmero da linha editada
  no DataGrid.}
  row:= dsHorario_Medico.Tables[0].Rows[e.Item.ItemIndex];

  {Altera os valores dos campos da linha no DataSet.}
  Obj:= e.Item.Cells[0].FindControl('DropDownList1');
  If Obj <> nil then
     row['DIA_SEMANA']:= DropDownList(obj).SelectedValue;
  row['HORA_INICIO_ATENDIMENTO']:= TextBox(e.Item.Cells[1].Controls[0]).Text;
  row['HORA_TERMINO_ATENDIMENTO']:= TextBox(e.Item.Cells[2].Controls[0]).Text;

  {Executa a atualizao no banco de dados, alterando o registro.}
  FbDataAdapter1.Update(dsHorario_Medico);

  {Armazena na seo do usurio o DataSet alterado.}
  Session[StrDsHorarioMedico]:= dsHorario_Medico;
  
  {Alterando EditItemIndex para -1, faz-se com que
  nenhuma linha fique em estado de edio, finalizando a
  edio da linha.}
  DataGrid1.EditItemIndex := -1;

  {Revincula o DataSet, com os dados, ao DataGrid.}
  DataGrid1.DataSource := dsHorario_Medico;
  DataGrid1.DataBind;
end;

procedure TWebForm1.DataGrid1_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  {Pega o DataSet da seo pois ele contm os dados retornados do banco
  armazenados na memria do servidor.}
  dsHorario_Medico:= DataSet(Session[StrDsHorarioMedico]);
  DataGrid1.EditItemIndex:= e.Item.ItemIndex;

  {Revincula o DataSet, com os dados, ao DataGrid.}
  DataGrid1.DataSource := dsHorario_Medico;
  DataGrid1.DataBind;
end;

procedure TWebForm1.DataGrid1_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  row: DataRow;
begin
  {Pega o DataSet da seo pois ele contm os dados retornados do banco
  armazenados na memria do servidor.}
  dsHorario_Medico:= DataSet(Session[StrDsHorarioMedico]);

  {Pega, no DataSet, o registro referente ao nmero da linha editada
  no DataGrid.}
  row:= dsHorario_Medico.Tables[0].Rows[e.Item.ItemIndex];

  {Deleta a linha do DataSet.}
  row.Delete;

  {Executa a atualizao no banco de dados, excluindo o registro.}
  FbDataAdapter1.Update(dsHorario_Medico);

  {Revincula o DataSet, com os dados, ao DataGrid.}
  DataGrid1.DataSource := dsHorario_Medico;
  DataGrid1.DataBind;

  {Armazena na seo do usurio o DataSet alterado.}
  Session[StrDsHorarioMedico]:= dsHorario_Medico;
end;

procedure TWebForm1.btnNovo_Click(sender: System.Object; e: System.EventArgs);
var
  row: DataRow;
begin
  {Pega o DataSet da seo pois ele contm os dados retornados do banco
  armazenados na memria do servidor.}
  dsHorario_Medico:= DataSet(Session[StrDsHorarioMedico]);

  {Cria um novo registro em memria}
  row:= dsHorario_Medico.Tables[0].NewRow;
  row['COD_MEDICO']:= request['cod_medico'];
  {Como a coluna  do tipo Integer, atribuindo um valor
  como String estava causando erro. Assim, fiz
  a converso do valor inteiro 1
  (que representa o primeiro dia da semana, domingo)
  para String e funcionou.}
  row['DIA_SEMANA']:= Convert.ToString(1);
  row['HORA_INICIO_ATENDIMENTO']:= DateTime.Now.ToShortTimeString;
  row['HORA_TERMINO_ATENDIMENTO']:= DateTime.Now.ToShortTimeString;

  {Adiciona o registro criada na lista de registros do DataSet,
  apenas em memria. A operao  confirmada usando o boto Alterar do DataGrid.}
  dsHorario_Medico.Tables[0].Rows.Add(row);

  {Faz com que o ltimo registro do DataGrid, que acabou de ser inserido,
  passe para o estado de edio para o usurio inserir os valores.}
  DataGrid1.EditItemIndex:= dsHorario_Medico.Tables[0].Rows.Count -1;

  {Revincula o DataSet, com os dados, ao DataGrid.}
  DataGrid1.DataSource := dsHorario_Medico;
  DataGrid1.DataBind;

  {Armazena na seo do usurio o DataSet alterado.}
  Session[StrDsHorarioMedico]:= dsHorario_Medico;
end;

end.

