unit FDigitalizar;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,DelphiTwain,jpeg, ExtDlgs, PdfDoc, PReport, PRJpegImage, ExtCtrls,
  JvBaseDlg, JvDesktopAlert, JvComponentBase, JvTrayIcon, StdCtrls;

const
  HANDDRAGCURSOR = 3778;

type
  TFDigitaliza = class(TForm)
    PReport1: TPReport;
    Twain: TDelphiTwain;
    Panel3: TPanel;
    PRPage1: TPRPage;
    PRLayoutPanel1: TPRLayoutPanel;
    PRJpegImage1: TPRJpegImage;
    JvTrayIcon1: TJvTrayIcon;
    JvDesktopAlert1: TJvDesktopAlert;
    Timer1: TTimer;
    procedure ClearImageList;
    procedure TwainTwainAcquire(Sender: TObject; const Index: Integer;
      Image: TBitmap; var Cancel: Boolean);
    procedure GerarPdf(ArquivoImagem:string);
    procedure Timer1Timer(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
    ImageList: TList;
    TransferMode: TTwainTransferMode;
    CurrentSource: Integer;
    CurrentImage: Integer;
  public
    { Public declarations }
    LoadedSource: Integer;
    FArquivosImagem : TStringList;
    {Form being created}
    constructor Create(AOwner: TComponent); override;
    {Form being destroyed}
    destructor Destroy; override;
  end;

var
  FDigitaliza: TFDigitaliza;
  Cont: integer;

implementation

{$R *.dfm}

procedure TFDigitaliza.ClearImageList;
var
  I: integer;
begin
  {Free each bitmap and then clear list}
  FOR i := 0 TO ImageList.Count - 1 DO
    TJPEGImage(ImageList[i]).Free;
  ImageList.Clear;
end;

constructor TFDigitaliza.Create(AOwner: TComponent);
begin
  {Call inherited}
  inherited Create(AOwner);
  {Create object}
  ImageList := TList.Create;
  {Avoid flickering by using double-buffering}
  {Select first source}
  TransferMode := ttmNative;
  CurrentSource := -1;
  LoadedSource := CurrentSource;
  FArquivosImagem := TStringList.Create;
end;

destructor TFDigitaliza.Destroy;
begin
  {Call inherited method}
  inherited Destroy;
  {Free image list}
  ClearImageList;
  ImageList.Free;
end;

procedure TFDigitaliza.GerarPdf(ArquivoImagem: string);
var
  FArquivoPdf : string;
begin
   if Trim(PReport1.FileName) = '' then
   begin
      PReport1.FileName := 'C:\AtasHtml\processo.pdf';
      PReport1.BeginDoc;
      PRJpegImage1.SharedImage := False;
   end;
   PRJpegImage1.Picture.LoadFromFile(ArquivoImagem);
   PReport1.Print(PRPage1);
   DeleteFile(ArquivoImagem);
end;

procedure TFDigitaliza.TwainTwainAcquire(Sender: TObject; const Index: Integer;
  Image: TBitmap; var Cancel: Boolean);
var
  ArquivoImagem:string;
begin
  {An image has being acquired, add to list}
  TJPEGImage.Create;
  inc(cont);
  ArquivoImagem := includetrailingbackslash(getcurrentdir) + inttostr(cont) + 'pic.jpeg';
  FArquivosImagem.Add(ArquivoImagem);
  with TJPEGImage.Create do
  begin
    CompressionQuality := 65;  // Menor tamanho - menor qualidade
    assign(Image);
    SaveToFile(ArquivoImagem);
    free;
  end;
   // armazena a imagem digitalizada no arquivo PDF
  GerarPdf(ArquivoImagem);
end;

procedure TFDigitaliza.Timer1Timer(Sender: TObject);
begin
  JvTrayIcon1.Active := true;
  FDigitaliza.Visible := false;
end;

procedure TFDigitaliza.FormHide(Sender: TObject);
begin
  Timer1.Enabled:= false;
  PReport1.FileName := '';
  if Twain.LibraryLoaded then
    Twain.LoadLibrary
  else
  begin
    Twain.LoadLibrary;
    Twain.LoadSourceManager;
    Twain.Source[CurrentSource].Loaded := TRUE;
    Twain.Source[CurrentSource].TransferMode := Self.TransferMode;
    ClearImageList;
    Twain.Source[CurrentSource].EnableSource(false, FALSE);
    While MessageDlg('Existe mais folhas a serem digitalizadas para o documento atual?',mtConfirmation,[mbNo,mbYes],0) = mrYes do
//    if MessageDlg('Existe mais folhas a serem digitalizadas para o documento atual?',mtConfirmation,[mbYes,mbNo],0) = mrYes then
      Twain.Source[CurrentSource].EnableSource(false, FALSE);
    while Twain.Source[CurrentSource].Enabled do Application.ProcessMessages;
    Twain.UnloadLibrary;
  end;
   PReport1.EndDoc;
  // dispara evento de digitalizao concluda
  JvDesktopAlert1.Execute;
  JvTrayIcon1.Active := false;
end;

initialization                                        // aqui
  Screen.Cursors[HANDDRAGCURSOR] := LoadCursor(hInstance, MAKEINTRESOURCE(101));
finalization
  DeleteObject(Screen.Cursors[HANDDRAGCURSOR]);

end.
