unit UMenu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.StdCtrls, System.ComponentModel,
  System.Threading, UCliente, Borland.Vcl.ExtCtrls;

type
  TFrmMenu = class(TForm)
    Timer1: TTimer;
    gbxCliente1: TGroupBox;
    gbxCliente2: TGroupBox;
    lbxCliente1: TListBox;
    btnCriarCliente1: TButton;
    btnPararCliente1: TButton;
    btnContinuarCliente1: TButton;
    btnFinalizarCliente1: TButton;
    gbxLidosCliente1: TGroupBox;
    stStatusCliente1: TStaticText;
    gbxStatusCliente1: TGroupBox;
    stCliente1: TStaticText;
    gbxPriCliente1: TGroupBox;
    cbxPriCliente1: TComboBox;
    lbxCliente2: TListBox;
    gbxPriCliente2: TGroupBox;
    cbxPriCliente2: TComboBox;
    gbxStatusCliente2: TGroupBox;
    lbCliente2: TStaticText;
    gbxLidosCliente2: TGroupBox;
    stStatusCliente2: TStaticText;
    btnFinalizarCliente2: TButton;
    btnContinuarCliente2: TButton;
    btnPararCliente2: TButton;
    btnCriarCliente2: TButton;
    procedure btnCriarCliente1Click(Sender: TObject);
    procedure cbxPriCliente1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure btnPararCliente1Click(Sender: TObject);
    procedure btnContinuarCliente1Click(Sender: TObject);
    procedure btnFinalizarCliente1Click(Sender: TObject);
    procedure btnCriarCliente2Click(Sender: TObject);
    procedure btnPararCliente2Click(Sender: TObject);
    procedure btnContinuarCliente2Click(Sender: TObject);
    procedure btnFinalizarCliente2Click(Sender: TObject);
    procedure cbxPriCliente2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    objCliente1:TCliente;
    objCliente2:TCliente;

    ObjThrCliente1:Thread;
    ObjThrCliente2:Thread;

    procedure HabilitaBotao(var objthr :Thread; var btncriar:TButton; var btnparar:TButton; var btncontinuar:TButton; var btnfinalizar:TButton);
    procedure Criar(var objcli:TCliente; var objthr:Thread; tabela:string; campo:string; nomethr :string);
    procedure Parar(var objthr:Thread);
    procedure Continuar(var objthr:Thread);
    procedure Finalizar(var objcli:TCliente; var objthr:Thread; var lbx:TListBox);
    procedure Prioridade(var objthr:Thread; tipo:string);
  end;

var
  FrmMenu: TFrmMenu;

implementation


{$R *.nfm}

procedure TFrmMenu.HabilitaBotao(var objthr :Thread; var btncriar:TButton; var btnparar:TButton; var btncontinuar:TButton; var btnfinalizar:TButton);
var Status:String;
begin
  //Criar
  Status:=Convert.ToString(ThreadState.Stopped);
  btnCriar.Enabled:= not Assigned(objthr)or
                             (Convert.ToString(objthr.ThreadState)
                              = Status);


  //Finalizar
  Status:=Convert.ToString(ThreadState.Stopped);
  btnFinalizar.Enabled:= Assigned(objthr) and
                                (Convert.ToString(objthr.ThreadState)
                                <> Status);

  //Parar
  Status:=Convert.ToString(ThreadState.WaitSleepJoin);
  btnParar.Enabled:= Assigned(objthr)and
                        (Convert.ToString(objthr.ThreadState)
                        = Status);

  //Continuar
  Status:=Convert.ToString(ThreadState.Suspended);
  btnContinuar.Enabled:= Assigned(objthr)and
                            (Convert.ToString(objthr.ThreadState)
                            = Status);

end;

procedure TFrmMenu.Criar(var objcli: TCliente; var objthr: Thread; tabela,
  campo: string; nomethr :string);
begin
  objcli:=TCliente.Create;
  objcli.Tabela:='Customers';
  objcli.campo:='ContactName';
  objthr:=Thread.Create(@objcli.Executar);
  objthr.Name:=nomethr;
  objthr.Start;
end;

procedure TFrmMenu.Parar(var objthr: Thread);
begin
  objthr.Suspend();
end;

procedure TFrmMenu.Prioridade(var objthr: Thread; tipo: string);
begin
  if Assigned(Objthr)then
    Objthr.Priority:=ThreadPriority(Enum.Parse(TypeOf(ThreadPriority),
                                                      tipo
                                                     )
                                   );
end;

procedure TFrmMenu.Continuar(var objthr: Thread);
begin
  objthr.Resume;
end;

procedure TFrmMenu.Finalizar(var objcli: TCliente; var objthr: Thread;
  var lbx: TListBox);
var status:String;
begin
  Status:=Convert.ToString(ThreadState.WaitSleepJoin) +', '+
                           Convert.ToString(ThreadState.Suspended
                          );

  if Assigned(Objthr)and
    (Convert.ToString(Objthr.ThreadState) = Status)
    then Objthr.Resume;

  Objthr.Abort;
  Objthr:=nil;
  objcli.Free;
  lbx.Items.Clear;
end;


procedure TFrmMenu.btnContinuarCliente2Click(Sender: TObject);
begin
  Continuar(ObjThrCliente2);
end;

procedure TFrmMenu.btnCriarCliente1Click(Sender: TObject);
begin
  Criar(objCliente1,ObjThrCliente1,'Customers',
                                   'ContactName',
                                   'Cliente1'
                                   );
end;

procedure TFrmMenu.btnCriarCliente2Click(Sender: TObject);
begin
  Criar(objCliente2,ObjThrCliente2,'Employees',
                                   'FirstName',
                                   'Cliente2'
                                   );
end;

procedure TFrmMenu.btnPararCliente1Click(Sender: TObject);
begin
  Parar(ObjThrCliente1);
end;

procedure TFrmMenu.btnPararCliente2Click(Sender: TObject);
begin
   Parar(ObjThrCliente2);
end;

procedure TFrmMenu.btnContinuarCliente1Click(Sender: TObject);
begin
  Continuar(ObjThrCliente1);
end;

procedure TFrmMenu.btnFinalizarCliente1Click(Sender: TObject);
begin
  Finalizar(objCliente1,ObjThrCliente1,lbxCliente1);
end;

procedure TFrmMenu.btnFinalizarCliente2Click(Sender: TObject);
begin
  Finalizar(objCliente2,ObjThrCliente2,lbxCliente2);
end;

procedure TFrmMenu.cbxPriCliente1Click(Sender: TObject);
begin
  Prioridade(ObjThrCliente1,cbxPriCliente1.Text);
end;

procedure TFrmMenu.cbxPriCliente2Click(Sender: TObject);
begin
  Prioridade(ObjThrCliente2,cbxPriCliente2.Text);
end;

procedure TFrmMenu.Timer1Timer(Sender: TObject);
begin
  if Assigned(ObjThrCliente1)then
     stCliente1.Caption:= Convert.ToString(ObjThrCliente1.ThreadState);

  if Assigned(ObjThrCliente2)then
     lbCliente2.Caption:= Convert.ToString(ObjThrCliente2.ThreadState);

  HabilitaBotao(ObjThrCliente1,
                btnCriarCliente1,
                btnPararCliente1,
                btnContinuarCliente1,
                btnFinalizarCliente1
               );

  HabilitaBotao(ObjThrCliente2,
                btnCriarCliente2,
                btnPararCliente2,
                btnContinuarCliente2,
                btnFinalizarCliente2
               );
end;

end.




