
unit Default;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  System.Web.Security, System.Web.UI.WebControls.WebParts, System.Configuration;

type
  TDefault = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnVisualizar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    sqldtsCustomer: System.Web.UI.WebControls.SqlDataSource;
    btnVisualizar: System.Web.UI.WebControls.Button;
  protected
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses uDMRave;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TDefault.InitializeComponent;
begin
  Include(Self.btnVisualizar.Click, Self.btnVisualizar_Click);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TDefault.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here
end;

procedure TDefault.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TDefault.btnVisualizar_Click(sender: System.Object; e: System.EventArgs);
var
  dtv: DataView;
  sPath: string;
begin
  try
    DMRave := TDMRave.Create(nil);
    
    with DMRave do
    begin
      dtv := ( sqldtsCustomer.Select(DataSourceSelectArguments.Empty) as DataView );
      LstConCustomer.DataObject := dtv;
      sPath := MapPath(Request.ApplicationPath + '\Report\Customer.pdf');
      ExecuteReport('rptCustomer', sPath);
      Response.Redirect('Report\Customer.pdf');
    end;
  finally
    DMRave.Free;
    DMRave := nil;
  end;
end;

end.

