unit uDMRave;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.Db, Borland.Vcl.ADONETDb, Nevrona.Rave.RpRender,
  Nevrona.Rave.RpRenderPDF, Nevrona.Rave.RpBase, Nevrona.Rave.RpFiler,
  Nevrona.Rave.RpCon, Nevrona.Rave.RpConDS, System.ComponentModel,
  Nevrona.Rave.RpDefine, Nevrona.Rave.RpRave;

type
  TDMRave = class(TDataModule)
    RvProjWeb: TRvProject;
    RvDtsCusdtomer: TRvDataSetConnection;
    RvNDRWeb: TRvNDRWriter;
    RvRndrPDF: TRvRenderPDF;
    LstConCustomer: TListConnector;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ExecuteReport(sReportname, sFileName: string);
  end;

var
  DMRave: TDMRave;

implementation

{$R *.nfm}

procedure TDMRave.ExecuteReport(sReportname, sFileName: string);
var
  MStream : TMemoryStream;
begin
  try
    MStream := TMemoryStream.Create;

    RvProjWeb.Engine    := RvNDRWeb;
    RvNDRWeb.Stream     := MStream;
    RvNDRWeb.StreamMode := smUser;
    LstConCustomer.Open;
    RvProjWeb.Open;
    RvProjWeb.ExecuteReport(sReportname);
    RvRndrPDF.PrintRender(RvNDRWeb.Stream,  sFileName);
  finally
    LstConCustomer.Close;
    RvProjWeb.Close;
    MStream.Free;
  end;
end;

end.
