unit Unit2;

interface

uses
  Classes, IWAppForm, IWApplication, IWColor, IWTypes, IWCompLabel,
  IWCompListbox, IWDBStdCtrls, Controls, IWVCLBaseControl, IWBaseControl,
  IWBaseHTMLControl, IWControl, IWCompEdit, InvokeRegistry, Rio, SOAPHTTPClient,
  IWExtCtrls, IWCompMemo, IWHTMLControls, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdHTTP;

type
  TIWFrmCadClientes = class(TIWAppForm)
    iwNome: TIWDBEdit;
    IwEditNatureza: TIWDBEdit;
    IwEditNumero: TIWDBEdit;
    IwEditComplento: TIWDBEdit;
    IwEditCidade: TIWDBEdit;
    IWCep: TIWDBEdit;
    IwEditlogradouro: TIWDBEdit;
    IwEditBAirro: TIWDBEdit;
    IwEditCPF: TIWDBEdit;
    IWLabel1: TIWLabel;
    IWLabel2: TIWLabel;
    IWLabel3: TIWLabel;
    IWLabel4: TIWLabel;
    IWLabel5: TIWLabel;
    IWLabel6: TIWLabel;
    IWLabel7: TIWLabel;
    IWLabel8: TIWLabel;
    IWLabel9: TIWLabel;
    HttpRio1: THTTPRIO;
    IWLabel10: TIWLabel;
    IwEditRG: TIWDBEdit;
    IWLabel11: TIWLabel;
    IwEditUF: TIWDBEdit;
    IWLink1: TIWLink;
    IWLink2: TIWLink;
    procedure IWCepAsyncExit(Sender: TObject; EventParams: TStringList);
    procedure IWAppFormCreate(Sender: TObject);
    procedure IWLink2Click(Sender: TObject);
    procedure IWLink1Click(Sender: TObject);
  public
    function GetEndereco(Campo, Value : string):String;
  end;

implementation

uses UserSessionUnit, soap_server, ServerController, Unit1, SysUtils;

{$R *.dfm}



function TIWFrmCadClientes.GetEndereco(Campo, Value: string): String;
var
  I, Total, Inicio, Fim: Integer;
  j: Integer;
  TempString : string;

begin
 // O  A string de retorno do WEbService vem na seguinte estrutura
//<tipo>Rua<tipo<Endereco> Meu endereco </Endereco>
// por isso que temos que criar ummtodo para estrair a informamo

// Pego o Total de linhas do resultado do webservice e armazeno em uma variavel para
//melhorar nosso compredimento
  Total :=  Length(Value);
  for I := 1 to Total - 1 do
  begin
    //Crio um for para varrer todos os caracters do Endereo
    //Verifico se o caracter  de inicialiaxaao da TAG
    if Copy(Value,i,1) = '<' then
    begin
      // Dou um copy no value(Endereo) com o Index Sendo o i+1, pois
      // se pega-se somente o valor de i como index retornaria "<Campo"
      // Eu fao muito nos meus projetos dar um uppercase pois o If e Case Sensitive/
      if UpperCase(Copy(Value, i+1, Length(Campo))) = Uppercase(Campo) then
      begin
        // Na variavel inicio armazendo o index de inicio do endereco
        Inicio := i+1+Length(Campo)+1;
        for J := Inicio to Total - 1 do
        begin
          // Verifico se contm a finalizacao da tag '<', qunado achar o Char de
          // finalizaao ir[a finalizar o loop.
          if Copy(Value,J,1) <> '<' then
            TempString := TempString+Copy(Value,j,1)
          else
            break;
          Result := TempString;
        end;
        // Finalizando o seungo Loop
        Break;
      end;
    end;
  end;
end;

procedure TIWFrmCadClientes.IWAppFormCreate(Sender: TObject);
begin
//  UserSession.CdsTabClientes.Append;
end;

procedure TIWFrmCadClientes.IWCepAsyncExit(Sender: TObject;
  EventParams: TStringList);
var
  ObjSoap : calcula_fretePortType;
  Num : integer;
  Endereco: string;
begin

  ObjSoap := HTTPRIO1 as calcula_fretePortType;
  Endereco := ObjSoap.traz_cep_partes(IWCep.Text);
  UserSession.CdsTabClientesNATUREZA.AsString := GetEndereco('Tipo', Endereco);
  UserSession.CdsTabClientesLOGRADOURO.AsString := GetEndereco('Endereco', Endereco);
  UserSession.CdsTabClientesBAIRRO.AsString := GetEndereco('Bairro', Endereco);
  UserSession.CdsTabClientesCIDADE.AsString := GetEndereco('Cidade', Endereco);
  UserSession.CdsTabClientesUF.AsString := GetEndereco('Estado', Endereco);

  UserSession.CdsTabClientes.Post;

end;

procedure TIWFrmCadClientes.IWLink1Click(Sender: TObject);
begin
  UserSession.CdsTabClientes.CancelUpdates;
  Release;

end;

procedure TIWFrmCadClientes.IWLink2Click(Sender: TObject);
begin
  UserSession.CdsTabClientes.ApplyUpdates(0);
  Release;
end;

end.
