unit UserSessionUnit;

{
  This is a DataModule where you can add components or declare fields that are specific to 
  ONE user. Instead of creating global variables, it is better to use this datamodule. You can then
  access the it using UserSession.
}
interface

uses
  IWUserSessionBase, SysUtils, Classes, WideStrings, DB, SqlExpr, FMTBcd,
  DBClient, Provider;

type
  TIWUserSession = class(TIWUserSessionBase)
    Conexao: TSQLConnection;
    SDSTabClientes: TSQLDataSet;
    DSpTabClientes: TDataSetProvider;
    CdsTabClientes: TClientDataSet;
    DsTabClientes: TDataSource;
    CdsTabClientesNOME: TStringField;
    CdsTabClientesCPF: TIntegerField;
    CdsTabClientesRG: TIntegerField;
    CdsTabClientesOE: TStringField;
    CdsTabClientesDATAESPEDICAO: TDateField;
    CdsTabClientesNATUREZA: TStringField;
    CdsTabClientesLOGRADOURO: TStringField;
    CdsTabClientesNUMERO: TIntegerField;
    CdsTabClientesCOMPLEMENTO: TStringField;
    CdsTabClientesCEP: TIntegerField;
    CdsTabClientesBAIRRO: TStringField;
    CdsTabClientesCIDADE: TStringField;
    CdsTabClientesUF: TStringField;
    CdsTabClientesIDCLIENTE: TIntegerField;
    procedure CdsTabClientesNewRecord(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    function GenerateID(Gen: string): Integer;
  end;

implementation

{$R *.dfm}



{ TIWUserSession }

procedure TIWUserSession.CdsTabClientesNewRecord(DataSet: TDataSet);
begin
  CdsTabClientesIDCLIENTE.AsInteger := GenerateID('GEN_ID_CLIENTE');
end;

function TIWUserSession.GenerateID(Gen: string): Integer;
var
  sqlID: TSQLQuery;
begin
  sqlID := TSQLQuery.Create(nil);
  sqlID.SQLConnection := Conexao;
  try
    sqlID.SQL.Add('SELECT GEN_ID(' + Gen + ', 1) AS ID');
    sqlID.SQL.Add('  FROM RDB$DATABASE');
    sqlID.Open;

    if sqlID.RecordCount > 0 then
       Result := sqlID.FieldByName('ID').AsInteger
    else
       Result := -1;
  finally
    sqlID.Free;
  end;
end;

end.
