unit uPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, WideStrings, FMTBcd, DBClient, Provider, DB, SqlExpr, Grids, DBGrids,
  StdCtrls;

type
  TFrmPrincipal = class(TForm)
    dbgrdSales: TDBGrid;
    sqlconEmployee: TSQLConnection;
    sqldtsSales: TSQLDataSet;
    dspSales: TDataSetProvider;
    cdsSales: TClientDataSet;
    dtsSales: TDataSource;
    cdsSalesPO_NUMBER: TStringField;
    cdsSalesQTY_ORDERED: TIntegerField;
    cdsSalesTOTAL_VALUE: TFMTBCDField;
    cdsSalesDISCOUNT: TFloatField;
    cdsSalesDISCOUNT_VALUE: TFloatField;
    cdsSalesTOTAL_ITEM: TFloatField;
    chckbxOrder: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cdsSalesCalcFields(DataSet: TDataSet);
    procedure chckbxOrderClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmPrincipal: TFrmPrincipal;

implementation

{$R *.dfm}

procedure TFrmPrincipal.cdsSalesCalcFields(DataSet: TDataSet);
begin
  if ( cdsSales.State = dsInternalCalc ) then
  begin
    cdsSalesTOTAL_ITEM.Value :=
                  ( cdsSalesTOTAL_VALUE.AsFloat * cdsSalesQTY_ORDERED.AsFloat );
    cdsSalesDISCOUNT_VALUE.Value := ( cdsSalesTOTAL_ITEM.AsFloat -
                    ( cdsSalesTOTAL_ITEM.AsFloat * cdsSalesDISCOUNT.AsFloat ) );
  end;

end;

procedure TFrmPrincipal.chckbxOrderClick(Sender: TObject);
begin
  if chckbxOrder.Checked then
    cdsSales.IndexFieldNames := 'DISCOUNT_VALUE'
  else cdsSales.IndexFieldNames := '';
end;

procedure TFrmPrincipal.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  cdsSales.Close;
end;

procedure TFrmPrincipal.FormCreate(Sender: TObject);
begin
  cdsSales.Open;
end;

end.
