SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

CREATE SCHEMA IF NOT EXISTS `DBCLASSIFICADO` ;
SHOW WARNINGS;
USE `DBCLASSIFICADO`;

-- -----------------------------------------------------
-- Table `DBCLASSIFICADO`.`USUARIO`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `DBCLASSIFICADO`.`USUARIO` ;

SHOW WARNINGS;
CREATE  TABLE IF NOT EXISTS `DBCLASSIFICADO`.`USUARIO` (
  `ID` INT NOT NULL AUTO_INCREMENT ,
  `NOME` VARCHAR(50) NOT NULL ,
  `ENDERECO` VARCHAR(50) NULL ,
  `BAIRRO` VARCHAR(20) NULL ,
  `CIDADE` VARCHAR(30) NULL ,
  `CEP` CHAR(9) NULL ,
  `COMPLEMENTO` VARCHAR(30) NULL ,
  `EMAIL` VARCHAR(100) NOT NULL ,
  `SENHA` VARCHAR(10) NOT NULL ,
  `VIP` CHAR(1) NULL ,
  `ATIVO` CHAR(1) NULL ,
  `NIVEL` SMALLINT NULL ,
  PRIMARY KEY (`ID`) );

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `DBCLASSIFICADO`.`VEICULO`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `DBCLASSIFICADO`.`VEICULO` ;

SHOW WARNINGS;
CREATE  TABLE IF NOT EXISTS `DBCLASSIFICADO`.`VEICULO` (
  `ID` INT NOT NULL AUTO_INCREMENT ,
  `MARCA` VARCHAR(20) NOT NULL ,
  `MODELO` VARCHAR(30) NOT NULL ,
  `VERSAO` VARCHAR(30) NULL ,
  `ANO` INT NOT NULL ,
  `COR` VARCHAR(20) NULL ,
  `PORTAS` SMALLINT NULL ,
  `AR` CHAR(1) NULL COMMENT 'AR CONDICIONADO' ,
  `VE` CHAR(1) NULL COMMENT 'VIDROS ELETRICOS' ,
  `DH` CHAR(1) NULL COMMENT 'DIRECAO HIDRAULICA' ,
  `TE` CHAR(1) NULL COMMENT 'TRAVAS ELETRICAS' ,
  `LL` CHAR(1) NULL COMMENT 'RODAS LIGA LEVE' ,
  `CD` INT NULL COMMENT 'CD PALYER' ,
  `DVD` CHAR(1) NULL COMMENT 'DVD PLAYER' ,
  `BC` CHAR(1) NULL COMMENT 'BANCOS DE COURO' ,
  `AL` CHAR(1) NULL COMMENT 'ALARME' ,
  `ABS` CHAR(1) NULL COMMENT 'FREIOS ABS' ,
  `LT` CHAR(1) NULL COMMENT 'LIMPADOR TRASEIRO' ,
  `UF` CHAR(2) NOT NULL ,
  `VALOR` DECIMAL(9,2) NULL ,
  `OBSERVACAO` TEXT NULL ,
  `USUARIO_ID` INT NULL ,
  PRIMARY KEY (`ID`) ,
  CONSTRAINT `fk_VEICULO_USUARIO`
    FOREIGN KEY (`USUARIO_ID` )
    REFERENCES `DBCLASSIFICADO`.`USUARIO` (`ID` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

SHOW WARNINGS;
CREATE INDEX fk_VEICULO_USUARIO ON `DBCLASSIFICADO`.`VEICULO` (`USUARIO_ID` ASC) ;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `DBCLASSIFICADO`.`FOTOS`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `DBCLASSIFICADO`.`FOTOS` ;

SHOW WARNINGS;
CREATE  TABLE IF NOT EXISTS `DBCLASSIFICADO`.`FOTOS` (
  `ID` INT NOT NULL AUTO_INCREMENT ,
  `PATH` VARCHAR(100) NOT NULL ,
  `VEICULO_ID` INT NULL ,
  PRIMARY KEY (`ID`) ,
  CONSTRAINT `fk_FOTOS_VEICULO`
    FOREIGN KEY (`VEICULO_ID` )
    REFERENCES `DBCLASSIFICADO`.`VEICULO` (`ID` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

SHOW WARNINGS;
CREATE INDEX fk_FOTOS_VEICULO ON `DBCLASSIFICADO`.`FOTOS` (`VEICULO_ID` ASC) ;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `DBCLASSIFICADO`.`NOTICIA`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `DBCLASSIFICADO`.`NOTICIA` ;

SHOW WARNINGS;
CREATE  TABLE IF NOT EXISTS `DBCLASSIFICADO`.`NOTICIA` (
  `ID` INT NOT NULL AUTO_INCREMENT ,
  `TITULO` VARCHAR(45) NOT NULL ,
  `SINOPSE` VARCHAR(255) NOT NULL ,
  `TEXTO` TEXT NOT NULL ,
  `DATA` DATE NOT NULL ,
  PRIMARY KEY (`ID`) )
COMMENT = 'Notícias para página principal.';

SHOW WARNINGS;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
