unit uFrmPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, cxGraphics, ActnList, dxBar, cxClasses, ComCtrls, cxControls,
  cxContainer, cxEdit, cxTextEdit, cxMaskEdit, cxDropDownEdit, StdCtrls,
  FileCtrl, StarTeam_TLB, DB, dxmdaset, cxStyles, cxCustomData, cxFilter,
  cxData, cxDataStorage, cxDBData, cxGridCustomTableView, cxGridTableView,
  cxGridDBTableView, cxGridLevel, cxGridCustomView, cxGrid, ExtCtrls;

type
  TFrmPrincipal = class(TForm)
    mdtTasks: TdxMemData;
    mdtTasksNumero: TIntegerField;
    mdtTasksNome: TStringField;
    mdtTasksAtualTermino: TDateField;
    mdtTasksAtualInicio: TDateField;
    mdtTasksAtualHoras: TFloatField;
    mdtTasksEstimadoInicio: TDateField;
    mdtTasksEstimadoTermino: TDateField;
    mdtTasksEstimadoHoras: TFloatField;
    mdtTasksEstado: TStringField;
    mdtTasksRecurso: TStringField;
    dtsTasks: TDataSource;
    mdtTasksDifHoras: TFloatField;
    Panel1: TPanel;
    cmbProjeto: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    cmbVisao: TComboBox;
    cxGrid1: TcxGrid;
    cxGrid1DBTableView1: TcxGridDBTableView;
    cxGrid1DBTableView1Numero: TcxGridDBColumn;
    cxGrid1DBTableView1Nome: TcxGridDBColumn;
    cxGrid1DBTableView1Estado: TcxGridDBColumn;
    cxGrid1DBTableView1Recurso: TcxGridDBColumn;
    cxGrid1DBTableView1EstimadoInicio: TcxGridDBColumn;
    cxGrid1DBTableView1EstimadoTermino: TcxGridDBColumn;
    cxGrid1DBTableView1EstimadoHoras: TcxGridDBColumn;
    cxGrid1DBTableView1AtualInicio: TcxGridDBColumn;
    cxGrid1DBTableView1AtualTermino: TcxGridDBColumn;
    cxGrid1DBTableView1AtualHoras: TcxGridDBColumn;
    cxGrid1DBTableView1DifHoras: TcxGridDBColumn;
    cxGrid1Level1: TcxGridLevel;
    procedure FormCreate(Sender: TObject);
    procedure cmbProjetoChange(Sender: TObject);
    procedure cmbVisaoChange(Sender: TObject);
  private
    procedure CarregarTasks(pVisao: IStView);
  public
    { Public declarations }
  end;

var
  FrmPrincipal: TFrmPrincipal;

implementation

uses
  uStarTeam;

{$R *.dfm}

procedure TFrmPrincipal.CarregarTasks(pVisao: IStView);
var
  aNo     : TTreeNode;
  i       : Integer;
  Items   : StarTeam_TLB.IStItems;
  iLoop   : Integer;
  StTask  : StarTeam_TLB.IStTask;
begin
  Items   := pVisao.RootFolder.getList('Task');
  mdtTasks.Open;
  for iLoop := 0 to Items.Count - 1 do
  begin
    StTask := Items.getAt(iLoop) as IStTask;
    mdtTasks.Append;
    mdtTasksNumero.AsInteger           := StTask.Number;
    mdtTasksNome.AsString              := StTask.Name;
    mdtTasksAtualInicio.AsDateTime     := StTask.ActualStart;
    mdtTasksAtualTermino.AsDateTime    := StTask.ActualFinish;
    mdtTasksAtualHoras.AsFloat         := StTask.ActualHours;
    mdtTasksEstimadoInicio.AsDateTime  := StTask.EstimatedStart;
    mdtTasksEstimadoTermino.AsDateTime := StTask.EstimatedFinish;
    mdtTasksEstimadoHoras.AsFloat      := StTask.EstimatedHours;
    mdtTasksDifHoras.AsFloat           := StTask.EstimatedHoursVariance;
    mdtTasksEstado.AsString            := StarTeam.GetStatusDescription(StTask.Status);
    mdtTasksRecurso.AsString           := StarTeam.GetUser(StTask.Responsibility);
    mdtTasks.Post;
  end;
end;


procedure TFrmPrincipal.cmbProjetoChange(Sender: TObject);
begin
  if cmbProjeto.Text <> '' then
  begin
    cmbVisao.Clear;
    StarTeam.OpenProject(cmbProjeto.Text);
    cmbVisao.Items := StarTeam.STViews;
  end;
end;

procedure TFrmPrincipal.cmbVisaoChange(Sender: TObject);
begin
  if cmbVisao.Text <> '' then
  begin
    StarTeam.OpenView(cmbVisao.Text);
    CarregarTasks(StarTeam.STView);
  end;
end;


procedure TFrmPrincipal.FormCreate(Sender: TObject);
begin
  cmbProjeto.Items := StarTeam.STProjects;
end;


end.
