unit uStarTeam;

interface

uses Classes, SysUtils, Dialogs, StarTeam_TLB;

type
  TStarTeam = class
  private
    FMyUser        : String;
    FSenha         : String;
    FMyServer      : String;
    FMyPort        : Integer;
    FServer        : IStServer;
    FProject       : IStProject;
    FView          : IStView;
    FProjects      : TStringList;
    FViews         : TStringList;
  protected
    function getProjects  : TStringList;
    function getViews     : TStringList;
  public
    constructor Create;
    destructor  Destroy; override;

    function Login(const aServer : String; const aPort     : integer;
                   const aUser   : String; const aPassWord : String) : Boolean;

    function  GetUser(aID: Integer): String;
    function  GetStatusDescription(aStatus : Integer): string;
    procedure OpenProject(const aProject : String);
    procedure OpenView(const aView : String);

    property STProjects : TStringList read getProjects;
    property STViews    : TStringList read getViews;
    property STServer   : IStServer   read FServer;
    property STProject  : IStProject  read FProject;
    property STView     : IStView     read FView;
    property MyServer   : String      read FMyServer;
    property MyPort     : Integer     read FMyPort;
    property MyUser     : String      read FMyUser;
end;


var
  StarTeam : TStarTeam;

implementation

{ TStarTeam }
{Mtodo Open Project  responsvel por fazer a abertura de um projeto no StarTeam,
 o nosso mtodo faz uma pesquisa nos projetos existentes no StarTeam e quando acha
 um projeto com o mesmo nome ao do parmetro aProject faz um typecast e traz uma
 representao do mesmo atravs de FPRoject}
 
procedure TStarTeam.OpenProject(const aProject: String);
var
  vProjeto  : IStProject;
  i         : Integer;
begin
  for i := 0 to FServer.Projects.Count-1 do
  begin
    vProjeto := IDispatch(FServer.Projects[i]) as IStProject;
    if AnsiLowerCase(vProjeto.Name) = AnsiLowerCase(aProject) then
    begin
      FProject := IDispatch(FServer.Projects[i]) as IStProject;
      Exit;
    end;
  end;
end;

procedure TStarTeam.OpenView(const aView: String);
var
  vVisao : IStView;
  vTasks : IStTask;
  i      : Integer;
begin
  for i := 0 to FProject.Views.Count-1 do
  begin
    vVisao := IDispatch(FProject.Views[i]) as IStView;
    if AnsiUpperCase(vVisao.Name) = AnsiUpperCase(aView) then
    begin
      FView := vVisao;
      Exit;
    end;
  end;
end;


function TStarTeam.GetUser(aID: Integer): String;
var
  vUser : ISTUser;
  i     : Integer;
begin
  Result := '';
  for i := 0 to StarTeam.STServer.Users.Count -1 do
  begin
    vUser := ISTUser(IDispatch(StarTeam.STServer.Users[i]));
    if vUser.ID = aID then
    begin
      Result := vUser.Name;
      Break;
    end;
  end;
end;

constructor TStarTeam.Create;
begin
  FProjects := TStringList.Create;
  FViews    := TStringList.Create;
end;

destructor TStarTeam.Destroy;
begin
  FreeAndNil(FProjetos);
  FreeAndNil(FVisoes);
  inherited;
end;

function TStarTeam.getProjects: TStringList;
var
  vProjetos : IStCollection;
  i         : integer;
begin
  FProjects.Clear;
  vProjetos := FServer.Projects;
  for i := 0 to vProjetos.Count - 1 do
    FProjects.AddObject(vProjetos.Item[i].Name, TObject(i));
  Result := FProjects;
end;


function TStarTeam.getViews: TStringList;
var
  vVisoes : IStCollection;
  vVisao  : IStView;
  i       : integer;
begin
  FViews.Clear;
  vVisoes := FProject.Views;
  for i := 0 to vVisoes.Count - 1 do
  begin
    vVisao := IDispatch(vVisoes.Item[i]) as IStView;
    FViews.AddObject(vVisao.Name, TObject(vVisao.ViewId));
  end;
  Result := FViews;
end;


function TStarTeam.Login(const aServer: String; const aPort: integer;
  const aUser, aPassWord: String): Boolean;
var
  vServidor : IStServerFactory;
begin
  Result := False;
  try
    vServidor     := CoStServerFactory.Create;
    FServer     := vServidor.Create(aServer,aPort);
    FServer.LogOn(aUser, aPassWord);
    FMyServer := aServer;
    FMyPort        := aPort;
    FMyUser      := aUser;
    FSenha        := aPassWord;
    Result        := True;
  except
    on E : Exception do
    begin
      MessageDlg('No foi possivel se conectar!' + #13 +
                 'Erro: ' + E.Message, mtError, [mbOk], 0);
    end;
  end;
end;


function TStarTeam.GetStatusDescription(aStatus: Integer): string;
begin
  Result := '';
  case aStatus of
    1: Result := 'Pendente';
    2: Result := 'Em Progresso';
    3: Result := 'Finalizado';
    4: Result := 'Fechado';
  end;
end;

end.
