unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, cdburner,ShellAPI, ComCtrls, StdCtrls, Buttons, ExtCtrls, ImgList,
  XPMan, Gauges, FileCtrl;

type
  TfrmMain = class(TForm)
    CDBurner: TCDBurner;
    lstArquivos: TListView;
    lbledtGravador: TLabeledEdit;
    lbledtArmazenamento: TLabeledEdit;
    btnAdicionar: TBitBtn;
    ImageList: TImageList;
    OpenDialog: TOpenDialog;
    btnRemover: TBitBtn;
    XPManifest: TXPManifest;
    lblTamanho: TLabel;
    btnGravar: TBitBtn;
    Gauge: TGauge;
    btnPasta: TBitBtn;
    lblArquivos: TLabel;
    procedure btnPastaClick(Sender: TObject);
    procedure btnGravarClick(Sender: TObject);
    procedure btnRemoverClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnAdicionarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FileInfo: TSHFileInfo;
    Picture: TPicture;
    ListItem : TListItem;
  public
    procedure UpdateGauge;
    procedure UpdateList(FileName: string);
    procedure GetIcon(aFileName: string; var FileInfo: TSHFileInfo);
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.btnAdicionarClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    begin
    CDBurner.AddFile(ExtractFileName(OpenDialog.FileName),
      ExtractFilePath(OpenDialog.FileName));
    UpdateList(OpenDialog.FileName);
    end;
end;

procedure TfrmMain.btnGravarClick(Sender: TObject);
begin
  CDBurner.StartBurn;
end;

procedure TfrmMain.btnPastaClick(Sender: TObject);
var
  ChosenDirectory : string;
begin
  if SelectDirectory('Selecione uma pasta', 'C:\', ChosenDirectory) then
    begin
    CDBurner.AddFolder(ChosenDirectory);
    UpdateList(ChosenDirectory);
    end;
end;

procedure TfrmMain.btnRemoverClick(Sender: TObject);
begin
  lstArquivos.Items.Clear;
  CDBurner.ClearFiles;
  UpdateGauge;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Picture := TPicture.Create;
  lbledtGravador.Text := CDBurner.BurnerDrive;
  lbledtArmazenamento.Text := CDBurner.BurnArea;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  Picture.Free;
end;

procedure TfrmMain.GetIcon(aFileName: string; var FileInfo: TSHFileInfo);
begin
  SHGetFileInfo(PChar(aFileName), FILE_ATTRIBUTE_NORMAL, FileInfo,
    SizeOf(FileInfo), SHGFI_ICON or SHGFI_SMALLICON);
end;

procedure TfrmMain.UpdateGauge;
begin
  Gauge.Progress:= Round(CDBurner.BurnSize / (1024 * 1000));
end;

procedure TfrmMain.UpdateList(FileName: string);
begin
  ListItem := lstArquivos.Items.Add;
  ListItem.Caption := ExtractFileName(FileName);
  ListItem.ImageIndex := ImageList.Count;
  GetIcon(FileName, FileInfo);
  Picture.Icon.Handle := FileInfo.hIcon;
  ImageList.AddIcon(Picture.Icon);
  UpdateGauge;
end;

end.
