unit URemote;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, DrpServidorDs01_TLB, StdVcl, WideStrings, DB, SqlExpr, FMTBcd,
  Provider;

type
  TcoServidorDs01 = class(TRemoteDataModule, IcoServidorDs01)
    SqlCnConexao: TSQLConnection;
    SqlDsVendas: TSQLDataSet;
    DspVendas: TDataSetProvider;
  private
    { Private declarations }
    procedure ContadorUsuario;
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    procedure Login(const usuario: WideString); safecall;
    procedure Logout(const usuario: WideString); safecall;
  public
    { Public declarations }
  end;

implementation

uses UMenu;

{$R *.DFM}

class procedure TcoServidorDs01.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TcoServidorDs01.ContadorUsuario;
var contador:integer;
begin
  contador:=FrmMenu.lbxUsuario.Count;
  FrmMenu.lblContador.Caption:= FormatCurr('000',contador);
end;

procedure TcoServidorDs01.Login(const usuario: WideString);
begin
  FrmMenu.lbxUsuario.Items.Add(usuario);
  ContadorUsuario;
end;

procedure TcoServidorDs01.Logout(const usuario: WideString);
var index:integer;
begin
  index:=FrmMenu.lbxUsuario.Items.IndexOf(usuario);
  FrmMenu.lbxUsuario.Items.Delete(index);
  ContadorUsuario;
end;

initialization
  TComponentFactory.Create(ComServer, TcoServidorDs01,
    Class_coServidorDs01, ciMultiInstance, tmApartment);
end.
