{*******************************************************}
{* Unit : MhPtnObserver.pas                            *}
{* Implementao do Pattern Observer                   *}
{* Miguel Angelo Henley F. (mhenley@datamag.com.br )   *}
{*******************************************************}

Unit MhPtnObserver;

interface

uses Classes, SysUtils;

type
  EmhPtnObserver = class(Exception);

  TmhObserverCallBack = procedure(prObjeto : TObject) of object;

  TmhObserver = class
  private
    FEventos : TList;

    procedure SetCallBack(prIndice : integer; prCallBack : TmhObserverCallBack);
    function GetCallBack(prIndice : integer) : TmhObserverCallBack;

    function ObterQtdRegistros : integer;

  public
    procedure Registrar(prCallBack : TmhObserverCallBack);
    procedure Remover(prIndice : integer);
    procedure Notificar(prObjeto : TObject);

  constructor Create;
  destructor Destroy; override;

  property
    CallBack[prIndice : integer] : TmhObserverCallBack read GetCallBack write SetCallBack;

  property
    QtdRegistros : integer read ObterQtdRegistros;

end;

implementation

{ TmhObserver }

type
  TmhAuxObserver = class
  private
    FCallBack : TmhObserverCallBack;
  public
    property CallBack : TmhObserverCallBack read FCallBack write FCallBack;
  end;

{ ----- }
constructor TmhObserver.Create;
begin
  inherited Create;
  FEventos := TList.Create;
end;
{ ----- }
destructor TmhObserver.Destroy;
var
  linFor : integer;
begin
  for linFor := 0 to ObterQtdRegistros-1 do
   TmhAuxObserver(FEventos[linFor]).Free;

  FEventos.Free;
  inherited;
end;

{ ----- }

function TmhObserver.GetCallBack(prIndice: integer): TmhObserverCallBack;
var
  lobAux : TmhAuxObserver;
begin
  // checa os limites:
  if (prIndice < 0) or (prIndice > ObterQtdRegistros - 1) then
   raise EmhPtnObserver.Create('Indice fora dos limites');

  lobAux := TmhAuxObserver(FEventos[prIndice]);
  Result := lobAux.CallBack;
end;

{ ----- }

procedure TmhObserver.SetCallBack(prIndice: integer;
  prCallBack: TmhObserverCallBack);
begin
  // checa os limites:
  if (prIndice < 0) or (prIndice > ObterQtdRegistros - 1) then
    raise EmhPtnObserver.Create('Indice fora dos limites');

   TmhAuxObserver(FEventos[prIndice]).CallBack := prCallBack;
end;

{ ----- }

procedure TmhObserver.Notificar(prObjeto: TObject);
var
  linFor : integer;
  lobAux : TmhAuxObserver;
begin
  for linFor := 0 to ObterQtdRegistros-1 do
  begin
    lobAux := TmhAuxObserver(FEventos[linFor]);
    lobAux.CallBack(prObjeto);
  end;
end;

{ ----- }

function TmhObserver.ObterQtdRegistros: integer;
begin
  Result := FEventos.Count;
end;

{ ----- }
procedure TmhObserver.Registrar(prCallBack: TmhObserverCallBack);
var
  lobAuxObserver : TmhAuxObserver;
begin
  lobAuxObserver := TmhAuxObserver.Create;
  lobAuxObserver.FCallBack := prCallBack;
  FEventos.Add(lobAuxObserver);
end;

{ ----- }

procedure TmhObserver.Remover(prIndice: integer);
begin
  // checa os limites:
  if (prIndice<0) or (prIndice>ObterQtdRegistros-1) then
    raise EmhPtnObserver.Create('Indice fora dos limites');

  TmhAuxObserver(FEventos[prIndice]).Free;
  FEventos.Delete(prIndice);
end;

end.

