unit UnPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, MhPtnObserver;

type
  TReal = array of real;

  TFmPrincipal = class(TForm)
    edtValor: TEdit;
    lstbxLista: TListBox;
    btnIncluir: TButton;
    btnExcluir: TButton;
    btnFechar: TButton;
    procedure btnIncluirClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnExcluirClick(Sender: TObject);
    procedure btnFecharClick(Sender: TObject);
  private
    { Private declarations }
    FPtnObserver : TmhObserver;
    procedure Notificar;
  public
    { Public declarations }
    procedure Registrar(prCallBack : TmhObserverCallBack);
    procedure Remover(prIndice : integer);

    function ObterValores : TReal;
  end;

var
  FmPrincipal: TFmPrincipal;

implementation

{$R *.dfm}

{ TFmPrincipal }

procedure TFmPrincipal.Notificar;
begin
  // delega para o objeto FPtnObserver
  FPtnObserver.Notificar(nil);
end;

function TFmPrincipal.ObterValores: TReal;
var
  laValores : TReal;
  linFor    : integer;
begin
  SetLength(laValores,lstbxLista.Count);

  for linFor := 0 to lstbxLista.Count-1 do
  try
    laValores[linFor] := StrToFloat(lstbxLista.Items.Strings[linFor]);
  except
    laValores[linFor] := 0;
  end;

  Result := laValores;
end;

procedure TFmPrincipal.Registrar(prCallBack: TmhObserverCallBack);
begin
  // delega para o objeto FPtnObserver
  FPtnObserver.Registrar(prCallBack);
end;

procedure TFmPrincipal.Remover(prIndice: integer);
begin
  // delega para o objeto FPtnObserver
  FPtnObserver.Remover(prIndice);
end;


procedure TFmPrincipal.btnIncluirClick(Sender: TObject);
begin
  lstbxLista.Items.Add(edtValor.Text);
  Notificar;
  edtValor.Text := '';
  edtValor.SetFocus;
end;

procedure TFmPrincipal.FormCreate(Sender: TObject);
begin
  FPtnObserver := TmhObserver.Create;
end;

procedure TFmPrincipal.FormDestroy(Sender: TObject);
begin
  FPtnObserver.Free;
end;

procedure TFmPrincipal.btnExcluirClick(Sender: TObject);
begin
  if lstbxLista.ItemIndex = -1 then
  begin
    ShowMessage('Selecione um elemento da lista.');
    Exit;
  end;

  lstbxLista.Items.Delete(lstbxLista.ItemIndex);
  Notificar;
end;

procedure TFmPrincipal.btnFecharClick(Sender: TObject);
begin
  Close;
end;

end.
