unit Unit1;

interface

uses
  Classes, SysUtils, IWAppForm, IWApplication, IWColor, IWTypes,
  IWVCLBaseControl, IWBaseControl, IWBaseHTMLControl, IWControl, IWCompLabel,
  Controls, Forms, IWVCLBaseContainer, IWContainer, IWHTMLContainer,
  IWHTML40Container, IWRegion, IWCompEdit, IWExtCtrls, IWGrids, IWDBGrids,
  Graphics, IWCompButton;

type
  TFrmMenu = class(TIWAppForm)
    iwrSubTitulo: TIWRegion;
    IWLabel1: TIWLabel;
    IwrPesquisa: TIWRegion;
    IWLabel2: TIWLabel;
    iwEdtCodigo: TIWEdit;
    IWLabel3: TIWLabel;
    iwEdtNome: TIWEdit;
    iwrMensagem: TIWRegion;
    IWDBGrid1: TIWDBGrid;
    iwLblMensagem: TIWLabel;
    iwbtnPesquisa: TIWButton;
    iwbtnLoginLogout: TIWButton;
    procedure IWAppFormCreate(Sender: TObject);
    procedure iwbtnPesquisaClick(Sender: TObject);
    procedure iwbtnLoginLogoutClick(Sender: TObject);
  private
    FUsuario: string;
    procedure SetUsuario(const Value: string);
  published
  public
    property Usuario:string read FUsuario write SetUsuario;
  end;

implementation

uses ServerController, UserSessionUnit;

{$R *.dfm}


{ TFrmMenu }

procedure TFrmMenu.SetUsuario(const Value: string);
begin
  FUsuario := Value;
end;

procedure TFrmMenu.IWAppFormCreate(Sender: TObject);
begin
  Self.Usuario:='Usurio Web :'+ TimeToStr(time);
end;

procedure TFrmMenu.iwbtnPesquisaClick(Sender: TObject);
var codigo:integer;
begin
 iwLblMensagem.Text:='Mensagem: ';
 try
   codigo:=StrToInt(iwEdtcodigo.text);
 except
   iwLblMensagem.Text:='Mensagem: Cdigo invlido!';
   iwEdtCodigo.SetFocus;
   exit;
 end;

 with UserSession.cdsVenda do begin
   Close;
   FetchParams;
   Params.ParamByName('codigo').AsInteger:=codigo;
   Open;
   if recordCount = 0 then begin
      iwLblMensagem.Text:='Mensagem: Nenhuma venda foi encontrada com esse parmetro!';
      exit;
   end;
   iwedtNome.Text:=FieldByName('Customer').AsString;
 end;
end;

procedure TFrmMenu.iwbtnLoginLogoutClick(Sender: TObject);
begin
  if iwbtnLoginLogout.Text='Login' then begin
     iwbtnLoginLogout.Text:='Logout';
     iwBtnPesquisa.Enabled:=true;
     UserSession.ScktCnDs01.Connected:=true;
     UserSession.ScktCnDs01.AppServer.Login(Self.Usuario);
  end
  else begin
    iwbtnLoginLogout.Text:='Login';
    iwBtnPesquisa.Enabled:=false;
    UserSession.ScktCnDs01.AppServer.Logout(Self.Usuario);
    UserSession.ScktCnDs01.Connected:=false;
  end;
end;


initialization
  TFrmMenu.SetAsMainForm;
end.
