unit uCadastro;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, DBActns, ActnList, StdCtrls,
  Buttons, ComCtrls, ImgList, Menus, SqlExpr, DB, AppEvnts;

type
  TfrmCadastro = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    ActionList1: TActionList;
    ImageList1: TImageList;
    StatusBar1: TStatusBar;
    DataSource1: TDataSource;
    MainMenu1: TMainMenu;
    Arquivo1: TMenuItem;
    Relatrio1: TMenuItem;
    N1: TMenuItem;
    Sair1: TMenuItem;
    btnNovo: TBitBtn;
    btnExcluir: TBitBtn;
    btnSalvar: TBitBtn;
    btnLocalizar: TBitBtn;
    ApplicationEvents1: TApplicationEvents;
    actNovo: TAction;
    actExcluir: TAction;
    actSalvar: TAction;
    actLocalizar: TAction;
    actRelatorio: TAction;
    procedure Sair1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure TabSheet1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnNovoEnter(Sender: TObject);
    procedure btnLocalizarClick(Sender: TObject);
    procedure NovoExecute(Sender: TObject);
    procedure actNovoExecute(Sender: TObject);
    procedure actExcluirExecute(Sender: TObject);
    procedure actSalvarExecute(Sender: TObject);
  private
    { Private declarations }

  public
    procedure funcionalidades;
    procedure campos;

    procedure DisableEnableControls (Value : Boolean);
    function FieldsWrithe (DtSrc : TDataSource): Boolean;
  end;

var
  frmCadastro: TfrmCadastro;

implementation

uses uDM, DBCtrls;


{$R *.dfm}

procedure TfrmCadastro.Sair1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmCadastro.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  {: presisonamento da tecla ESC }
  if key = VK_Escape then
    Close;
end;

procedure TfrmCadastro.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
   {: verifica se esta em modo de edio ou insero}
   if DataSource1.State in [dsEdit,dsInsert] then
       case MessageDlg('Deseja salvar as alteraes realizados no Cadastro ?', mtConfirmation, [mbYes,mbNo,mbCancel], 0) of
         mrYes : begin
                 DataSource1.DataSet.Post;
                 CanClose := True;
                 end;
         mrNo :  begin
                 DataSource1.DataSet.Cancel;
                 CanClose := True;
                 end;
         mrCancel : CanClose := False;
       end;
end;

procedure TfrmCadastro.DataSource1DataChange(Sender: TObject;
  Field: TField);
begin
   {: verifica o estado do DataSource para mostrar na barra }
   case DataSource1.State of
     dsEdit: StatusBar1.Panels[1].Text := 'Alterando';
     dsInsert: StatusBar1.Panels[1].Text := 'Inserindo';
     dsBrowse: StatusBar1.Panels[1].Text := 'Navegando';
   end;
   DisableEnableControls(not DataSource1.DataSet.IsEmpty);
   {: habilita os botes de acordo com o estado do DataSource }
   actSalvar.Enabled := DataSource1.State in [dsEdit, dsInsert];
   actExcluir.Enabled := DataSource1.State in [dsEdit];
   {: verifica permisses }
   funcionalidades;
   {: verifica campos }
   campos;
end;

procedure TfrmCadastro.DisableEnableControls(Value: Boolean);
var
  i : integer;
begin
{: faz um lao em todos os componentes}
  for i := 0 to ComponentCount -1 do
  begin
    if (Components[i] is TCustomEdit) then
       (Components[i] as TCustomEdit).Enabled := Value;
    if (Components[i] is TBitBtn) then
       (Components[i] as TBitBtn).Enabled := Value;
  end;
  btnNovo.Enabled := True;
  btnLocalizar.Enabled := True;
end;

procedure TfrmCadastro.FormKeyPress(Sender: TObject; var Key: Char);
begin
  {: troca ENTER por TAB}
  if key = #13 then
  begin
    Perform (CM_DialogKey, VK_TAB, 0);
    key:=#0;
  end
end;

procedure TfrmCadastro.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  {: limpa a StatusBar}
  StatusBar1.Panels[0].Text := '';
end;

procedure TfrmCadastro.funcionalidades;
begin
  //verifica as funcionalidades existentes para os botes
  DM.VerificaFuncionalidades(Self.Name);
  //habilita ou desabilita botes e itens de menu
  actNovo.Enabled := (DM.cdsFuncionalidades.Locate('NOME_FUNCIONALIDADE', 'Novo', [loPartialKey, loCaseInsensitive]));
  actSalvar.Enabled := (DM.cdsFuncionalidades.Locate('NOME_FUNCIONALIDADE', 'Salvar', [loPartialKey, loCaseInsensitive]));
  actExcluir.Enabled := (DM.cdsFuncionalidades.Locate('NOME_FUNCIONALIDADE', 'Excluir', [loPartialKey, loCaseInsensitive]));
  actRelatorio.Enabled := (DM.cdsFuncionalidades.Locate('NOME_FUNCIONALIDADE', 'Relatorio', [loPartialKey, loCaseInsensitive]));
  actLocalizar.Enabled := (DM.cdsFuncionalidades.Locate('NOME_FUNCIONALIDADE', 'Localizar', [loPartialKey, loCaseInsensitive]));
end;

function TfrmCadastro.FieldsWrithe(DtSrc: TDataSource): Boolean;
var
  i : integer;
{: verifica quais os campos que esto em branco no cadastro}
begin
  Result := True; {: assume que esto todos preenchidos}
  for i := 0 to DtSrc.DataSet.FieldCount - 1 do
    if DtSrc.DataSet.Fields[i].Required then
      if (DtSrc.DataSet.Fields[i].IsNull) Or
         (DtSrc.DataSet.Fields[i].AsString = '') then
      begin
        MessageDlg('Preencha o campo " '+ DtSrc.DataSet.Fields[i].DisplayLabel + '"', mtWarning,[mbOk], 0);
        Result := False;
        DtSrc.DataSet.Fields[i].FocusControl; {: coloca o foco no controle}
        Break;
      end;
end;

procedure TfrmCadastro.TabSheet1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  {: limpa a StatusBar}
  StatusBar1.Panels[0].Text := '';
end;

procedure TfrmCadastro.btnNovoEnter(Sender: TObject);
begin
  StatusBar1.Panels[0].Text := (Sender as TControl).Hint;
end;

procedure TfrmCadastro.campos;
var
  i: Integer;
begin
  {: chama metodo do DM }
  DM.VerificaCampos(Self.Name);
  {: percorre os campos do formulrio }
  for i:= 0 to ComponentCount - 1 do
  begin
    if Components[i] is TDBEdit then
    begin
      if DM.cdsCampos.Locate('NOME_CAMPO', (Components[i] as TDBEdit).DataField, [loPartialKey, loCaseInsensitive]) then
      begin
        (Components[i] as TDBEdit).Visible := (DM.cdsCamposVISUALIZAR.AsString = 'T');
        (Components[i] as TDBEdit).Enabled := (DM.cdsCamposALTERAR.AsString = 'T');
      end;
    end;
  end;
end;

procedure TfrmCadastro.actExcluirExecute(Sender: TObject);
begin
  {: deleta se houver dados no DataSet }
  if (DataSource1.DataSet.Active) And (DataSource1.DataSet.RecordCount > 0) then
  begin
    if MessageDlg('Tem certeza que deseja excluir o registro ?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
      DataSource1.DataSet.Delete;
  end;
end;

procedure TfrmCadastro.actNovoExecute(Sender: TObject);
begin
  DataSource1.DataSet.Insert;
end;

procedure TfrmCadastro.actSalvarExecute(Sender: TObject);
begin
  {: salvo as dados se os campos estiverem preenchidos}
  if FieldsWrithe(DataSource1) And
    (DataSource1.State in [dsEdit, dsInsert]) then
      DataSource1.DataSet.Post;
end;

procedure TfrmCadastro.btnLocalizarClick(Sender: TObject);
begin
  {: verifica se esta em modo de edio ou insero}
  if DataSource1.State in [dsEdit,dsInsert] then
    case MessageDlg('Deseja salvar as alteraes realizados no Cadastro ?', mtConfirmation, [mbYes,mbNo,mbCancel], 0) of
     mrYes: btnSalvar.Click;
     mrNo: DataSource1.DataSet.Cancel;
    end;
end;

procedure TfrmCadastro.NovoExecute(Sender: TObject);
begin
  {: novo registro}
  DataSource1.DataSet.Insert;
end;

end.
