unit uDM;

interface

uses
  SysUtils, Classes, WideStrings, DB, SqlExpr, FMTBcd, Provider, DBClient, TBODBXDynalink;

type
  TDM = class(TDataModule)
    SQLConnection1: TSQLConnection;
    sdtBusca: TSQLDataSet;
    dspBusca: TDataSetProvider;
    cdsUsuario: TClientDataSet;
    cdsFuncionalidades: TClientDataSet;
    cdsCampos: TClientDataSet;
    cdsUsuarioID: TIntegerField;
    cdsUsuarioNOME: TStringField;
    cdsUsuarioSENHA: TStringField;
    cdsUsuarioADM: TStringField;
    cdsCamposID: TIntegerField;
    cdsCamposID_CADASTRO: TIntegerField;
    cdsCamposID_USUARIO: TIntegerField;
    cdsCamposNOME_CAMPO: TStringField;
    cdsCamposALTERAR: TStringField;
    cdsCamposVISUALIZAR: TStringField;
    cdsCamposNOME_CADASTRO: TStringField;
    cdsFuncionalidadesID: TIntegerField;
    cdsFuncionalidadesID_USUARIO: TIntegerField;
    cdsFuncionalidadesID_CADASTRO: TIntegerField;
    cdsFuncionalidadesID_FUNCIONALIDADE: TIntegerField;
    cdsFuncionalidadesNOME_CADASTRO: TStringField;
    cdsFuncionalidadesNOME_FUNCIONALIDADE: TStringField;
    cdsClientes: TClientDataSet;
    cdsClientesID: TIntegerField;
    cdsClientesNOME_CLIENTE: TStringField;
    cdsFornecedores: TClientDataSet;
    cdsFornecedoresID: TIntegerField;
    cdsFornecedoresNOME_FORNECEDOR: TStringField;
    cdsFornecedoresCIDADE: TStringField;
    cdsFuncUsuario: TClientDataSet;
    IntegerField1: TIntegerField;
    IntegerField2: TIntegerField;
    IntegerField3: TIntegerField;
    IntegerField4: TIntegerField;
    StringField1: TStringField;
    StringField2: TStringField;
    cdsCamposUsuario: TClientDataSet;
    IntegerField5: TIntegerField;
    IntegerField6: TIntegerField;
    IntegerField7: TIntegerField;
    StringField3: TStringField;
    StringField4: TStringField;
    StringField5: TStringField;
    StringField6: TStringField;
    procedure StringField4GetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    function AutenticaUsuario (sNome, sSenha: string): Boolean;
    procedure VerificaCampos (sCadastro: string);
    procedure VerificaFuncionalidades (sCadastro: string);

    function Criptografia (sTexto: string): string;
  end;

var
  DM: TDM;

implementation

{$R *.dfm}

{ TDM }

function TDM.AutenticaUsuario(sNome, sSenha: string): Boolean;
begin
  cdsUsuario.Close;
  cdsUsuario.Params[0].AsString := UpperCase(sNome);
  cdsUsuario.Params[1].AsString := UpperCase(Criptografia(sSenha));
  cdsUsuario.Open;
  Result := (cdsUsuario.RecordCount > 0);
end;

function TDM.Criptografia(sTexto: string): string;
var
  i: byte;
  Key: Word;
  C1, C2: integer;
begin
  C1 := 52845;
  C2 := 22719;
  Key := 1085;
  {: criptografando senhas }
  SetLength(Result, length(sTexto));
  for i := 1 to Length(sTexto) do
  begin
    Result[I] := char(byte(sTexto[I]) xor (Key shr 8));
    Key := (byte(Result[I]) + Key) * C1 + C2;
  end;
end;

procedure TDM.StringField4GetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
   if Sender.AsString = 'T' then
     Text := 'Sim'
   else if Sender.AsString = 'F' then
     Text := 'No';   
end;

procedure TDM.VerificaCampos(sCadastro: string);
begin
  cdsCampos.Close;
  cdsCampos.Params[0].AsString := sCadastro;
  cdsCampos.Params[1].AsInteger := cdsUsuarioID.AsInteger;
  cdsCampos.Open;
end;

procedure TDM.VerificaFuncionalidades(sCadastro: string);
begin
  cdsFuncionalidades.Close;
  cdsFuncionalidades.Params[0].AsInteger := cdsUsuarioID.AsInteger;
  cdsFuncionalidades.Params[1].AsString := sCadastro;
  cdsFuncionalidades.Open;
end;

end.
