unit uFrmMainClient;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, WideStrings, DbxDatasnap, DB, SqlExpr, StdCtrls, ExtCtrls, FMTBcd;

type
  TFrmMainClient = class(TForm)
    SQLConDS: TSQLConnection;
    lbledtValorX: TLabeledEdit;
    lbledtValorY: TLabeledEdit;
    lbledtResultado: TLabeledEdit;
    btnSomarMethod: TButton;
    btnSomarClasses: TButton;
    ssmClient: TSqlServerMethod;
    procedure btnSomarMethodClick(Sender: TObject);
    procedure btnSomarClassesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmMainClient: TFrmMainClient;

implementation

uses uClientClasses;

{$R *.dfm}

procedure TFrmMainClient.btnSomarClassesClick(Sender: TObject);
var
  iValorX: Integer;
  IValorY: Integer;
  iResultado: Integer;
  SrvDS: TDSServerModuleMainClient;
begin
  SrvDS := TDSServerModuleMainClient.Create(SQLConDS.DBXConnection);

  try
    iValorX := StrToIntDef(lbledtValorX.Text, 0);
    iValorY := StrToIntDef(lbledtValorY.Text, 0);

    iResultado := SrvDS.Add(iValorX, IValorY);

    lbledtResultado.Text := IntToStr(iResultado);
  finally
    FreeAndNil(SrvDS);
  end;
end;

procedure TFrmMainClient.btnSomarMethodClick(Sender: TObject);
begin
  with ssmClient do
  begin
    ParamByName('x').AsInteger :=
                StrToIntDef(lbledtValorX.Text, 0);
    ParamByName('y').AsInteger :=
                StrToIntDef(lbledtValorY.Text, 0);

    ExecuteMethod;

    lbledtResultado.Text :=
                ParamByName('ReturnParameter').AsString;
  end;
end;

end.
