unit Dbx4SQLite3;

interface

uses SysUtils, DBXCommon, ClassRegistry, SQLite3;

type

  TDbx4SQLite3DriverLoader = class(TDBXDriverLoader)
  public
    function Load(DriverDef: TDBXDriverDef): TDBXDriver; override;
  end;

  TDbx4SQLite3Driver = class(TDBXDriver)
  protected
    function CreateConnection(ConnectionBuilder: TDBXConnectionBuilder): TDBXConnection; override;
    procedure Close; override;
  public
    function GetDriverVersion: WideString; override;
  end;

  TDbx4SQLite3Connection = class(TDBXConnection)
  private
    FDB: TSQLiteDB;
  protected
    procedure DerivedOpen(); override;
    procedure Close; override;
    function  DerivedCreateCommand: TDBXCommand; override;
  public
    procedure TrataErro(Erro: Integer);
  end;

  TDbx4SQLite3Command = class(TDBXCommand)
  protected
    procedure DerivedOpen; override;
    function  DerivedExecuteQuery: TDBXReader; override;  
  end;

implementation

{ TDbx4SQLite3DriverLoader }

function TDbx4SQLite3DriverLoader.Load(DriverDef: TDBXDriverDef): TDBXDriver;
begin
  if DriverDef.FDriverName = 'Dbx4SQLite3' then
    Result := TDbx4SQLite3Driver.Create
  else
    Result := nil;
end;

{ TDbx4SQLite3Driver }

procedure TDbx4SQLite3Driver.Close;
begin
  inherited;
end;

function TDbx4SQLite3Driver.CreateConnection(
  ConnectionBuilder: TDBXConnectionBuilder): TDBXConnection;
begin
  Result := TDbx4SQLite3Connection.Create(ConnectionBuilder);
end;

function TDbx4SQLite3Driver.GetDriverVersion: WideString;
begin
  Result := DBXVersion40;
end;

{ TDbx4SQLite3Connection }

procedure TDbx4SQLite3Connection.Close;
begin
  TrataErro(SQLite3_Close(FDB));
  inherited;
end;

function TDbx4SQLite3Connection.DerivedCreateCommand: TDBXCommand;
begin
  Result := TDbx4SQLite3Command.Create(FDBXContext);
end;

procedure TDbx4SQLite3Connection.DerivedOpen;
var
  Database: String;
begin
  inherited;
  FDB := nil;
  Database := FConnectionProperties.Values[TDBXPropertyNames.Database];
  if SQLite3_Open(PAnsiChar(Database), FDB) <> SQLITE_OK then
    raise Exception.Create('Erro ao conectar ao banco de dados.');
end;

procedure TDbx4SQLite3Connection.TrataErro(Erro: Integer);
begin
  if not Erro in [SQLITE_DONE, SQLITE_OK] then
    raise Exception.Create(SQLite3_ErrMsg(FDB));
end;

{ TDbx4SQLite3Command }

function TDbx4SQLite3Command.DerivedExecuteQuery: TDBXReader;
begin

end;

procedure TDbx4SQLite3Command.DerivedOpen;
begin
  inherited;

end;

initialization
  TClassRegistry.GetClassRegistry.RegisterClass(TDbx4SQLite3DriverLoader.ClassName, TDbx4SQLite3DriverLoader);

finalization
  TClassRegistry.GetClassRegistry.UnregisterClass(TDbx4SQLite3DriverLoader.ClassName);

end.
