unit ADFocus;

{-------------------------------------------------------------------------
 Componente exemplo do artigo publicado na revista Active Delphi - 2008.
 Desenvolvido em: Delphi 7
 Autor:    Leandro Neiva Lopes Figueiredo - softmaxbr@hotmail.com
--------------------------------------------------------------------------}

interface

uses
  Messages, WinProcs, Classes, Forms, StdCtrls, DBCtrls;

type
  TADFocus = class(TComponent)
  private
    { Private declarations }
    FAtivo : Boolean;
    FTagExcluida : Integer;
    FListaClasses : TStringList;
    FOnMessageAntiga  : TMessageEvent;
    procedure SetListaClasses(const Value: TStringList);
    function ClasseNaLista(pClasse : String; pTag : Integer) : Boolean;
  protected
    { Protected declarations }
    procedure MinhaOnMessage(var Msg: TMsg; var Handled: Boolean);
  public
    { Public declarations }
    constructor Create(AOwner:TComponent); override;
    destructor  Destroy; override;
  published
    { Published declarations }
    property Ativo : Boolean read FAtivo write FAtivo;
    property TagExcluida : Integer read FTagExcluida Write FTagExcluida;
    property ClassesSuportadas: TStringList   read FListaClasses       write SetListaClasses;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ADControls', [TADFocus]);
end;

{ TADFocus }

constructor TADFocus.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAtivo             := True;
  FTagExcluida       := 999; 

  FListaClasses := TStringList.create;
  with FListaClasses do
  begin
    Add('TEdit');
    Add('TCheckBox');
    Add('TComboBox');
    Add('TDBEdit');
    Add('TDBCheckBox');
    Add('TDBComboBox');
    Add('TDBListBox');
    Add('TDBLookupComboBox');
    Add('TDBLookupListBox');
    Add('TGroupButton');  //<- RadioGroup
    AdD('TLabeledEdit');
    AdD('TListBox');
    Add('TMaskEdit');
    Add('TRadioButton');
  end; //with

  if not( csDesigning in ComponentState ) then
  begin
    FOnMessageAntiga      := Application.OnMessage;
    Application.OnMessage := MinhaOnMessage;
  end;

end;

destructor TADFocus.Destroy;
begin
  FListaClasses.Free;
  if Assigned( FOnMessageAntiga ) then
    Application.OnMessage := FOnMessageAntiga;
  inherited;
end;

function TADFocus.ClasseNaLista(pClasse: String;
         pTag : Integer): Boolean;
begin

  Result := False;

  if (pTag = FTagExcluida) then
     Result := False
  else
     Result := (FListaClasses.IndexOf(pClasse) >= 0);

end;

procedure TADFocus.SetListaClasses(const Value: TStringList);
begin
  FListaClasses.Assign (Value);
end;

procedure TADFocus.MinhaOnMessage(var Msg: TMsg; var Handled: Boolean);
begin
  if Screen <> nil then
   begin
    if Screen.ActiveControl <> nil then
     begin
        if (Msg.message = WM_KeyDown )and
            ClasseNaLista(Screen.ActiveControl.ClassName,
            Screen.ActiveControl.Tag) then
         begin
           if FAtivo then
            begin
              case Msg.wParam of
                  VK_Return:
                    begin
                      //Executa o evento keydown do objeto
                      //antes de executar os outros cdigos abaixo
                      Screen.ActiveControl.Perform(Msg.message,
                             Msg.wParam, Msg.lParam);

                      if ( Screen.ActiveControl is
                           TCustomComboBox ) then
                      begin
                        if not(Screen.ActiveControl as
                           TCustomComboBox ).DroppedDown then
                           Msg.wParam := VK_TAB;
                      end
                      else if (Screen.ActiveControl is
                           TDBLookupCombobox) then
                      begin
                        if not(Screen.ActiveControl as
                           TDBLookupCombobox).ListVisible then
                           Msg.wParam := VK_TAB;
                      end
                      else
                         Msg.wParam := VK_TAB;
                    end;
                  VK_Down  :  if not (( Screen.ActiveControl is
                                 TCustomComboBox ) or
                                 (Screen.ActiveControl is
                                 TDBLookupControl) or
                                 (Screen.ActiveControl is
                                 TCustomListBox) or
                                 (Screen.ActiveControl is
                                 TRadioButton)) then
                         Msg.wParam := VK_TAB;
                  VK_Up    :  if not ((Screen.ActiveControl is
                                 TCustomComboBox ) or
                                 (Screen.ActiveControl is
                                 TDBLookupControl) or
                                 (Screen.ActiveControl is
                                 TCustomListBox ) or
                                 (Screen.ActiveControl is
                                 TRadioButton)) then
                  Screen.ActiveForm.Perform(WM_NEXTDLGCTL, 1, 0);
              end;
            end;
         end;
     end;
   end;

  if Assigned( FOnMessageAntiga ) then
     FOnMessageAntiga( Msg, Handled );

end;
end.

