unit uPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons, Mask;

type
  TFmPrincipal = class(TForm)
    Panel1: TPanel;
    lv: TListView;
    btnIncluir: TButton;
    btnExcluir: TButton;
    btnCarregar: TButton;
    btnSalvar: TButton;
    btnCalcular: TButton;
    pnlIncluir: TPanel;
    pnlCalcular: TPanel;
    grpbxCalcular: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edtPartida: TMaskEdit;
    edtDestino: TMaskEdit;
    edtCaminho: TMaskEdit;
    btnCalcula: TBitBtn;
    grpbxIncluir: TGroupBox;
    Label4: TLabel;
    edtDe: TMaskEdit;
    edtPara: TMaskEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtPeso: TMaskEdit;
    btnOk: TBitBtn;
    odlg: TOpenDialog;
    dslg: TSaveDialog;
    btnNovo: TBitBtn;
    procedure btnIncluirClick(Sender: TObject);
    procedure btnCarregarClick(Sender: TObject);
    procedure btnExcluirClick(Sender: TObject);
    procedure btnCalculaClick(Sender: TObject);
    procedure btnCalcularClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnNovoClick(Sender: TObject);
  private
    { Private declarations }
    function ParseLine(prstLinha: String; var prstVertice: String;
      var prstAdjacente: String; var prValor: Real): boolean;

    function Str2Float(prst: String): Real;  

    procedure CarregarArquivo(prstArquivo: String);
    procedure SalvarArquivo(prstArquivo: String);
  public
    { Public declarations }
  end;

var
  FmPrincipal: TFmPrincipal;

implementation

uses uDijkstra, uGrafo;

{$R *.dfm}

procedure TFmPrincipal.btnIncluirClick(Sender: TObject);
begin
  pnlIncluir.Visible := true;
  pnlCalcular.Visible := false;
  edtDe.SetFocus;
end;

procedure TFmPrincipal.btnCarregarClick(Sender: TObject);
begin
  if odlg.Execute then
    CarregarArquivo(odlg.FileName);
end;

procedure TFmPrincipal.CarregarArquivo(prstArquivo: String);
var
  lArq: TStringList;
  li: TListItem;
  i: integer;
  lstLinha: String;
  lstVertice: String;
  lstAdjacente: String;
  lreValor: Real;
begin
  lv.Items.Clear;
  lArq := TStringList.Create;
  try
    lArq.LoadFromFile(prstArquivo);

    for i := 0 to Pred(lArq.Count) do
    begin
      lstLinha := lArq[i];
      if ParseLine(lstLinha, lstVertice, lstAdjacente, lreValor) then
      begin
        li := lv.Items.Add;
        li.Caption := lstVertice;
        li.SubItems.Add(lstAdjacente);
        li.SubItems.Add(FormatFloat('#####0.000', lreValor));
      end;

      pnlIncluir.Visible := false;
      pnlCalcular.Visible := false;
    end;
  finally
    lArq.Free;
  end;
end;

function TFmPrincipal.ParseLine(prstLinha: String; var prstVertice,
  prstAdjacente: String; var prValor: Real): boolean;
var
  lob: TStringList;
begin
  lob := TStringList.Create;
  try
    lob.Delimiter := ';';
    lob.DelimitedText := prstLinha;

    Result := false;

    if lob.Count <> 3 then
      Exit;

    prstVertice := lob[0];
    prstAdjacente := lob[1];
    prValor := Str2Float(lob[2]);
    Result := true;

  finally
    lob.Free;
  end;
end;

procedure TFmPrincipal.btnExcluirClick(Sender: TObject);
begin
  if lv.ItemIndex = -1 then
  begin
    MessageDlg('Selecionar um elemento da lista para excluir', mtError, [mbOK], 0);
    Exit;
  end;

  lv.DeleteSelected;
end;

procedure TFmPrincipal.btnCalculaClick(Sender: TObject);
var
  lGrafo: TGrafo;
  lDijkstra: TDijkstra;
  lItem: TListItem;
  i: integer;
begin
  lGrafo := TGrafo.Create;

  for i := 0 to Pred(lv.Items.Count) do
  begin
    lItem := lv.Items[i];

    lGrafo.CriarAresta(lItem.Caption, lItem.SubItems[0],
      Str2Float(lItem.SubItems[1]));
  end;

  lDijkstra := TDijkstra.Create;

  try
    lDijkstra.ComputarCaminho(lGrafo, edtPartida.Text);
    edtCaminho.Text := lDijkstra.ObterMenorCaminhoAte(lGrafo, edtDestino.Text);
  finally
    lDijkstra.Free;
    lGrafo.Free;
  end;

end;

procedure TFmPrincipal.btnCalcularClick(Sender: TObject);
begin
  pnlIncluir.Visible := false;
  pnlCalcular.Visible := true;
  edtPartida.Text := '';
  edtDestino.Text := '';
  edtCaminho.Text := '';

  edtPartida.SetFocus;
end;

procedure TFmPrincipal.btnOkClick(Sender: TObject);
var
  lItem: TListItem;
  lrePeso: Real;
begin
  if (SysUtils.Trim(edtDe.Text) = '') or (SysUtils.Trim(edtPara.Text) = '') then
  begin
    MessageDlg('Vrtice no informado', mtWarning, [mbOK], 0);
    Exit;
  end;

  lrePeso := Str2Float(edtPeso.Text);

  if lrePeso <= 0 then
  begin
    MessageDlg('Peso deve ser maior ou igual a zero', mtError, [mbOK], 0);
    Exit;
  end;


  lItem := lv.Items.Add;
  lItem.Caption := edtDe.Text;
  lItem.SubItems.Add(edtPara.Text);
  lItem.SubItems.Add(FormatFloat('####0.000', lrePeso));

  edtDe.Text := '';
  edtPara.Text := '';
  edtPeso.Text := '';
  edtDe.SetFocus;
end;

function TFmPrincipal.Str2Float(prst: String): Real;
var
  code: integer;
begin
  if Pos(',', prst) > 0 then
    prst := StringReplace(prst, ',', '.', []);

  Val(prst, Result, code);
end;

procedure TFmPrincipal.btnSalvarClick(Sender: TObject);
var
  lstFileName: String;
begin
  if not dslg.Execute then
    Exit;

  lstFileName := dslg.FileName;
  SalvarArquivo(lstFileName);
end;

procedure TFmPrincipal.SalvarArquivo(prstArquivo: String);
var
  lArq: TStringList;
  li: TListItem;
  lstLinha: String;
  i: integer;
begin
  lArq := TStringList.Create;

  try
    for i := 0 to Pred(lv.Items.Count) do
    begin
      li := lv.Items[i];
      lstLinha := li.Caption + ';' + li.SubItems[0] + ';' + li.SubItems[1];
      lArq.Add(lstLinha);
    end;

    lArq.SaveToFile(prstArquivo);
  finally
    lArq.Free;
  end;
end;

procedure TFmPrincipal.btnNovoClick(Sender: TObject);
begin
  if MessageDlg('Descartar grafo atual?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    lv.Items.Clear;
    pnlIncluir.Visible := false;
    pnlCalcular.Visible := false;
  end;
end;

end.
