unit uDijkstra;

interface

uses
  uGrafo;

type
  TDijkstra = class
  private
    procedure InicializarDistanciaMinima(prVertice: TVertice);
  public
    procedure ComputarCaminho(prGrafo: TGrafo; prIDVerticeOrigem: String);
    function ObterMenorCaminhoAte(prGrafo: TGrafo; prIDVerticeDestino: String): String; virtual;
  end;

implementation

uses Classes, uPQueue, SysUtils, Dialogs, Math, Contnrs;

function SortFunc(prVa, prVb: pointer): integer;
begin
  if TVertice(prVa).MinDistancia > TVertice(prVB).MinDistancia then
    Result := 1
  else
  if TVertice(prVa).MinDistancia < TVertice(prVB).MinDistancia then
    Result := -1
  else
    Result := 0;
end;

{ TDijkstra }

procedure TDijkstra.ComputarCaminho(prGrafo: TGrafo; prIDVerticeOrigem: String);
var
  pq: TPQueue;    { fila de prioridades }
  s: TVertice;    { vertice de partida }
  u: TVertice;    { vertices destino }
  z: TVertice;    { vertices adjacentes a u }
  aresta: TAresta;
  i: integer;     { iterar todos os vertices adjacentes a u }
  w: real;        { peso da aresta }
  distanciaDeU: real;
begin
  prGrafo.Iterator(InicializarDistanciaMinima);
  s := prGrafo.ObterVertice(prIDVerticeOrigem);

  if s = nil then
    raise Exception.Create('Vertice origem no encontrado no grafo');

  s.MinDistancia := 0;

  pq := TPQueue.Create(SortFunc);
  pq.Push(s);

  while not pq.IsEmpty do
  begin
    u := TVertice(pq.Pop);

    for i := 0 to Pred(u.ObterArestas.Count) do
    begin
      aresta := TAresta(u.ObterArestas[i]);
      z := aresta.Destino;
      w := aresta.Peso;
      distanciaDeU := u.MinDistancia + w;

      if distanciaDeU < z.MinDistancia then
      begin
        pq.Remove(z);
        z.MinDistancia := distanciaDeU;
        z.Track := u;
        pq.Push(z);
      end;

    end; { for }

  end;
end;

procedure TDijkstra.InicializarDistanciaMinima(prVertice: TVertice);
begin
  prVertice.Track := nil;
  prVertice.MinDistancia := Infinity;
end;

function TDijkstra.ObterMenorCaminhoAte(prGrafo: TGrafo;
  prIDVerticeDestino: String): String;
var
  u: TVertice;
  lStack: TStack;
begin
  lStack := TStack.Create;
  u := prGrafo.ObterVertice(prIDVerticeDestino);

  while u <> nil do
  begin
    lStack.Push(u);
    u := u.Track;
  end;

  Result := '';

  while lStack.Count > 0 do
  begin
    u := TVertice(lStack.Pop);

    if Result <> '' then
      Result := Result + ' -> ';

    Result := Result + u.ID + '(' + FormatFloat('#,##0.0000', u.MinDistancia) + ')';
  end;

  lStack.Free;
end;

end.
