unit uGrafo;

interface

uses
  Classes;

type
  TVertice = class
  private
    FID: String;
    FLstArestas: TList;
    FMinDist: double;
    FTrack: TVertice;
  public
    constructor Create(prID: String);
    destructor Destroy; override;
    function CriarAresta(prVertice: TVertice; prPeso: real): TVertice;
    function ObterArestas: TList;
    property MinDistancia: double read FMinDist write FMinDist;
    property ID: String read FID write FID;
    property Track: TVertice read FTrack write FTrack;
  end;

  TAresta = class
  private
    FDestino: TVertice;
    FPeso: real;
  public
    constructor Create(prVertice: TVertice; prPeso: real);

    property Destino: TVertice read FDestino;
    property Peso: Real read FPeso;
  end;

  TProcIterator = procedure(prVertice: TVertice) of object;

  TGrafo = class
  private
    FLstVertice: TStringList;
  public
    constructor Create;
    destructor Destroy; override;
    function CriarVertice(prID: String): TVertice;
    function ObterVertice(prID: String): TVertice;
    procedure CriarAresta(prIDVerticeDe, prIDVerticePara: String; prPeso: real);
    procedure Iterator(prFuncIterator: TProcIterator);
  end;

implementation

uses Math, SysUtils;

{ TVertice }

constructor TVertice.Create(prID: String);
begin
  if SysUtils.Trim(prID) = '' then
    raise Exception.Create('Vrtice precisa ter uma identificao');

  inherited Create;
  FID := prID;
  FMinDist := Infinity;

  FLstArestas := TList.Create;
end;

function TVertice.CriarAresta(prVertice: TVertice;
  prPeso: real): TVertice;
begin
  FLstArestas.Add(TAresta.Create(prVertice, prPeso));

  Result := Self;
end;

destructor TVertice.Destroy;
var
  i: integer;
begin
  for i := 0 to Pred(FLstArestas.Count) do
    TObject(FLstArestas[i]).Free;

  FLstArestas.Free;  

  inherited;
end;

function TVertice.ObterArestas: TList;
begin
  Result := FLstArestas;
end;

{ TAresta }

constructor TAresta.Create(prVertice: TVertice; prPeso: real);
begin
  if prPeso < 0 then
    raise Exception.Create('Aresta no pode ter peso negativo');

  inherited Create;

  FDestino := prVertice;
  FPeso := prPeso;
end;

{ TGrafo }

constructor TGrafo.Create;
begin
  inherited;
  FLstVertice := TStringList.Create;
  FLstVertice.Sorted := true;
end;

procedure TGrafo.CriarAresta(prIDVerticeDe,
  prIDVerticePara: String; prPeso: real);
var
  vd, vp: TVertice;
begin
  vd := CriarVertice(prIDVerticeDe);
  vp := CriarVertice(prIDVerticePara);

  vd.CriarAresta(vp, prPeso);
end;

function TGrafo.CriarVertice(prID: String): TVertice;
begin
  Result := ObterVertice(prID);

  if Result = nil then
  begin
    Result := TVertice.Create(prID);
    FLstVertice.AddObject(prID, Result);
  end;
end;


destructor TGrafo.Destroy;
var
  i: integer;
begin
  for i := 0 to Pred(FLstVertice.Count) do
    FLstVertice.Objects[i].Free;

  FLstVertice.Free;
  inherited;
end;

procedure TGrafo.Iterator(prFuncIterator: TProcIterator);
var
  i: integer;
begin
  if @prFuncIterator = nil then
    Exit;

  for i := 0 to Pred(FLstVertice.Count) do
    prFuncIterator(TVertice(FLstVertice.Objects[i]));
end;

function TGrafo.ObterVertice(prID: String): TVertice;
var
  i: integer;
begin
  Result := nil;
  i := FLstVertice.IndexOf(prID);

  if i = -1 then
    Exit;

  Result := TVertice(FLstVertice.Objects[i]);
end;

end.
