unit uPQueue;

interface

uses
  Classes;

type
  TPQueue = class
  private
    FLst: TList;
    FFuncCompare: TListSortCompare;
    procedure Ordenar;
  public
    constructor Create(prfunc: TListSortCompare);
    function Pop: pointer;
    procedure Remove(p: pointer);
    function IsEmpty: boolean;
    procedure Push(prob: pointer);
  end;

implementation

uses
  SysUtils;

{ TPQueue }

constructor TPQueue.Create(prfunc: TListSortCompare);
begin
  if @prFunc = nil then
    raise Exception.Create('Falha na criao. prfunc deve conter uma funo ' +
      'para comparar');

  inherited Create;

  FFuncCompare := prfunc;
  FLst := TList.Create;
end;

function TPQueue.IsEmpty: boolean;
begin
  Result := FLst.Count = 0;
end;

procedure TPQueue.Ordenar;
begin
  FLst.Sort(FFuncCompare);
end;

function TPQueue.Pop: pointer;
var
  p: pointer;
begin
  Result := nil;

  if FLst.Count = 0 then
    Exit;

  Ordenar;

  p := FLst[0];
  Result := p;
  Remove(p);
end;

procedure TPQueue.Push(prob: pointer);
begin
  FLst.Add(prob);
end;

procedure TPQueue.Remove(p: pointer);
begin
  FLst.Remove(p);
end;

end.
