// 
// Created by the DataSnap proxy generator.
// 

unit uClientClasses;

interface

uses DBXCommon, Classes, SysUtils, DB, SqlExpr, DBXDBReaders;

type
  TDSServerModuleMainClient = class
  private
    FDBXConnection: TDBXConnection;
    FInstanceOwner: Boolean;
    FAddCommand: TDBXCommand;
  public
    constructor Create(ADBXConnection: TDBXConnection); overload;
    constructor Create(ADBXConnection: TDBXConnection; AInstanceOwner: Boolean); overload;
    destructor Destroy; override;
    function Add(x: Integer; y: Integer): Integer;
  end;

implementation

function TDSServerModuleMainClient.Add(x: Integer; y: Integer): Integer;
begin
  if FAddCommand = nil then
  begin
    FAddCommand := FDBXConnection.CreateCommand;
    FAddCommand.CommandType := TDBXCommandTypes.DSServerMethod;
    FAddCommand.Text := 'TDSServerModuleMain.Add';
    FAddCommand.Prepare;
  end;
  FAddCommand.Parameters[0].Value.SetInt32(x);
  FAddCommand.Parameters[1].Value.SetInt32(y);
  FAddCommand.ExecuteUpdate;
  Result := FAddCommand.Parameters[2].Value.GetInt32;
end;


constructor TDSServerModuleMainClient.Create(ADBXConnection: TDBXConnection);
begin
  inherited Create;
  if ADBXConnection = nil then
    raise EInvalidOperation.Create('Connection cannot be nil.  Make sure the connection has been opened.');
  FDBXConnection := ADBXConnection;
FInstanceOwner := True;
end;


constructor TDSServerModuleMainClient.Create(ADBXConnection: TDBXConnection; AInstanceOwner: Boolean);
begin
  inherited Create;
  if ADBXConnection = nil then
    raise EInvalidOperation.Create('Connection cannot be nil.  Make sure the connection has been opened.');
  FDBXConnection := ADBXConnection;
FInstanceOwner := AInstanceOwner;
end;


destructor TDSServerModuleMainClient.Destroy;
begin
  FreeAndNil(FAddCommand);
  inherited;
end;

end.
