unit uPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Mask, ExtCtrls, PerlRegex;

type
  TFmPrincipal = class(TForm)
    painel: TPanel;
    Label1: TLabel;
    edtRegex: TMaskEdit;
    grpbxAlvo: TGroupBox;
    mAlvo: TMemo;
    btnProcurar: TBitBtn;
    btnProximo: TBitBtn;
    grpbxBackReference: TGroupBox;
    mBR: TMemo;
    ckbxCaseless: TCheckBox;
    btnFechar: TBitBtn;
    spbtnZoom: TSpeedButton;
    btnAddBiblioteca: TBitBtn;
    procedure btnProcurarClick(Sender: TObject);
    procedure btnProximoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFecharClick(Sender: TObject);
    procedure btnAddBibliotecaClick(Sender: TObject);
    procedure spbtnZoomClick(Sender: TObject);
    procedure edtRegexChange(Sender: TObject);
    procedure mAlvoChange(Sender: TObject);
  private
    { Private declarations }
    FRegex: TPerlRegEx;
    procedure Procurar;
    procedure ProcurarProximo;
    procedure Destacar;
    procedure ObterBackReference;
    procedure AdicionarNaBiblioteca;
  public
    { Public declarations }
  end;

var
  FmPrincipal: TFmPrincipal;

implementation

uses uConst, uSelRegex;

{$R *.dfm}


procedure TFmPrincipal.btnProcurarClick(Sender: TObject);
begin
  Procurar;
end;

procedure TFmPrincipal.Procurar;
begin
  if FRegex = nil then
    FRegex := TPerlRegEx.Create(nil);

  if ckbxCaseless.Checked then
    FRegex.Options := FRegex.Options + [preCaseLess]
  else
    FRegex.Options := FRegex.Options - [preCaseLess];

  FRegex.RegEx := edtRegex.Text;
  FRegex.Subject := mAlvo.Text;
  mBR.Lines.Clear;

  if FRegex.Match then
  begin
    Destacar;
    ObterBackReference;
    btnProximo.Enabled := true;
  end
  else
    MessageDlg('No h ocorrncia.', mtInformation, [mbOK], 0);
end;

procedure TFmPrincipal.btnProximoClick(Sender: TObject);
begin
  ProcurarProximo;
end;

procedure TFmPrincipal.ProcurarProximo;
begin
  if FRegex.MatchAgain then
  begin
    Destacar;
    ObterBackReference;
  end
  else
    MessageDlg('No h mais ocorrncias.', mtInformation, [mbOK], 0);
end;

procedure TFmPrincipal.ObterBackReference;
var
  i: integer;
begin
  mBR.Lines.Clear;

  for i := 1 to FRegex.SubExpressionCount do
    mBR.Lines.Add(IntToStr(i) + ' = ' + FRegex.SubExpressions[i]);
end;

procedure TFmPrincipal.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  FRegex.Free;
end;

procedure TFmPrincipal.btnFecharClick(Sender: TObject);
begin
  Close;
end;

procedure TFmPrincipal.Destacar;
begin
  mAlvo.SetFocus;
  mAlvo.SelStart := FRegex.MatchedExpressionOffset - 1;
  mAlvo.SelLength := FRegex.MatchedExpressionLength;
end;

procedure TFmPrincipal.btnAddBibliotecaClick(Sender: TObject);
begin
  AdicionarNaBiblioteca;
end;

procedure TFmPrincipal.AdicionarNaBiblioteca;
var
  lob: TStringList;
  lstDescricao: String;
  lstRegex: String;
begin
  lstRegex := edtRegex.Text;

  if lstRegex = '' then
  begin
    MessageDlg('Regex no informada', mtError, [mbOk], 0);
    Exit;
  end;

  lstDescricao := '';

  if not InputQuery('Descriao', 'Digite uma descrio para essa regex', lstDescricao) then
    Exit;

  if Trim(lstDescricao) = '' then
  begin
    MessageDlg('Favor digitar uma descrio para a regex', mtInformation, [mbOK], 0);
    Exit;
  end;

  lob := TStringList.Create;

  try
    if FileExists(NOME_BIBLIOTECA) then
      lob.LoadFromFile(NOME_BIBLIOTECA);

    lob.Add(lstDescricao);
    lob.Add(lstRegex);
    lob.SaveToFile(NOME_BIBLIOTECA);
  finally
    lob.Free;
  end;
end;

procedure TFmPrincipal.spbtnZoomClick(Sender: TObject);
var
  lCLT: TFmSelRegex;
begin
  lCLT := TFmSelRegex.Create(nil);

  try
    if lCLT.Mostrar then
      edtRegex.Text := lCLT.ObterRegex;
  finally
    lCLT.Free;
  end;
end;

procedure TFmPrincipal.edtRegexChange(Sender: TObject);
begin
  btnProximo.Enabled := false;
end;

procedure TFmPrincipal.mAlvoChange(Sender: TObject);
begin
  btnProximo.Enabled := false;
end;

end.
