unit uSelRegex;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, Mask;

type
  TFmSelRegex = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    lstbxSelecao: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    edtRegex: TMaskEdit;
    Panel3: TPanel;
    btnCancelar: TBitBtn;
    btnOk: TBitBtn;
    spbtApagar: TSpeedButton;
    spbtnSave: TSpeedButton;
    procedure btnOkClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure lstbxSelecaoClick(Sender: TObject);
    procedure spbtApagarClick(Sender: TObject);
    procedure spbtnSaveClick(Sender: TObject);
  private
    { Private declarations }
    FRegexStr: String;
    procedure Apagar;
    procedure Gravar;
    procedure CarregarBiblioteca;
  public
    { Public declarations }
    function Mostrar: boolean;
    function ObterRegex: String;
  end;

var
  FmSelRegex: TFmSelRegex;

implementation

uses uConst;

{$R *.dfm}

const
  ERRO_SELECAO = 'Voce deve selecionar uma regex da lista.';

type
   { Em Delphi String no  um objeto :-(
     entao criamos uma classe Wrapper }
   TWrpStr = class
   private
     FValue: String;
   public
     constructor Create(prstValue: String);
     property Value: String read FValue;
   end;

{ TFmSelRegex }

function TFmSelRegex.Mostrar: boolean;
begin
  CarregarBiblioteca;
  
  spbtnSave.Enabled := false;
  btnOk.ModalResult := mrNone;
  Result := ShowModal = mrOk;
end;

function TFmSelRegex.ObterRegex: String;
begin
  Result := FRegexStr;
end;

procedure TFmSelRegex.btnOkClick(Sender: TObject);
var
  i: integer;
begin
  i := lstbxSelecao.ItemIndex;

  if i = -1 then
  begin
    MessageDlg(ERRO_SELECAO, mtError, [mbOK], 0);
    Exit;
  end;

  FRegexStr :=
    TWrpStr(lstbxSelecao.Items.Objects[i]).Value;

  ModalResult := mrOk;
end;

procedure TFmSelRegex.CarregarBiblioteca;
var
  i: integer;
  lLibrary: TStringList;
  lbolDescr: boolean;
  lstDescricao: String;
begin
  lbolDescr := true;
  lLibrary := TStringList.Create;

  try
    lLibrary.LoadFromFile(NOME_BIBLIOTECA);
    
    for i := 0 to Pred(lLibrary.Count) do
    begin
      if lbolDescr then
        lstDescricao := lLibrary[i]
      else
        lstbxSelecao.Items.AddObject(lstDescricao, TWrpStr.Create(lLibrary[i]));

      lbolDescr := not lbolDescr;
    end;
  finally
    lLibrary.Free;
  end;

end;

procedure TFmSelRegex.Apagar;
var
  i: integer;
begin
  i := lstbxSelecao.ItemIndex;

  if i = -1 then
  begin
    MessageDlg(ERRO_SELECAO, mtError, [mbOK], 0);
    Exit;
  end;

  TObject(lstbxSelecao.Items.Objects[i]).Free;
  lstbxSelecao.Items.Delete(i);
  edtRegex.Text := '';
  spbtnSave.Enabled := true;
end;


procedure TFmSelRegex.Gravar;
var
  lob: TStringList;
  i: integer;
begin
  lob := TStringList.Create;

  try
    for i := 0 to Pred(lstbxSelecao.Items.Count) do
    begin
      lob.Add(lstbxSelecao.Items[i]);
      lob.Add(TWrpStr(lstbxSelecao.Items.Objects[i]).Value);
    end;

    lob.SaveToFile(NOME_BIBLIOTECA);
  finally
    lob.Free;
  end;
end;

{ TWrpStr }

constructor TWrpStr.Create(prstValue: String);
begin
  inherited Create;
  FValue := prstValue;
end;

procedure TFmSelRegex.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i: integer;
begin
  for i := 0 to Pred(lstbxSelecao.Items.Count) do
    TObject(lstbxSelecao.Items.Objects[i]).Free;
end;

procedure TFmSelRegex.lstbxSelecaoClick(Sender: TObject);
begin
  edtRegex.Text :=
    TWrpStr(lstbxSelecao.Items.Objects[lstbxSelecao.ItemIndex]).Value;
end;

procedure TFmSelRegex.spbtApagarClick(Sender: TObject);
begin
  Apagar;
end;

procedure TFmSelRegex.spbtnSaveClick(Sender: TObject);
begin
  Gravar;
end;
end.
