unit uLib;

interface

uses
  SysUtils, Classes, Messages, Windows, Variants, Graphics, Forms, Dialogs,
  Menus, ExtCtrls, ComCtrls, Buttons, ShellApi;

  procedure AbreForm(aClassForm: TComponentClass; aForm: TForm);
  //abre um formulrio
  procedure AbreFormCons(aClassForm: TComponentClass; aForm: TForm);
  //abre form de consulta (btVisible = True)
  procedure Alerta(Mens : String);
  //chama funo Mensagem para Alerta
  procedure Erro(Mens : String);
  //chama funo Mensagem para Erro
  procedure Informacao(Mens : String);
  //chama funo Mensagem para Informacao


  function Mensagem(Mens, Titulo: String ; Tipo: byte ): byte;
  //Exibe mensagem genrica de acordo com o tipo
  function Confirma(Mens : String) : Boolean;
  //Chama a funo Mensagem de Confirmao/Pergunta
  function ConfirmaOuCancela(Mens : String) :Integer;
  //Chama funo de Mensagem para Confirmar ou Cancelar
  function Aviso(Mens : String): boolean;
  //chama funo Mensagem para Aviso
  function VerificaCEP(UF, CEPDigitado: string): Boolean;
  //verifica se o CEP  vlido para aquele estado
  function IIf(pCond:Boolean;pTrue,pFalse:Variant): Variant;
  //funcao usada na validao do CPFs/CNPJs
  function VerificaCpfCnpj(Numero : String) : Boolean;
  //valida CPF/CNPJ
  function SoNum(digitado: String): String;
  //pega um numero digitado e remove a mascara


implementation

const
  //const_linha = ' ';
  const_linha = '----------------------------------------------------------------';
  //constante usada na montagem das mensagens

//chama um formulrio
procedure AbreForm(aClassForm: TComponentClass; aForm: TForm);
begin
  Application.CreateForm(aClassForm,aForm);
  try
    aForm.ShowModal;
  finally
    aForm.Release;
  end;
end;

//chama um formulrio
procedure AbreFormCons(aClassForm: TComponentClass; aForm: TForm);
begin
  Application.CreateForm(aClassForm,aForm);
  try
    (aForm.FindComponent('btTransferir') as TBitBtn).Visible := True;
    aForm.ShowModal;
  finally
    aForm.Release;
  end;
end;


//chama funo Mensagem para Alerta
procedure Alerta(Mens : String);
begin
   Mensagem(PChar(const_linha + #13 + Mens + #13 + const_linha),'Ateno',5);
end;


//chama funo Mensagem para Erro
procedure Erro(Mens : String);
begin
   Mensagem(PChar(const_linha + #13 + Mens + #13 + const_linha),'Erro',2);
end;


//chama funo Mensagem para Informacao
procedure Informacao(Mens : String);
begin
   Mensagem(PChar(const_linha + #13 + Mens + #13 + const_linha),'Informao',3);
end;

(*Exibe Mensagem Genrica, de acordo com o Tipo:
  0 - Pergunta SIM/NO
  1 - Aviso SIM/NO
  2 - Erro OK
  3 - Informao OK
  4 - Pergunta SIM/NO/CANCELAR
  5 - Aviso OK
*)
function Mensagem(Mens, Titulo: String ; Tipo: byte ): byte;
var
   Botoes : Integer;
begin
   Botoes := mb_Ok;
   case Tipo of
      0 : Botoes :=  MB_YESNO + MB_ICONQUESTION;
      1 : Botoes :=  MB_YESNO + MB_ICONEXCLAMATION + MB_DEFBUTTON2;
      2 : Botoes :=  MB_OK + MB_ICONSTOP;
      3 : Botoes :=  MB_OK + MB_ICONINFORMATION;
      4 : Botoes :=  MB_YESNOCANCEL + MB_ICONQUESTION + MB_DEFBUTTON2;
      5 : Botoes :=  MB_OK + MB_ICONEXCLAMATION;
   end;

   Result := Application.MessageBox(PChar(Mens) , Pchar(Titulo) , Botoes);
end;

//Chama a funo Mensagem de Confirmao/Pergunta
function Confirma(Mens : String) : Boolean;
begin
   Result := Mensagem(PChar(const_linha + #13 + Mens + #13 + const_linha), 'Confirmao', 0) = IDYES;
end;

//Chama funo de Mensagem para Confirmar ou Cancelar
function ConfirmaOuCancela(Mens : String) :Integer;
begin
  Result := Mensagem(PChar(const_linha + #13 + Mens + #13 + const_linha), 'Confirmao', 4) ;
end;

//chama funo Mensagem para Aviso
function Aviso(Mens : String): boolean;
begin
   Result := Mensagem(PChar(const_linha + #13 + Mens + #13 + const_linha),'Confirmao',1) = IDYES;
end;

//Funo: verificar o CEP de acordo com o estado escolhido
//Retorna: True caso esteja correto, False caso incorreto
//Exemplo: VerificaCEP(CmbBoxEstado.Text, edtCEP.Text)
//Obs.: Deve-se utilizar os seguintes items para a combo:
(*
AC,AL,AM,AP,BA,CE,DF,ES,GO,MA,MG,MS,MT,PA,PB,PE,PI,PR,RJ,RN,RO,RR,RS,SC,SE,SP,TO
*)
function VerificaCEP(UF, CEPDigitado: String): Boolean;
var cep : integer; //guarda o cep sem mascara como inteiro
begin
  Result := True;

  cep := StrToInt(SoNum(CEPDigitado));
  //converte a variavel mascara para inteiro e a guarda na var. cep

 //verifica o cep digitado em relacao ao estado escolhido
 if UF='' then exit;
 if UF='SP' then if ((cep<1000000) or (cep>19999999)) then Result := False;
 if UF='RJ' then if ((cep<20000000) or (cep>28999999)) then Result := False;
 if UF='MS' then if ((cep<79000000) or (cep>79999999)) then Result := False;
 if UF='MG' then if ((cep<30000000) or (cep>39999999)) then Result := False;
 if UF='MT' then if ((cep<78000000) or (cep>78899999)) then Result := False;
 if UF='AC' then if ((cep<69900000) or (cep>69999999)) then Result := False;
 if UF='AL' then if ((cep<5700000) or (cep>57999999)) then Result := False;
 if UF='AM' then if ((cep<6900000) or (cep>69899999)) then Result := False;
 if UF='AP' then if ((cep<68900000) or (cep>69999999)) then Result := False;
 if UF='BA' then if ((cep<40000000) or (cep>48999999)) then Result := False;
 if UF='CE' then if ((cep<60000000) or (cep>63999999)) then Result := False;
 if UF='DF' then if ((cep<70000000) or (cep>73699999)) then Result := False;
 if UF='ES' then if ((cep<29000000) or (cep>29999999)) then Result := False;
 if UF='GO' then if ((cep<73700000) or (cep>76999999)) then Result := False;
 if UF='MA' then if ((cep<65000000) or (cep>65999999)) then Result := False;
 if UF='PA' then if ((cep<66000000) or (cep>68899999)) then Result := False;
 if UF='PB' then if ((cep<58000000) or (cep>58999999)) then Result := False;
 if UF='PE' then if ((cep<50000000) or (cep>56999999)) then Result := False;
 if UF='PI' then if ((cep<64000000) or (cep>64999999)) then Result := False;
 if UF='PR' then if ((cep<80000000) or (cep>87999999)) then Result := False;
 if UF='RN' then if ((cep<59000000) or (cep>59999999)) then Result := False;
 if UF='RO' then if ((cep<78900000) or (cep>78999999)) then Result := False;
 if UF='RR' then if ((cep<69300000) or (cep>69399999)) then Result := False;
 if UF='RS' then if ((cep<90000000) or (cep>99999999)) then Result := False;
 if UF='SC' then if ((cep<88000000) or (cep>89999999)) then Result := False;
 if UF='SE' then if ((cep<49000000) or (cep>49999999)) then Result := False;
 if UF='TO' then if ((cep<77000000) or (cep>77999999)) then Result := False;
end;


//Funo utilizada para implementar a funo de validao de CPF/CNPJ
function IIf(pCond:Boolean;pTrue,pFalse:Variant): Variant;
begin
  If pCond Then Result := pTrue
  else Result := pFalse;
end;

//Funo: Verificar se o CPF/CNPJ  Vlido
//Retorna: True para CPF/CNPJ vlido e False para invlido
//Exemplo: VerificaCpfCnpj(edtCPF.Text)
function VerificaCpfCnpj(Numero : String) : Boolean;
Var
i,d,b,
Digito : Byte;
Soma : Integer;
CNPJ : Boolean;
DgPass,
DgCalc : String;
begin
  Result := False;
  Numero := SoNum(Numero);
  // Caso o nmero no seja 11 (CPF) ou 14 (CNPJ), aborta
  Case Length(Numero) of
    11: CNPJ := False;
    14: CNPJ := True;
  else Exit;
  end;
  // Separa o nmero do digito
  DgCalc := '';
  DgPass := Copy(Numero,Length(Numero)-1,2);
  Numero := Copy(Numero,1,Length(Numero)-2);
  // Calcula o digito 1 e 2
  For d := 1 to 2 do begin
    B := IIF(D=1,2,3); // BYTE
    SOMA := IIF(D=1,0,STRTOINTDEF(DGCALC,0)*2);
    for i := Length(Numero) downto 1 do begin
      Soma := Soma + (Ord(Numero[I])-Ord('0'))*b;
      Inc(b);
      If (b > 9) And CNPJ Then
        b := 2;
    end;
   Digito := 11 - Soma mod 11;
   If Digito >= 10 then
     Digito := 0;
   DgCalc := DgCalc + Chr(Digito + Ord('0'));
  end;
  Result := DgCalc = DgPass;
end;

function SoNum(digitado: String): String;
var i:integer;
begin
 Result := '';
 for i:=1 To Length(digitado) do
  if digitado[I] In ['0'..'9'] then
     Result := Result + digitado[I];
end;

end.
