unit uConsEvento;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uFrmModeloCons, DBCtrls, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls;

type
  TfrmConsEvento = class(TfrmModeloCons)
    DBText1: TDBText;
    DBMemo1: TDBMemo;
    Label3: TLabel;
    procedure btAlterarClick(Sender: TObject);
    procedure btCadastrarClick(Sender: TObject);
    procedure btExcluirClick(Sender: TObject);
    procedure btPesquisaClick(Sender: TObject);
    procedure btTransferirClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConsEvento: TfrmConsEvento;

implementation

uses uDM, uLib, uCadEvento;

{$R *.dfm}

procedure TfrmConsEvento.btAlterarClick(Sender: TObject);
begin
  inherited;
  AbreForm(TfrmCadEvento, frmCadEvento);
end;

procedure TfrmConsEvento.btCadastrarClick(Sender: TObject);
begin
  inherited;
  with dm do Inserir(cdsEvento);
  AbreForm(TfrmCadEvento, frmCadEvento);
end;

procedure TfrmConsEvento.btExcluirClick(Sender: TObject);
begin
  inherited;
  with dm do Excluir(cdsEvento, 'NOME');
end;

procedure TfrmConsEvento.btPesquisaClick(Sender: TObject);
begin
  with dm.cdsEvento do
  begin
    Close;
    Params.ParamByName('NOME').AsString := edtPesquisa.Text+'%';
    Open;
  end;
  inherited;
end;

procedure TfrmConsEvento.btTransferirClick(Sender: TObject);
begin
  CodEvento := dm.cdsEventoCODEVENTO.AsInteger;
  inherited;
end;

procedure TfrmConsEvento.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with dm.cdsEvento do
  begin
    Params.ParamByName('NOME').Clear;
    Close;
  end;
  inherited;
end;

procedure TfrmConsEvento.FormShow(Sender: TObject);
begin
  inherited;
  btPesquisa.Click;
end;

end.
