unit uConsGrupo1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uFrmModeloCons, DBCtrls, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls;

type
  TfrmConsGrupo1 = class(TfrmModeloCons)
    DBMemo1: TDBMemo;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btPesquisaClick(Sender: TObject);
    procedure btCadastrarClick(Sender: TObject);
    procedure btAlterarClick(Sender: TObject);
    procedure btExcluirClick(Sender: TObject);
    procedure btTransferirClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConsGrupo1: TfrmConsGrupo1;

implementation

uses uDM, uCadGrupo1, uLib;

{$R *.dfm}

procedure TfrmConsGrupo1.btAlterarClick(Sender: TObject);
begin
  inherited;
  AbreForm(TfrmCadGrupo1, frmCadGrupo1);
end;

procedure TfrmConsGrupo1.btCadastrarClick(Sender: TObject);
begin
  inherited;
  with dm do Inserir(cdsGrupo1);
  AbreForm(TfrmCadGrupo1, frmCadGrupo1);
end;

procedure TfrmConsGrupo1.btExcluirClick(Sender: TObject);
begin
  inherited;
  with dm do Excluir(cdsGrupo1, 'DESCRICAO');
end;

procedure TfrmConsGrupo1.btPesquisaClick(Sender: TObject);
begin
  with dm.cdsGrupo1 do
  begin
    Close;
    Params.ParamByName('DESCRICAO').AsString := edtPesquisa.Text+'%';
    Open;
  end;
  inherited;
end;

procedure TfrmConsGrupo1.btTransferirClick(Sender: TObject);
begin
  CodGrupo1 := dm.cdsGrupo1CODGRUPO.AsInteger;
  inherited;
end;

procedure TfrmConsGrupo1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with dm.cdsGrupo1 do
  begin
    Params.ParamByName('DESCRICAO').Clear;
    Close;
  end;
  inherited;
end;

procedure TfrmConsGrupo1.FormShow(Sender: TObject);
begin
  inherited;
  Label1.Caption := AnsiUpperCase( NOME_GRUPO1 );
  Caption := 'CONSULTA DE ' + AnsiUpperCase( NOME_GRUPO1 );
  //Comente esta prxima linha para no carregar a janela
  //com os grupos j listados
  btPesquisa.Click;
end;

end.
