unit uDM;

interface

uses
  SysUtils, Classes, WideStrings, TBODbxDynalink, DB, SqlExpr, FMTBcd, Provider,
  DBClient, Controls, Forms;

type
  Tdm = class(TDataModule)
    Banco: TSQLConnection;
    qryGrupo1: TSQLQuery;
    qryGrupo1CODGRUPO: TIntegerField;
    qryGrupo1DESCRICAO: TStringField;
    qryGrupo1OBSERVACAO: TMemoField;
    dspGrupo1: TDataSetProvider;
    cdsGrupo1: TClientDataSet;
    qryAux: TSQLQuery;
    cdsGrupo1CODGRUPO: TIntegerField;
    cdsGrupo1DESCRICAO: TStringField;
    cdsGrupo1OBSERVACAO: TMemoField;
    dsGrupo1: TDataSource;
    qryGrupo2: TSQLQuery;
    qryEvento: TSQLQuery;
    qryGrupo2CODGRUPO: TIntegerField;
    qryGrupo2DESCRICAO: TStringField;
    qryGrupo2OBSERVACAO: TMemoField;
    qryEventoCODEVENTO: TIntegerField;
    qryEventoNOME: TStringField;
    qryEventoVALOR: TFMTBCDField;
    qryEventoDATA: TDateField;
    qryEventoHORA: TStringField;
    qryEventoLOCAL: TStringField;
    qryEventoPALESTRANTE: TStringField;
    qryEventoOBSERVACAO: TMemoField;
    dspGrupo2: TDataSetProvider;
    dspEvento: TDataSetProvider;
    cdsGrupo2: TClientDataSet;
    cdsEvento: TClientDataSet;
    dsGrupo2: TDataSource;
    dsEvento: TDataSource;
    cdsGrupo2CODGRUPO: TIntegerField;
    cdsGrupo2DESCRICAO: TStringField;
    cdsGrupo2OBSERVACAO: TMemoField;
    cdsEventoCODEVENTO: TIntegerField;
    cdsEventoNOME: TStringField;
    cdsEventoVALOR: TFMTBCDField;
    cdsEventoDATA: TDateField;
    cdsEventoHORA: TStringField;
    cdsEventoLOCAL: TStringField;
    cdsEventoPALESTRANTE: TStringField;
    cdsEventoOBSERVACAO: TMemoField;
    procedure DataModuleCreate(Sender: TObject);
    procedure ShowDSPUpdateError(Sender: TObject;
      DataSet: TCustomClientDataSet; E: EUpdateError; UpdateKind: TUpdateKind;
      var Response: TResolverResponse);
    procedure dspGrupo1BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
      DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind;
      var Applied: Boolean);
    procedure dspGrupo2BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
      DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind;
      var Applied: Boolean);
    procedure dspEventoBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Cancelar(var aCDS: TClientDataSet);
    procedure Excluir(var aCDS: TClientDataSet; aDialogField: String);
    function GetDeleteErrorMsg(msg: string): string;
    procedure Gravar(var aCDS: TClientDataSet);
    procedure Inserir(var aCDS: TClientDataSet);
  end;

var
  dm: Tdm;

  //variveis que guardaro a configurao dos
  //nomes dos grupos
  NOME_GRUPO1,
  NOME_GRUPO2: String;

  //variveis utilizadas nas consultas
  CodGrupo1,
  CodGrupo2,
  CodEvento,
  CodPessoa: Integer;

implementation

uses uLib;

{$R *.dfm}

procedure Tdm.DataModuleCreate(Sender: TObject);
begin
  NOME_GRUPO1 := 'Curso';
  NOME_GRUPO2 := 'Perodo';

  Banco.KeepConnection := True;
  try
    Banco.Open;
  except
    on E: Exception do
    begin
      Alerta('No foi possvel conectar ao banco de dados:' + #13#10#13#10 +
        E.Message);
      Halt;
    end;
  end;

  ShortDateFormat := 'DD/MM/YYYY';
  ShortTimeFormat := 'HH:NN:SS';
end;

procedure Tdm.dspEventoBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind;
  var Applied: Boolean);
begin
  //se  insero
  if UpdateKind = ukInsert then
  begin
    if SourceDS = qryEvento then
      //se o usurio no informou um cdigo manualmente
      if DeltaDS.FieldByName('CODEVENTO').AsInteger = 0 then
        //gera um ID atravs da funo GetGenValue, da unit uLib.pas
        DeltaDS.FieldByName('CODEVENTO').NewValue :=
          GetGenValue(Banco,'GEN_CODEVENTO',1);
  End;
end;

procedure Tdm.dspGrupo1BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
  DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  //se  insero
  if UpdateKind = ukInsert then
  begin
    if SourceDS = qryGrupo1 then
      //se o usurio no informou um cdigo manualmente
      if DeltaDS.FieldByName('CODGRUPO').AsInteger = 0 then
        //gera um ID atravs da funo GetGenValue, da unit uLib.pas
        DeltaDS.FieldByName('CODGRUPO').NewValue :=
          GetGenValue(Banco,'GEN_CODGRUPO',1);
  End
  //se  alterao
  else if UpdateKind = ukModify then
    //e se o CODGRUPO foi modificado pelo usurio
    if DeltaDS.FieldByName('CODGRUPO').OldValue <>
       DeltaDS.FieldByName('CODGRUPO').NewValue then
    //altera as pessoas vinculadas ao grupo
    begin
      qryAux.Close;
      qryAux.SQL.Text := 'UPDATE PESSOAS SET GRUPO1 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').NewValue) +
        ' WHERE GRUPO1 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').OldValue);
      qryAux.ExecSQL;
    end;
end;

procedure Tdm.dspGrupo2BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
  DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  //se  insero
  if UpdateKind = ukInsert then
  begin
    if SourceDS = qryGrupo2 then
      //se o usurio no informou um cdigo manualmente
      if DeltaDS.FieldByName('CODGRUPO').AsInteger = 0 then
        //gera um ID atravs da funo GetGenValue, da unit uLib.pas
        DeltaDS.FieldByName('CODGRUPO').NewValue :=
          GetGenValue(Banco,'GEN_CODGRUPO2',1);
  End
  //se  alterao
  else if UpdateKind = ukModify then
    //e se o CODGRUPO foi modificado pelo usurio
    if DeltaDS.FieldByName('CODGRUPO').OldValue <>
       DeltaDS.FieldByName('CODGRUPO').NewValue then
    //altera as pessoas vinculadas ao grupo
    begin
      qryAux.Close;
      qryAux.SQL.Text := 'UPDATE PESSOAS SET GRUPO2 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').NewValue) +
        ' WHERE GRUPO2 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').OldValue);
      qryAux.ExecSQL;
    end;
end;

procedure Tdm.ShowDSPUpdateError(Sender: TObject;
  DataSet: TCustomClientDataSet; E: EUpdateError; UpdateKind: TUpdateKind;
  var Response: TResolverResponse);
begin
  raise Exception.Create(E.Message);
end;

function Tdm.GetDeleteErrorMsg(msg: string): string;
begin
  Result := '';
  if pos('violation of FOREIGN KEY', msg)>0 then
    Result := #13#10#13#10+
              'O registro no pde ser excludo porque'+#13#10+
              'possui dependentes!';

  Result := 'Erro ao excluir dados!' + Result;
end;

procedure Tdm.Excluir(var aCDS: TClientDataSet; aDialogField: String);
begin
  with aCDS do
  begin
    if Confirma('Deseja realmente excluir '+
                FieldByName(aDialogField).AsString+' ?') then
    begin

      TRY
        Screen.Cursor := crSQLWait;
        Delete;
        try
          ApplyUpdates(0);
        except
          on E:Exception do
          begin
            Erro(GetDeleteErrorMsg(E.Message));
            CancelUpdates;
            abort;
          end;
        end;
      FINALLY
        Screen.Cursor := crDefault;
      END;

    end;
  end;
end;

procedure Tdm.Gravar(var aCDS: TClientDataSet);
begin
  with aCDS do
  begin
    TRY
      Screen.Cursor := crSQLWait;
      if not (State in dsEditModes) then Edit;
      Post;
      try
        ApplyUpdates(0);
        //Informacao('Dados Gravados com Sucesso!');
      except
        on E: Exception do
        begin
          Erro('Erro ao gravar dados!' + #13#13 +
            'Mensagem Original:' + #13 + E.Message);
          Abort;
        end;
      end;
    FINALLY
      Screen.Cursor := crDefault;
    END;
  end;
end;

procedure Tdm.Inserir(var aCDS: TClientDataSet);
begin
  with aCDS do
  begin
    TRY
      Screen.Cursor := crSQLWait;
      if not Active then Open;
      Append;
    FINALLY
      Screen.Cursor := crDefault;
    END;
  end;
end;

procedure Tdm.Cancelar(var aCDS: TClientDataSet);
begin
  with aCDS do
  begin
    if State in dsEditModes then
      if Confirma('Deseja realmente cancelar?') then
      begin
        Cancel;
        CancelUpdates;
      end
      else
        Abort;

    CancelUpdates;
  end;
end;

end.
