unit UKernel_DATA;

interface

  uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Db, DBTables, StdCtrls, Buttons, Mask, DBCtrls, ADODB,
  IniFiles, Registry, ShellAPI,ComObj, ExtCtrls, DateUtils;

  function DataExtenso(Data:TDateTime): String;   {Data atual por extenso}
  function Datafinal(dataini: tdatetime;  {Incrementa data em Dias}
  dias_uteis: integer): tdatetime;
  function Datafinal2(dataini: tdatetime; {Descrementa data em Dias}
  dias_uteis: integer): tdatetime;
  function DifHora(Inicio, Fim: String): String; // Calcula Hora
  function DifDias(DataVenc:TDateTime; DataAtual:TDateTime): String;  {Diferena entre duas datas}
  function IdadeAtual(Nasc : TDate): Integer; // {Data atual por dia nasc}
  function retornaDia(dt: TDate): string; // Retorna o dia pela data
  function Idade(Data: string): Integer;

implementation

uses UdmPrincipal, UfrmKernel_Mensagem;

function Idade(Data: string): Integer;
var
  ATUAL, NASC: TDateTime;
  ANOS: Real;
begin
  NASC := StrToDate(data);
  ATUAL := Date;
  ANOS := Int((ATUAL - NASC) / 365.25);
  Result :=  StrToInt( FormatFloat('0', ANOS));
end;

Function retornaDia(dt: TDate): string;
var i: Integer;
begin
  Result := '()';
  i := DayOfTheWeek(dt);
  case i of
    1: Result := '(Segunda-feira)';
    2: Result := '(Tera-feira)';
    3: Result := '(Quarta-feira)';
    4: Result := '(Quinta-feira)';
    5: Result := '(Sexta-feira)';
    6: Result := '(Sbado)';
    7: Result := '(Domingo)';
  end;
end;

function DifDias(DataVenc:TDateTime; DataAtual:TDateTime): String;
Var Data: TDateTime;
dia, mes, ano: Word;
begin
  Data := DataAtual - DataVenc;
  DecodeDate( Data, ano, mes, dia);
  Result := FloatToStr(dia);
end;


{-------------------------------------------------------------------------------
  Procedure: IdadeAtual
  Author:    Administrador
  DateTime:  2007.02.21
  Arguments: Nasc : TDate
  Result:    Integer
-------------------------------------------------------------------------------}
function IdadeAtual(Nasc : TDate): Integer;
Var AuxIdade, Meses : String;
  MesesFloat : Real;
  IdadeInc, IdadeReal : Integer;
begin
  AuxIdade := Format('%0.2f', [(Date - Nasc) / 365.6]);
  Meses := FloatToStr(Frac(StrToFloat(AuxIdade)));
  if AuxIdade = '0' then
  begin
  Result := 0;
  Exit;
  end;
  if Meses[1] = '-' then
  begin
  Meses := FloatToStr(StrToFloat(Meses) * -1);
  end;
  Delete(Meses, 1, 2);
  if Length(Meses) = 1 then
  begin
  Meses := Meses + '0';
  end;
  if (Meses <> '0') And (Meses <> '') then
  begin
  MesesFloat := Round(((365.6 * StrToInt(Meses)) / 100) / 30.47)
  end
  else
  begin
  MesesFloat := 0;
  end;
  if MesesFloat <> 12 then
  begin
  IdadeReal := Trunc(StrToFloat(AuxIdade)); // + MesesFloat;
  end
  else
  begin
  IdadeInc := Trunc(StrToFloat(AuxIdade));
  Inc(IdadeInc);
  IdadeReal := IdadeInc;
  end;
  Result := IdadeReal;
end;

{*****************************************************
*  PROCEDURE: Datafinal;
*  FUNO: Incrementa a Data em numero de dias
*
*  PROGRAMADOR: Srgio C. Guedes
*  DATA DE CRIAO: 24/09/06
*******************************************************}
function Datafinal(dataini: tdatetime;
  dias_uteis: integer): tdatetime;
var dw:integer;
begin
  dw := DayOfWeek(dataini)-1;
  result := dataini+dias_uteis;
end;

function Datafinal2(dataini: tdatetime;
  dias_uteis: integer): tdatetime;
var dw:integer;
begin
  dw := DayOfWeek(dataini)-1;
  result := dataini-dias_uteis;
end;


function DifHora(Inicio, Fim: String): String;
{Retorna a diferena entre duas horas}
var
  FIni,FFim : TDateTime;
begin
Fini := StrTotime(Inicio);
FFim := StrToTime(Fim);
If (Inicio > Fim) then
  begin
  Result := TimeToStr((StrTotime('23:59:59')-Fini)+FFim)
  end
else
  begin
  Result := TimeToStr((StrTotime('23:59:59') + StrToTime('00:00:01') -Fini)+FFim);
  end;
end;

{-------------------------------------------------------------------------------
  Procedure: DataExtenso
  Author:    Administrador
  DateTime:  2007.02.21
  Arguments: Data: TDateTime
  Result:    String
-------------------------------------------------------------------------------}
function DataExtenso(Data: TDateTime): String;
{Retorna uma data por extenso}
var
  NoDia : Integer;
  DiaDaSemana : array [1..7] of String;
  Meses : array [1..12] of String;
  Dia, Mes, Ano : Word;
begin
{ Dias da Semana }
  DiaDasemana [1]:= 'Domingo';
  DiaDasemana [2]:= 'Segunda';
  DiaDasemana [3]:= 'Tera';
  DiaDasemana [4]:= 'Quarta';
  DiaDasemana [5]:= 'Quinta';
  DiaDasemana [6]:= 'Sexta';
  DiaDasemana [7]:= 'Sbado';
{ Meses do ano }
  Meses [1] := 'Janeiro';
  Meses [2] := 'Fevereiro';
  Meses [3] := 'Maro';
  Meses [4] := 'Abril';
  Meses [5] := 'Maio';
  Meses [6] := 'Junho';
  Meses [7] := 'Julho';
  Meses [8] := 'Agosto';
  Meses [9] := 'Setembro';
  Meses [10]:= 'Outubro';
  Meses [11]:= 'Novembro';
  Meses [12]:= 'Dezembro';
  DecodeDate (Data, Ano, Mes, Dia);
  NoDia := DayOfWeek (Data);
  Result := DiaDaSemana[NoDia] {+ ', ' +
  IntToStr(Dia) + ' de ' + Meses[Mes]+ ' de ' + IntToStr(Ano)};
end;


end.
