unit UKernel_DB;

interface

  uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Db, DBTables, StdCtrls, Buttons, Mask, DBCtrls, ADODB,
  IniFiles, Registry, ShellAPI,ComObj, ExtCtrls, DBClient, Provider,FMTBcd,
  SqlExpr, Variants ;

  {Incrementa Chave Primaria da tabela}
  function Incrementa(TableName, Campo: String): Integer;
  {Incrementa Chave primaria da tabela detalhe}
  function Incrementa_Itens(TableName, FieldName, Campo : String; CHAVE : Variant): Integer;
  {Atualiza ClientDataSet passado como parametro }
  procedure kernel_RefreshCds (aCds : TClientDataSet);
  { Verifica se o pode excluir o registro, se tem  }
  function kernel_ExisteRelacionamento(str_Tabela, str_Coluna, str_status, str_where : string; int_ValorChave : integer):Boolean;
  {Retorna a data atual do servidor do sql server}
  function Data_Server: Tdatetime;

  {  -- funcoes para auditoria  -----------------}
  //  Inseri o cabealho da auditoria
  Function InseriCabecalhoAuditoria(CODTPAUD, CODUSUCADAUD: integer; MOTIVOAUD, IPAUD, TABELAAUD: string ): Integer;
  //  Inseri os Itens da auditoria
  procedure InseriCabecalhoAuditoriaitm(CODAUD: Integer; CAMPOAUD: string; NOVOVALORAUD, ANTIGOVALORAUD: string );

  procedure Kernel_Atualiza_Registro(str_tabela, str_campo_chave, str_campo_upd: string;
    vrt_valor_chave, vrt_valor_upd : Variant);
  procedure Kernel_Apaga_Registro(str_tabela, str_campo_chave: string; vrt_valor_chave: Variant);

implementation

uses UdmPrincipal, UfrmKernel_Mensagem, UKernel_Mensagem, uKernel_Sistema,
  UKernel_VariaveisPublic;

procedure Kernel_Atualiza_Registro(str_tabela, str_campo_chave, str_campo_upd: string;
  vrt_valor_chave, vrt_valor_upd : Variant);
begin
  FConexao.ExecuteDirect('update '+ str_tabela + ' set ' + str_campo_upd + '='+ QuotedStr(vrt_valor_upd)+
   ' where '+  str_campo_chave+'='+ quotedStr(vrt_valor_chave) );
end;

procedure Kernel_Apaga_Registro(str_tabela, str_campo_chave: string; vrt_valor_chave: Variant);
begin
  FConexao.ExecuteDirect('delete from ' + str_tabela+ ' where ' + str_campo_chave + '=' +
   QuotedStr(vrt_valor_chave) );
end;

function Incrementa(TableName, Campo: String): Integer;
var
  Qry:TsqlQuery;
begin
  qry := TsqlQuery.Create(nil); {: cria uma instncia do objeto}
  try
    with Qry do
    begin
      sqlConnection:= FConexao; {: componente de conexo}
      SQL.Add('SELECT MAX('+Campo+')FROM '+ TableName);
      Open;
      
      if Fields[0].IsNull then {: se a tabela est vazia, retornar nulo}
        Result := 1 {: ento este ser o 1 registro}
       else
        Result := Fields[0].value+1;
    end;
  finally
    FreeAndNil(Qry);  {: libera o objeto da memria}
  end;
end;

function Incrementa_Itens(TableName, FieldName, Campo : String; CHAVE : Variant): Integer;
var
  Qry:TsqlQuery;
  nr: integer;
begin
  qry := TsqlQuery.Create(nil); {: cria uma instncia do objeto}
  try
    with Qry do
    begin
      sqlConnection:= FConexao; {: componente de conexo}
      SQL.Add('SELECT MAX('+ FieldName +')FROM '+ TableName);
      SQL.Add('WHERE ' +  Campo + ' =' + QuotedStr(IntToStr(CHAVE)) );
      Open;
      
      if Fields[0].IsNull then {: se a tabela est vazia, retornar nulo}
        Begin
         nr := 1; {: ento este ser o 1 registro}
         Result:= nr;
       end
      else
       Begin
         nr := Fields[0].value+1;
         Result:= nr;
       end;
    end;
  finally
    FreeAndNil(Qry);  {: libera o objeto da memria}
  end;
end;

procedure kernel_RefreshCds (aCds : TClientDataSet);
begin
  {: atualiza o ClientDataSet (principalmente para Relatrios)}
  aCds.Close;
  aCds.Open;
end;

function Data_Server: Tdatetime;
var
  Qry:TsqlQuery;
begin
  qry := TsqlQuery.Create(nil); {: cria uma instncia do objeto}
  try
    with Qry do
    begin
      sqlConnection:= FConexao; {: componente de conexo}
      Close;
      SQL.Add('select getdate() as DATA');
      Open;

      Result := Fields[0].AsDateTime;
    end;
  finally
    FreeAndNil(Qry);  //: libera o objeto da memria
  end;
{  Result := Date;}
end;


function kernel_ExisteRelacionamento(str_Tabela, str_Coluna, str_status, str_where : string; int_ValorChave : integer):Boolean;
var
  Qry:TsqlQuery;
begin
  Result := False;

  qry := TsqlQuery.Create(nil); {: cria uma instncia do objeto}
  try
    with Qry do
    begin
      sqlConnection:= FConexao; {: componente de conexo}
      Close;
      SQL.Add('SELECT DISTINCT '+str_Coluna+' FROM '+str_Tabela+' WHERE '+str_Coluna+' = '+IntToStr(int_valorChave));

      {se a variavel where estiver algum valor faz o que comando que est na mesma }
      if str_where <> '' then
        begin
          sql.Add(str_where);
        end;
        
      Open;
      
      if IsEmpty then
        Result:=true;
    end;
  finally
    FreeAndNil(Qry);  //: libera o objeto da memria
  end;
end;

//  Inseri os Itens da auditoria
procedure InseriCabecalhoAuditoriaitm(CODAUD: Integer; CAMPOAUD: string; NOVOVALORAUD, ANTIGOVALORAUD: string );
var
  Qry:TSQLQuery;
begin
  qry := TsqlQuery.Create(nil); {: cria uma instncia do objeto}
  try
    with qry do
    Begin
      sqlConnection:= FConexao; {: componente de conexo}
      close;
      SQL.Clear;
      SQL.Add('insert into auditoriaitm (CODAUDITM,CODAUD,CAMPOAUD, NOVOVALORAUD, ANTIGOVALORAUD) values');
      SQL.Add('(:CODAUDITM,:CODAUD, :CAMPOAUD, :NOVOVALORAUD, :ANTIGOVALORAUD)');
      Params[0].Value := Incrementa('AUDITORIAITM','CODAUDITM');
      Params[1].Value := CODAUD;
      Params[2].Value := CAMPOAUD;
      Params[3].Value := NOVOVALORAUD;
      Params[4].Value := ANTIGOVALORAUD;
      ExecSQL();
   end;
  finally
    FreeAndNil(qry);
  end;
end;

//  Inseri o cabealho da auditoria
Function InseriCabecalhoAuditoria(CODTPAUD, CODUSUCADAUD: integer; MOTIVOAUD, IPAUD, TABELAAUD: string ): Integer;
var
  Qry:TSQLQuery;
  cod: Integer;
begin
  qry := TsqlQuery.Create(nil); {: cria uma instncia do objeto}
  try
    with qry do
    Begin
      sqlConnection:= FConexao; {: componente de conexo}
      close;
      SQL.Clear;
      SQL.Add('insert into auditoria (CODAUD, CODTPAUD, CODUSUCADAUD, MOTIVOAUD, IPAUD, TABELAAUD) values');
      SQL.Add('(:CODAUD, :CODTPAUD, :CODUSUCADAUD, :MOTIVOAUD, :IPAUD, :TABELAAUD)');
      cod:= Incrementa('AUDITORIA','CODAUD');
      Params[0].Value := cod;
      Params[1].Value := CODTPAUD;
      Params[2].Value := CODUSUCADAUD;
      Params[3].Value := MOTIVOAUD;
      Params[4].Value := SysComputerName;
      Params[5].Value := TABELAAUD;              
      ExecSQL();

      Result:= cod;
   end;
  finally
    FreeAndNil(qry);
  end;
end;

end.
