unit UKernel_SysUtils;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Db, DBTables, StdCtrls, Buttons, Mask, DBCtrls, ADODB,
  IniFiles, Registry, ShellAPI,ComObj, ExtCtrls, ACBrValidador, ACBrBase,
  Variants, DBClient;

  procedure AbreForm (aClasseForm : TComponentClass; aForm: TForm);
  procedure GerarExcel(Consulta:TADOQuery);

  function Gerapercentual(valor:real;Percent:Real):real;
  function GeraValor(valor:real; Percent:Real):real;

  Procedure Load_Imagem_abertura;
  procedure MostraFotoImage(ImagemPrincipal, ImagemAlternativa: string; Image: TImage);

  // Funcoes de Calculos e Formatacoes de Valores
  function CalculaMargem(Venda, Compra :Currency): Currency;
  Function CalculaPrVenda(Compra, Margem: string): Currency;

  // Mostra a Versao do Sistema
  function GetVersaoArq: string;
  // Valida Documentos usandl acbrvalidador
  function ValidaCampos(Objeto: string; WinControl: TWinControl;
   TipoDoc: TACBrValTipoDocto ): Boolean;

  Function RetiraPonto(Valor: double):double;
  
  // Corrigindo o problema do foco no aparecer no componente    s
  procedure SetFocusCtrl(Ctrl: TWinControl; ActiveCtrl: TWinControl);

  //Funcoes de auditoria
  procedure  RetornaLog(DeltaDs: TCustomClientDataSet; UpdateKing: TUpdateKind; Tabela: string);

  procedure CriaAguarde(aClasseForm: TComponentClass; aForm: TForm);
  procedure DestroyAguarde(aForm: TForm);

  procedure InicializaVariaveis;
  {Carega propriedades do Projeto do xml}
  procedure Kernel_CaregaPropriedades;

  {Pedi confirma}
  function Kernel_Confirmacao_acao(str_msn_acao: string; str_acao: char):Boolean;

  function Kernel_DiretorioBarras(Folder: string): string;

implementation

uses UfrmKernel_Splash, UKernel_Mensagem, UfrmKernel_Mensagem,  UKernel_Registry,
  UKernel_DB, UdmPrincipal, uKernel_Sistema,  UKernel_VariaveisPublic,
  csDXFunctions, UKernel_Exception;

function Kernel_DiretorioBarras(Folder: string): string;
begin
  if Trim(Folder) <> '' then
    if Folder[Length(Folder)] <> '\' then
      Kernel_DiretorioBarras := Folder + '\'
    else
      Kernel_DiretorioBarras := Folder;
end;


procedure Kernel_CaregaPropriedades;
var
  Cds : TClientDataSet;
  str_arquivo: string;
begin
  try
    Cds := TClientDataSet.Create(nil);

    {recebe arquivo que contem configuracoes do projeto}
    str_arquivo  :=RegReadStr(Kernel_RegLivreFrame + 'Config', 'CurrentProject');
    
    Cds.FileName := str_arquivo;

    if FileExists(str_arquivo) then
      Begin
        Cds.Open;      
        {Passa propriedades do projeto para a classe}
        Kernel_PropriedadesProjeto.str_ImagemSplash   := Cds.FieldByName('splash').AsString;
        Kernel_PropriedadesProjeto.str_Background     := Cds.FieldByName('background').AsString;
        Kernel_PropriedadesProjeto.str_TituloPrograma := Cds.FieldByName('title').AsString;
        Kernel_PropriedadesProjeto.str_SoftHouse      := Cds.FieldByName('company').AsString;
      End
     else
      Begin
        raise Livre_Mensagem_Global.CreateFmt('Arquivo %s de configuraoes do projeo no foi encontrado ',['(NomedoProjeto.xpr)']);
        application.terminate; 
      End;
  finally
    FreeAndNil(Cds);
  end;
end;

function Kernel_Confirmacao_acao(str_msn_acao: string; str_acao: char):Boolean;
begin
  result := (TFrmKernel_Mensagem.Mensagem(str_msn_acao,str_acao,[mbSim, mbNao]));
end;

procedure InicializaVariaveis;
begin
  {Caminho do sistema}
  kernel_str_caminhosis :=  ExtractFilePath(ParamStr(0));

  {Traduo do QuantumGrid 6}
  TcsDXFunctions.Translate_PTBR;
end;

procedure DestroyAguarde(aForm: TForm);
begin
  {Se existir objeto na memoria libera}
  if Assigned(aForm) then
    FreeAndNil(aform);
end;

procedure CriaAguarde(aClasseForm: TComponentClass; aForm: TForm);
begin
  {Se no existir objeto na memoria libera}
  if not Assigned(aForm) then
    Application.CreateForm(aClasseForm, aForm);
    
  aForm.Show; // Mostra form de aguarde
  // Atualiza a tela e processa as mensagens
  aForm.Update;
  Application.ProcessMessages;
end;

{Funo resposanvel pela gerao de logs dos cadastros -  auditoria}
procedure RetornaLog(DeltaDs: TCustomClientDataSet;
  UpdateKing: TUpdateKind; Tabela: string);
  var
  i, Chave: Integer;
  sNewValue, sOldValue: string;
  StlLog: TStringList;
begin
  StlLog := TStringList.Create;

  {Verifica qual o tipo de atualizao feita - insert ou delete }
  if UpdateKing in [ukInsert, ukDelete] then
  begin
    if UpdateKing = ukDelete then
      //Inseri cabealho
      Chave:= InseriCabecalhoAuditoria(3, Kernel_Login.int_codusu, kernel_str_DescExclusao, SysComputerName, tabela) // excluido
     else
      Chave:= InseriCabecalhoAuditoria(1, Kernel_Login.int_codusu, 'Novo Registro Inserido', SysComputerName, tabela); // inserido

    // percorre todos os campos para verificar as alteracoes
    for I := 0 to DeltaDs.FieldCount - 1 do
    begin
      // se o campo nao for nulo adiciona na tabela
      if not DeltaDs.Fields[i].IsNull then
      begin
        // Inseri itens Incluidos ou excluidos
        InseriCabecalhoAuditoriaitm(Chave, DeltaDs.Fields[i].FieldName ,DeltaDs.Fields[i].AsString,'' );
      end;
    end;
  end;// fim

  {Verifica qual o tipo de atualizao feita - insert ou delete }
  if UpdateKing in [ukModify] then
  begin
    //Inseri cabealho
    Chave:= InseriCabecalhoAuditoria(3, Kernel_Login.int_codusu, 'O Registro foi alterado', SysComputerName, tabela); // alterado

    // percorre todos os campos para verificar as alteracoes
    for I := 0 to DeltaDs.FieldCount - 1 do
    begin
      { se nao houver nada no valor novo no campo ou no no valor antigo o
      campo nao foi alterado }
      if VarIsEmpty(DeltaDs.Fields[i].NewValue) or VarIsEmpty(DeltaDs.Fields[i].oldValue) then
        Continue; // pula pro proximo campo

      {se o valor novo do campo for diferente do valor antigo
       o campo foi alterado}
      if DeltaDs.Fields[i].NewValue<> DeltaDs.Fields[i].OldValue then
      begin

        // se o valor for nulo entao escreve null no log
        if VarIsNull(DeltaDs.Fields[i].NewValue) then
          sNewValue := 'null'
         else
          // se o campo for branco escreve '' no log
          if VarToStr(DeltaDs.Fields[i].NewValue) = '' then
            sNewValue := ''
           else
            // Grava o valor o novo valor do Log
            sNewValue := VarToStr(DeltaDs.Fields[i].NewValue);

        // ---- ANTIGO VALOR ----------------------------------    
        // se o valor for nulo entao escreve null no log
        if VarIsNull(DeltaDs.Fields[i].oldValue) then
          soldValue := 'null'
         else
          // se o campo for branco escreve '' no log
          if VarToStr(DeltaDs.Fields[i].oldValue) = '' then
            sOldValue := ''
           else
            // Grava o valor o Antigo valor do Log
            soldValue := VarToStr(DeltaDs.Fields[i].oldValue);

        // Grava Log com as alteraes realizada no campo
        InseriCabecalhoAuditoriaitm(Chave, DeltaDs.Fields[i].FieldName ,sNewValue, sOldValue);
      end;
    end;
  end; // fim
end;

// Corrigindo o problema do foco no aparecer no componente
procedure SetFocusCtrl(Ctrl: TWinControl; ActiveCtrl: TWinControl);
begin
  Ctrl := ActiveCtrl;
  ActiveCtrl := nil;
  PostMessage(TWinControl(Ctrl).Handle, WM_SETFOCUS, 0, 0);
  TWinControl(Ctrl).SetFocus;
end;

procedure MostraFotoImage(ImagemPrincipal, ImagemAlternativa: string; Image: TImage);
var
 Caminho2 : string;
begin
  Caminho2 := '';
  // Mostra a Imagem do produto
  Caminho2 := kernel_str_CaminhoSis + 'Imagens\LogoTipos\'+ ImagemPrincipal + '.gif';
  if FileExists(Caminho2) then
    begin
      Image.Picture.LoadFromFile(Caminho2);
    end
   else
    begin
      // Se no Existir imagem do produto mostra fotopadra
      Caminho2 := kernel_str_CaminhoSis + 'Imagens\LogoTipos\'+ ImagemAlternativa + '.gif';
      if FileExists(Caminho2) then
        Begin
          Image.Picture.LoadFromFile(Caminho2);
        end;
    end;
end;

Function RetiraPonto(Valor: double):double;
var
 buffer: string;
Begin
  buffer :=  FloatToStr(Valor);

  while Pos('.', buffer) > 0 do
  buffer[Pos('.', buffer)] := ',';

  Result := StrToFloat(buffer);
end;

Function CalculaPrVenda(Compra, Margem: string): Currency;
var
  Venda, Soma: Currency;
begin
  Venda   :=  StrToFloat(Compra);
  Soma    := ( StrToCurr(compra) * StrToCurr(margem))/100;
  Result  :=  Venda+Soma;
end;

function CalculaMargem(Venda, Compra :Currency): Currency;
var
  Soma: Currency;
begin
  //  Soma   :=  StrToCurr(Venda) / StrToCurr(Compra);
  Soma :=  ((Venda*100) /compra);
  Result := Soma;
end;     

function ValidaCampos( Objeto: string; WinControl: TWinControl;
  TipoDoc: TACBrValTipoDocto ): Boolean;
var
 valid: TACBrValidador;
Begin
  valid :=  TACBrValidador.Create(nil); {: cria uma instncia do objeto}
  try
    Result := False;

    valid.Documento     := Objeto ;
    Objeto              := valid.Formatar ;
    valid.TipoDocto     := TipoDoc;

    if valid.Validar then
      Result := True
    else
     begin
      TfrmKernel_Mensagem.Mensagem(valid.MsgErro ,'E',[mbOK]);
      exit;
      WinControl.SetFocus;
      exit;
     end;
  finally
    valid.Free; {: libera o objeto da memria}
  end;
end;

procedure AbreForm(aClasseForm: TComponentClass; aForm: TForm);
begin
  {: metodo para abrir form}
  Application.CreateForm(aClasseForm, aForm);
  try
    aForm.ShowModal;
  finally
    aForm.Free;
  end;
end;

procedure GerarExcel(Consulta:TADOQuery);
var
  coluna, linha: integer;
  excel: variant;
  valor: string;
begin
  try
    excel:=CreateOleObject('Excel.Application');
    excel.Workbooks.add(1);
  except
    Application.MessageBox ('Verso do Ms-Excel'+
      'Incompatvel','Erro',MB_OK+MB_ICONEXCLAMATION);
  end;
  Consulta.First;
  try
    for linha:=0 to Consulta.RecordCount-1 do
    begin
      for coluna:=1 to Consulta.FieldCount do
      begin
        valor:= Consulta.Fields[coluna-1].AsString; excel.cells [linha+2,coluna]:=valor;
      end;
    Consulta.Next;
    end;
    for coluna:=1 to Consulta.FieldCount do
    begin
       valor:= Consulta.Fields[coluna-1].DisplayLabel;
       excel.cells[1,coluna]:=valor;
    end;
      excel.columns.AutoFit;
      excel.visible:=true;
   except
      Application.MessageBox ('Aconteceu um erro desconhecido durante a converso'+
      'da tabela para o Ms-Excel','Erro',MB_OK+MB_ICONEXCLAMATION);
   end;
end;

function Gerapercentual(valor:real; Percent:Real):real;
// Retorna a porcentagem de um valor
begin
  percent := percent / 100;
  try
    valor := valor * Percent;
  finally
    result := valor;
  end;
end;

function GeraValor(valor:real; Percent:Real):real;
  // Retorna a porcentagem de um valor
begin
  percent := percent * 100;
  try
    valor := valor / Percent;
  finally
    result := valor;
  end;
end;

Procedure Load_Imagem_abertura;
 var
 str_image: string;
begin
  // Cria Splash na memoria
  Application.CreateForm(TfrmKernel_Splash, frmKernel_Splash);
  with frmKernel_Splash do
  begin
    str_image := kernel_str_CaminhoSis + '\Imagens\logoempresa.jpg';
    // se existir image do plash  carega
    If FileExists(str_image) Then
     Begin
       imgSplash.Picture.LoadFromFile(str_image);
       imgSplash.Refresh;
     End;
   
    Show;

    // Carega Versao do Sistema

    //lblVersao.Caption := GetVersaoArq;
    imgSplash.Update;
    //lblSisNm_Empresa.Caption := SisNm_Empresa;
    imgSplash.Update;
    //lblempresa.Caption:='Licenciado para : '+ 'Empresa Teste' ;
    imgSplash.Update;
  end;

  Sleep(1000);
End;

function GetVersaoArq: string;
var
  VerInfoSize: DWORD;
  VerInfo: Pointer;
  VerValueSize: DWORD;
  VerValue: PVSFixedFileInfo;
  Dummy: DWORD;
begin
  VerInfoSize := GetFileVersionInfoSize(PChar(
    ParamStr(0)), Dummy);
  GetMem(VerInfo, VerInfoSize);
  GetFileVersionInfo(PChar(ParamStr(0)), 0,
    VerInfoSize, VerInfo);
  VerQueryValue(VerInfo, '\', Pointer(VerValue),
    VerValueSize);
  with VerValue^ do
  begin
    Result := IntToStr(dwFileVersionMS shr 16);
    Result := Result + '.' + IntToStr(
      dwFileVersionMS and $FFFF);
    Result := Result + '.' + IntToStr(
      dwFileVersionLS shr 16);
    Result := Result + '.' + IntToStr(
      dwFileVersionLS and $FFFF);
  end;
  FreeMem(VerInfo, VerInfoSize);
end;


end.
