{
  Propriedade
  get = Ler o valor da propriedade
  set = Grava o valor da propriedade
}
unit UclKernel_Conexao;

interface

uses
  SysUtils, IniFiles;

type
  TKernel_Conexao = class
  private
    {Declara as vriaveiss para guardar valor das propriedades}
    Fstr_server: string;
    Fstr_database: string;
    Fstr_usuario: string;
    Fstr_senha: string;

    function Getstr_server: string;
    procedure Setstr_server(const Value: string);
    function Getstr_database: string;
    procedure Setstr_database(const Value: string);
    function Getstr_senha: string;
    function Getstr_usuario: string;
    procedure Setstr_senha(const Value: string);
    procedure Setstr_usuario(const Value: string);

    procedure CaregaConexao;

  public
    // Guarda o nome do servidor de db
    property str_server: string read Getstr_server write Setstr_server;
    // Guarda o nome do banco de dados
    property str_database: string read Getstr_database write Setstr_database;
    // Guarda o nome do usuario do db
    property str_usuario: string read Getstr_usuario write Setstr_usuario;
    // Guarda o nome da senha do db    
    property str_senha: string read Getstr_senha write Setstr_senha;        

    Constructor Create();
    Destructor Destroy();
  end;

implementation

uses UKernel_Mensagem, Ukernel_Config;

{ TKernel_Conexao }

procedure TKernel_Conexao.CaregaConexao;
begin
  { Carega os parametros de conexao do arquivo ini }
  str_server     := LerTexto('CONEXAO','SERVIDOR');
  str_database   := LerTexto('CONEXAO','BANCO');
  str_usuario    := LerTexto('CONEXAO','USUARIO');
  str_senha      := LerTexto('CONEXAO','SENHA');
end;

constructor TKernel_Conexao.Create;
begin
  CaregaConexao;
end;

destructor TKernel_Conexao.Destroy;
begin
  //
end;

function TKernel_Conexao.Getstr_database: string;  // Ler
begin
  Getstr_database := Fstr_database;
end;

function TKernel_Conexao.Getstr_senha: string; // Ler
begin
  Getstr_senha := Fstr_senha;
end;

function TKernel_Conexao.Getstr_server: string; // Ler
begin
  Getstr_server := Fstr_server;
end;

function TKernel_Conexao.Getstr_usuario: string; // Ler
begin
  Getstr_usuario := Fstr_usuario;
end;

procedure TKernel_Conexao.Setstr_database(const Value: string);// Grava
begin
  Fstr_database :=  value;
end;

procedure TKernel_Conexao.Setstr_senha(const Value: string); // Grava
begin
  {Se a senha for vazia assume o vazio padrao do user sa do sql server}
  if Value <> '' then
    Fstr_senha :=  value
   else
    Fstr_senha := '12345';
end;

procedure TKernel_Conexao.Setstr_server(const Value: string); // Grava
begin
  Fstr_server :=  value;
end;

procedure TKernel_Conexao.Setstr_usuario(const Value: string); // Grava
begin
  {Se a senha for vazia assume o usuario sa padrao do sql server}
  if Value <> '' then
    Fstr_usuario :=  value
   else
    Fstr_usuario := 'syn_livre';
end;

end.
