unit UdmKernelPrincipal;

interface

uses
  SysUtils, Classes, WideStrings, ADODB, DB, SqlExpr, Dialogs, Forms,
  FMTBcd, DBXDynalink, DbxMsSql;

type
  TdmKernelPrincipal = class(TDataModule)
    qryKernel_Gerenerica: TSQLQuery;
    conPrincipalKernel: TSQLConnection;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private

  public
    procedure ConectaServidor; virtual;
    procedure DesconectaServidor; virtual;
  end;

var
  dmKernelPrincipal: TdmKernelPrincipal;

implementation

uses UKernel_VariaveisPublic // Unit de variaveis publicas a todo kernel
 , UclKernel_Conexao, UclKernel_Login, UclKernel_PropriedadesProjeto;

{$R *.dfm}

procedure TdmKernelPrincipal.ConectaServidor;
begin
  with conPrincipalKernel DO
  begin
    Connected := False;
    try
      Params.Clear;
      Params.Add('DriverName=MSSQL');
      Params.Add('HostName='   + Kernel_Conexao.str_server);
      Params.Add('DataBase='   + Kernel_Conexao.str_database);
      Params.Add('User_Name='  + Kernel_Conexao.str_usuario);
      Params.Add('Password='   + Kernel_Conexao.str_senha);

      Params.Add('BlobSize=-1');
      Params.Add('ErrorResourceFile=');
      Params.Add('LocaleCode=0000');
      Params.Add('MSSQL TransIsolation=ReadCommited');
      Params.Add('OS Authentication=False');
      Params.Add('Prepare SQL=False');
      Connected := True;

    except on E: Exception do
      begin
        MessageDlg('Ocorreu um erro ao conectar-se ao banco.' + #13 +
          E.Message, mtError, [mbOk], 0);

        Application.Terminate;
      end;
    end;
  end;
end;

procedure TdmKernelPrincipal.DataModuleCreate(Sender: TObject);
begin
  {Instancia Classe de parametros de conexao com o banco}
  Kernel_Conexao := TKernel_Conexao.Create;

  {Instancia Classe de parametros de conexao com o banco}
  Kernel_login := TKernel_Login.Create;

  {Instancia Classe de parametros de Propriedades do Projeto}  
  Kernel_PropriedadesProjeto := TKernel_PropriedadesProjeto.create;

  {Tenta se conectar ao Servidor}
  ConectaServidor;
end;

procedure TdmKernelPrincipal.DataModuleDestroy(Sender: TObject);
begin
  {Libera objetos da memoria}
  Kernel_Conexao.Free;
  Kernel_login.Free;
  Kernel_PropriedadesProjeto.Free;

  {Desconecta do servidor}
  DesconectaServidor;
end;

procedure TdmKernelPrincipal.DesconectaServidor;
begin
  conPrincipalKernel.Connected := False;
end;

end.
